/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.internal.CommandPresentationStrategyWrapper;
import org.eclipse.swt.internal.qt.CommandPresentationStrategy;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CommandArranger {
    Control focusedControl;
    private CommandCollection currentCommands = new CommandCollection();
    private CommandPresentationStrategy strategy = CommandPresentationStrategyWrapper.createStrategy();
    private Command defaultCommand;

    public void menuBarChanged(Decorations decorations) {
        if (this.currentCommands == null || this.currentCommands.getSize() < 1) {
            return;
        }
        if (decorations.getShell() != decorations.getDisplay().getActiveShell()) {
            return;
        }
        int n = decorations.internal_getOwnMenuBar();
        this.strategy.handleMenuBarChanged(n, this.currentCommands);
    }

    public void focusedControlChanged() {
        Display display = Display.getCurrent();
        Control control = display.getFocusControl();
        if (control == this.focusedControl) {
            return;
        }
        this.focusedControl = control;
        Shell shell = display.getActiveShell();
        CommandCollection commandCollection = this.currentCommands;
        this.currentCommands = new CommandCollection();
        for (Control control2 = control; control2 != null && control2 != shell; control2 = control2.getParent()) {
            if (Command.internal_getCommands(control2).length <= 0) continue;
            this.currentCommands.addCommand(Command.internal_getCommands(control2));
        }
        if (shell != null && Command.internal_getCommands(shell).length > 0) {
            this.currentCommands.addCommand(Command.internal_getCommands(shell));
        }
        if (this.strategy != null) {
            this.strategy.handleFocusChange(control, commandCollection, this.currentCommands);
        }
    }

    public void commandAdded(Command command) {
        if (this.isInFocusContext(command.control)) {
            this.currentCommands.addCommand(command);
            this.strategy.handleCommandListChange(command, null, this.currentCommands);
        }
    }

    public void commandRemoved(Command command) {
        if (command == this.defaultCommand) {
            this.defaultCommand = null;
        }
        if (this.isInFocusContext(command.control)) {
            this.currentCommands.removeCommand(command);
            this.strategy.handleCommandListChange(null, command, this.currentCommands);
        }
    }

    public void dispose() {
        this.strategy.dispose();
        this.strategy = null;
        this.currentCommands = null;
    }

    public void setDefaultCommand(Command command) {
        this.defaultCommand = command;
        this.strategy.handleDefaultCommandChange(command);
    }

    public Command getDefaultCommand() {
        return this.defaultCommand;
    }

    public void setPresentationStrategy(CommandPresentationStrategy commandPresentationStrategy) {
        CommandPresentationStrategy commandPresentationStrategy2 = this.strategy;
        this.strategy = commandPresentationStrategy;
        if (commandPresentationStrategy2 != null) {
            commandPresentationStrategy2.dispose();
        }
    }

    private boolean isInFocusContext(Control control) {
        Display display = control.getDisplay();
        Shell shell = display.getActiveShell();
        for (Control control2 = display.getFocusControl(); control2 != null; control2 = control2.getParent()) {
            if (control2 != control && control2 != shell) continue;
            return true;
        }
        return false;
    }

    public class CommandCollection {
        private Command[] fCommands;

        CommandCollection() {
        }

        void addCommand(Command command) {
            if (command == null) {
                return;
            }
            if (this.fCommands == null) {
                this.fCommands = new Command[1];
                this.fCommands[0] = command;
                return;
            }
            int n = this.fCommands.length + 1;
            Command[] commandArray = new Command[n];
            int n2 = 0;
            Display display = Display.getCurrent();
            Shell shell = display.getActiveShell();
            for (Control control = display.getFocusControl(); control != null && control != shell; control = control.getParent()) {
                if (control == command.control) {
                    ++n2;
                    break;
                }
                n2 += Command.internal_getCommands(control).length;
            }
            System.arraycopy(this.fCommands, 0, commandArray, 0, n2);
            System.arraycopy(this.fCommands, n2, commandArray, n2 + 1, this.fCommands.length - n2);
            commandArray[n2] = command;
            this.fCommands = commandArray;
        }

        void addCommand(Command[] commandArray) {
            if (commandArray == null || commandArray.length == 0) {
                return;
            }
            if (this.fCommands == null) {
                this.fCommands = new Command[commandArray.length];
                System.arraycopy(commandArray, 0, this.fCommands, 0, commandArray.length);
                return;
            }
            int n = commandArray.length + this.fCommands.length;
            Command[] commandArray2 = new Command[n];
            System.arraycopy(this.fCommands, 0, commandArray2, 0, this.fCommands.length);
            System.arraycopy(commandArray, 0, commandArray2, this.fCommands.length, commandArray.length);
            this.fCommands = commandArray2;
        }

        void removeCommand(Command command) {
            if (command == null) {
                return;
            }
            if (this.fCommands == null || this.fCommands.length == 0) {
                return;
            }
            int n = -1;
            for (int i = 0; i < this.fCommands.length; ++i) {
                if (this.fCommands[i] != command) continue;
                n = i;
            }
            if (n == -1) {
                return;
            }
            Command[] commandArray = new Command[this.fCommands.length - 1];
            System.arraycopy(this.fCommands, 0, commandArray, 0, n);
            System.arraycopy(this.fCommands, n + 1, commandArray, n, this.fCommands.length - n - 1);
            this.fCommands = commandArray;
        }

        public int getSize() {
            int n = 0;
            if (this.fCommands != null) {
                n = this.fCommands.length;
            }
            return n;
        }

        public Command[] getCommands(int[] nArray) {
            if (nArray == null || nArray.length == 0) {
                return this.fCommands;
            }
            int n = this.getSize();
            Command[] commandArray = new Command[n];
            int n2 = 0;
            block0: for (int i = 0; i < this.fCommands.length; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (this.fCommands[i].type != nArray[j]) continue;
                    commandArray[n2] = this.fCommands[i];
                    ++n2;
                    continue block0;
                }
            }
            if (n > n2) {
                Command[] commandArray2 = new Command[n2];
                System.arraycopy(commandArray, 0, commandArray2, 0, n2);
                return commandArray2;
            }
            return commandArray;
        }
    }
}

