/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.internal.qt.CommandArranger;
import org.eclipse.swt.internal.qt.CommandPresentationStrategy;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.QObjectDeleteWrapper;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DesktopCommandPresentationStrategy
extends CommandPresentationStrategy {
    private int commandsMenu;
    private int commandsMenuAction;
    private Control previousFocus;

    public DesktopCommandPresentationStrategy() {
        this.initCommandsMenu();
    }

    protected void handleCommandListChange(Command command, Command command2, CommandArranger.CommandCollection commandCollection) {
        Shell shell = null;
        if (command != null) {
            shell = command.control.getShell();
            OS.QMenu_addAction(this.commandsMenu, command.handle);
        } else {
            shell = command2.control.getShell();
            OS.QWidget_removeAction(this.commandsMenu, command2.handle);
        }
        OS.QMenuBar_addAction(shell.internal_getOwnMenuBar(), this.commandsMenuAction);
    }

    protected void handleFocusChange(Control control, CommandArranger.CommandCollection commandCollection, CommandArranger.CommandCollection commandCollection2) {
        int n;
        Command[] commandArray;
        Shell shell = control.getShell();
        if (commandCollection != null && commandCollection.getSize() > 0) {
            commandArray = commandCollection.getCommands(null);
            for (n = 0; n < commandArray.length; ++n) {
                if (this.previousFocus != null && commandArray[n].control == this.previousFocus) {
                    OS.QWidget_removeAction(this.previousFocus.handle, commandArray[n].handle);
                    continue;
                }
                OS.QWidget_removeAction(this.commandsMenu, commandArray[n].handle);
            }
        }
        if (commandCollection2 != null && commandCollection2.getSize() > 0) {
            OS.QMenuBar_addAction(shell.internal_getOwnMenuBar(), this.commandsMenuAction);
            commandArray = commandCollection2.getCommands(null);
            this.sort(commandArray);
            for (n = 0; n < commandArray.length; ++n) {
                if (commandArray[n].control != control) {
                    OS.QMenu_addAction(this.commandsMenu, commandArray[n].handle);
                } else {
                    OS.QWidget_addAction(control.handle, commandArray[n].handle);
                }
                if (!commandArray[n].isDefaultCommand()) continue;
                OS.QMenu_setDefaultAction(this.commandsMenu, commandArray[n].handle);
            }
        }
        this.previousFocus = control;
    }

    protected void handleMenuBarChanged(int n, CommandArranger.CommandCollection commandCollection) {
        OS.QMenuBar_addAction(n, this.commandsMenuAction);
    }

    protected void dispose() {
        if (this.commandsMenu != 0) {
            QObjectDeleteWrapper.deleteSafely(this.commandsMenu);
            this.commandsMenu = 0;
        }
        if (this.commandsMenuAction != 0) {
            QObjectDeleteWrapper.deleteSafely(this.commandsMenuAction);
            this.commandsMenuAction = 0;
        }
    }

    private void initCommandsMenu() {
        this.commandsMenuAction = OS.QAction_new(0);
        OS.QAction_setText(this.commandsMenuAction, "Commands");
        this.commandsMenu = OS.QMenu_new(0);
        OS.QAction_setMenu(this.commandsMenuAction, this.commandsMenu);
    }

    protected void handleDefaultCommandChange(Command command) {
        int n = 0;
        if (command != null) {
            n = command.handle;
        }
        OS.QMenu_setDefaultAction(this.commandsMenu, n);
    }

    void sort(Command[] commandArray) {
        int n = commandArray.length;
        if (n <= 1) {
            return;
        }
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = i; j < n; ++j) {
                for (int k = j - i; k >= 0; k -= i) {
                    if (commandArray[k].getPriority() >= commandArray[k + i].getPriority()) continue;
                    Command command = commandArray[k];
                    commandArray[k] = commandArray[k + i];
                    commandArray[k + i] = command;
                }
            }
        }
    }
}

