/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class TextUtils {
    public static final int LINE_EDIT = 0;
    public static final int TEXT_EDIT = 1;

    public static void append(int n, int n2, String string, int n3, Widget widget) {
        int n4;
        if (string == null) {
            SWT.error(4);
        }
        if ((string = TextUtils.verify(n, n2, string, widget, n3, n4 = TextUtils.getCharCount(n, n2), n4)) == null) {
            return;
        }
        if (n == 0) {
            OS.QLineEdit_end(n2, false);
            OS.QLineEdit_insert(n2, string);
        } else {
            OS.QTextEdit_swt_append(n2, string);
        }
    }

    public static void clearSelection(int n, int n2) {
        if (n == 0) {
            OS.QLineEdit_setCursorPosition(n2, OS.QLineEdit_cursorPosition(n2));
        } else {
            OS.QTextEdit_swt_clearSelection(n2);
        }
    }

    public static void copy(int n, int n2) {
        if (n == 0) {
            OS.QLineEdit_copy(n2);
        } else {
            OS.QTextEdit_copy(n2);
        }
    }

    public static void cut(int n, int n2, Widget widget) {
        Point point = TextUtils.getSelection(n, n2);
        String string = TextUtils.verify(n, n2, "", widget, -1, Math.min(point.x, point.y), Math.max(point.x, point.y));
        if (string == null) {
            return;
        }
        if (n == 0) {
            OS.QLineEdit_cut(n2);
        } else {
            OS.QTextEdit_cut(n2);
        }
        if (!string.equals("")) {
            if (n == 0) {
                OS.QLineEdit_insert(n2, string);
            } else {
                OS.QTextEdit_insertPlainText(n2, string);
            }
        }
    }

    public static boolean getReadOnly(int n, int n2) {
        if (n == 0) {
            return OS.QLineEdit_isReadOnly(n2);
        }
        return OS.QTextEdit_isReadOnly(n2);
    }

    public static Point getSelection(int n, int n2) {
        if (n == 0) {
            int n3 = OS.QLineEdit_selectionStart(n2);
            if (n3 == -1) {
                int n4 = OS.QLineEdit_cursorPosition(n2);
                return new Point(n4, n4);
            }
            return new Point(n3, n3 + OS.QLineEdit_selectedText(n2).length());
        }
        int n5 = OS.QTextEdit_swt_selectionStart(n2);
        int n6 = OS.QTextEdit_swt_selectionEnd(n2);
        return new Point(Math.min(n5, n6), Math.max(n5, n6));
    }

    public static String getSelectionText(int n, int n2) {
        if (n == 0) {
            return OS.QLineEdit_selectedText(n2);
        }
        return OS.QTextEdit_swt_getSelectionText(n2);
    }

    public static int getCaretPosition(int n, int n2) {
        if (n == 0) {
            return OS.QLineEdit_cursorPosition(n2);
        }
        return OS.QTextEdit_swt_getCaretPosition(n2);
    }

    public static int getCharCount(int n, int n2) {
        if (n == 0) {
            return OS.QLineEdit_text(n2).length();
        }
        return OS.QTextEdit_swt_getCharCount(n2);
    }

    public static String getText(int n, int n2) {
        if (n == 0) {
            return OS.QLineEdit_text(n2);
        }
        return OS.QTextEdit_toPlainText(n2);
    }

    public static void insert(int n, int n2, String string, int n3, Widget widget) {
        if (string == null) {
            SWT.error(4);
        }
        Point point = TextUtils.getSelection(n, n2);
        if ((string = TextUtils.verify(n, n2, string, widget, n3, Math.min(point.x, point.y), Math.max(point.x, point.y))) == null) {
            return;
        }
        if (n == 0) {
            OS.QLineEdit_insert(n2, string);
        } else {
            OS.QTextEdit_insertPlainText(n2, string);
        }
    }

    public static void paste(int n, int n2, int n3, Widget widget) {
        Point point = TextUtils.getSelection(n, n2);
        String string = TextUtils.verify(n, n2, OS.QClipboard_text(), widget, n3, Math.min(point.x, point.y), Math.max(point.x, point.y));
        if (string == null) {
            return;
        }
        if (n == 0) {
            OS.QLineEdit_insert(n2, string);
        } else {
            OS.QTextEdit_insertPlainText(n2, string);
        }
    }

    public static void selectAll(int n, int n2) {
        if (n == 0) {
            OS.QLineEdit_selectAll(n2);
        } else {
            OS.QTextEdit_swt_selectAll(n2);
        }
    }

    public static void setReadOnly(int n, int n2, boolean bl) {
        if (n == 0) {
            OS.QLineEdit_setReadOnly(n2, bl);
        } else {
            OS.QTextEdit_setReadOnly(n2, bl);
        }
    }

    public static void setSelection(int n, int n2, int n3, int n4) {
        int n5 = TextUtils.getCharCount(n, n2);
        n3 = Math.min(Math.max(0, n3), n5);
        n4 = Math.min(Math.max(0, n4), n5);
        if (n == 0) {
            OS.QLineEdit_setSelection(n2, n3, n4 - n3);
        } else {
            OS.QTextEdit_swt_setCursorPosition(n2, n3, true);
            OS.QTextEdit_swt_setCursorPosition(n2, n4, false);
        }
    }

    public static void setText(int n, int n2, String string, int n3, Widget widget) {
        if (string == null) {
            SWT.error(4);
        }
        if ((string = TextUtils.verify(n, n2, string, widget, n3, 0, TextUtils.getCharCount(n, n2))) == null) {
            return;
        }
        if (n == 0) {
            OS.QLineEdit_setText(n2, string);
            OS.QLineEdit_setCursorPosition(n2, 0);
        } else {
            OS.QTextEdit_setPlainText(n2, string);
        }
    }

    public static boolean handle_keypress(int n, int n2, int n3, int n4, int n5, Event event, int n6, Widget widget) {
        int n7;
        int n8;
        String string;
        block20: {
            block22: {
                block21: {
                    block19: {
                        string = "" + (char)n5;
                        Point point = TextUtils.getSelection(n, n2);
                        n8 = point.x;
                        n7 = point.y;
                        if ((n4 != 0x2000000 || n3 != 0x1000006) && (n4 != 0x4000000 || n3 != 86)) break block19;
                        string = OS.QClipboard_text();
                        if (string == null || string.equals("")) {
                            return false;
                        }
                        event = null;
                        break block20;
                    }
                    if ((n4 != 0x2000000 || n3 != 0x1000007) && (n4 != 0x4000000 || n3 != 88)) break block21;
                    if (n7 == n8) {
                        return false;
                    }
                    event = null;
                    string = "";
                    break block20;
                }
                if ((n4 & 0x4000000) != 0 && n3 == 0x1000007 || (n4 & 0x4000000) != 0 && n3 == 0x1000003 || (n4 & 0x8000000) != 0 && n3 == 0x1000003 || n4 == 0x4000000 && n3 == 75) {
                    return true;
                }
                if ((n3 & 0x1000000) == 0) break block22;
                switch (n3) {
                    case 0x1000004: 
                    case 0x1000005: {
                        if (n == 0) {
                            return false;
                        }
                        break block20;
                    }
                    case 0x1000003: {
                        if (n7 == n8) {
                            if (n8 == 0) {
                                return false;
                            }
                            --n8;
                        }
                        string = "";
                        break block20;
                    }
                    case 0x1000007: {
                        if (n4 != 0) {
                            return false;
                        }
                        if (n7 == n8) {
                            if (n7 == TextUtils.getCharCount(n, n2)) {
                                return false;
                            }
                            ++n7;
                        }
                        string = "";
                        break block20;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if ((n4 & 0x4000000) != 0 && ((char)n5 < ' ' || (char)n5 == '\u007f')) {
                return false;
            }
        }
        String string2 = TextUtils.verify(n, n2, string, widget, n6, n8, n7, event);
        if (string2 == null) {
            return true;
        }
        if (string2.equals(string)) {
            return false;
        }
        TextUtils.setSelection(n, n2, n8, n7);
        if (n == 0) {
            OS.QLineEdit_insert(n2, string2);
        } else {
            OS.QTextEdit_insertPlainText(n2, string2);
        }
        return true;
    }

    public static String verify(int n, int n2, String string, Widget widget, int n3, int n4, int n5) {
        return TextUtils.verify(n, n2, string, widget, n3, n4, n5, null);
    }

    public static String verify(int n, int n2, String string, Widget widget, int n3, int n4, int n5, Event event) {
        if (string.length() == 0 && n4 == n5) {
            return null;
        }
        if (widget != null && (widget.getStyle() & 4) != 0) {
            string = string.replace('\n', ' ');
        }
        if (widget != null) {
            Event event2 = new Event();
            event2.text = string;
            event2.start = n4;
            event2.end = n5;
            if (event != null) {
                event2.keyCode = event.keyCode;
                event2.character = event.character;
                event2.stateMask = event.stateMask;
            } else {
                event2.keyCode = 0;
                event2.character = '\u0000';
                event2.stateMask = 0;
            }
            widget.notifyListeners(25, event2);
            if (!event2.doit || widget.isDisposed()) {
                return null;
            }
            string = event2.text;
        }
        if (n3 > 0 && string.length() > 0) {
            int n6 = 0;
            n6 = n == 0 ? OS.QLineEdit_text(n2).length() : OS.QTextEdit_swt_getCharCount(n2);
            int n7 = n3 - n6 + (n5 - n4);
            int n8 = Math.min(Math.max(0, n7), string.length());
            string = string.substring(0, n8);
        }
        if (string == null || string.length() == 0 && n4 == n5) {
            return null;
        }
        return string;
    }
}

