/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import org.eclipse.swt.internal.qt.graphics.OS;
import org.eclipse.swt.internal.qt.graphics.Utils;

public final class Buffer {
    int handle = 0;
    boolean disposed;

    public Buffer() {
        Utils.validateUiThread();
        this.handle = OS.buffer_init();
        if (this.handle == 0) {
            throw new OutOfMemoryError("Native buffer creation failed");
        }
    }

    public void dispose() {
        if (!this.disposed) {
            OS.buffer_dispose(this.handle);
            this.handle = 0;
            this.disposed = true;
        }
    }

    public void getInvalidRect(int[] nArray) {
        this.checkState();
        if (nArray == null) {
            throw new NullPointerException("rect is null");
        }
        if (nArray.length < 4) {
            throw new IllegalArgumentException("rect array size is < 4");
        }
        OS.buffer_getInvalidRect(this.handle, nArray);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void checkState() {
        Utils.validateUiThread();
        if (this.disposed) {
            throw new IllegalStateException("Buffer already disposed");
        }
    }
}

