/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.internal.qt.graphics.SurfaceCacheItemDisposeListener;
import org.eclipse.swt.internal.qt.graphics.WindowSurface;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

final class SurfaceCache {
    private Hashtable surfaces = new Hashtable();
    private boolean isDisposeListenerSet = false;
    private static SurfaceCache instance = null;
    private static boolean disposed = false;

    static SurfaceCache getInstance() {
        if (disposed) {
            return null;
        }
        if (instance == null) {
            instance = new SurfaceCache();
        }
        return instance;
    }

    private SurfaceCache() {
    }

    void addSurface(WindowSurface windowSurface, Object object, boolean bl) {
        if (disposed) {
            throw new IllegalStateException("Cache already disposed");
        }
        if (windowSurface == null || object == null) {
            throw new NullPointerException("Parameter surface or target is null");
        }
        if (this.surfaces.containsKey(object)) {
            return;
        }
        this.surfaces.put(object, windowSurface);
        if (object instanceof Widget) {
            if (!this.isDisposeListenerSet) {
                this.setDisposeListener(((Widget)object).getDisplay());
            }
            if (bl) {
                ((Widget)object).addDisposeListener(new SurfaceCacheItemDisposeListener());
            }
        }
    }

    void deleteSurface(Object object) {
        if (disposed) {
            throw new IllegalStateException("Cache already disposed");
        }
        if (object == null) {
            throw new NullPointerException("Parameter target is null");
        }
        if (this.surfaces.containsKey(object)) {
            this.surfaces.remove(object);
        }
    }

    WindowSurface getSurface(Object object) {
        if (disposed) {
            throw new IllegalStateException("Cache already disposed");
        }
        if (object == null) {
            throw new NullPointerException("Parameter target is null");
        }
        return (WindowSurface)this.surfaces.get(object);
    }

    boolean isDisposed() {
        return disposed;
    }

    void dispose() {
        if (disposed) {
            return;
        }
        if (this.surfaces == null) {
            return;
        }
        if (this.surfaces.size() == 0) {
            return;
        }
        Enumeration enumeration = this.surfaces.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ((WindowSurface)this.surfaces.get(k)).dispose();
            this.surfaces.remove(k);
        }
        disposed = true;
        this.surfaces = null;
    }

    private void setDisposeListener(Display display) {
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SurfaceCache.getInstance().dispose();
            }
        });
        this.isDisposeListenerSet = true;
    }
}

