/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import org.eclipse.swt.internal.qt.graphics.OS;
import org.eclipse.swt.internal.qt.graphics.Utils;

public final class WindowSurface {
    static final int QImage = 1;
    static final int PBuffer = 2;
    private int handle;
    private boolean disposed;

    WindowSurface(int n) {
        this.handle = n;
        this.disposed = false;
    }

    public int getType() {
        this.checkState();
        int n = OS.windowsurface_getType(this.handle);
        return n;
    }

    public int getHandle() {
        this.checkState();
        return this.handle;
    }

    public void dispose() {
        Utils.validateUiThread();
        if (this.handle != 0) {
            OS.windowsurface_dispose(this.handle);
            this.handle = 0;
        }
    }

    private void checkState() {
        Utils.validateUiThread();
        if (this.disposed) {
            throw new IllegalStateException("WindowSurface already disposed");
        }
    }
}

