/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    String dialogID;
    static int dialogCount;

    public ColorDialog(Shell shell) {
        this(shell, 0);
        this.dialogID = this.toString() + String.valueOf(++dialogCount);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, shell == null ? n : ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
        this.dialogID = this.toString() + String.valueOf(++dialogCount);
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int n = 0;
        n = OS.QColor_new();
        if (this.rgb != null) {
            OS.QColor_setRed(n, this.rgb.red);
            OS.QColor_setGreen(n, this.rgb.green);
            OS.QColor_setBlue(n, this.rgb.blue);
        }
        DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (disposeEvent.widget == ColorDialog.this.parent) {
                    OS.QDialog_swt_closeDialogs(ColorDialog.this.parent.handle, ColorDialog.this.dialogID);
                }
            }
        };
        this.parent.addDisposeListener(disposeListener);
        int n2 = OS.QColorDialog_getColor(n, this.parent.handle, this.dialogID);
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.removeDisposeListener(disposeListener);
        }
        OS.QColor_delete(n);
        if (n2 == 0 || !OS.QColor_isValid(n2)) {
            return null;
        }
        int n3 = OS.QColor_red(n2);
        int n4 = OS.QColor_blue(n2);
        int n5 = OS.QColor_green(n2);
        this.rgb = new RGB(n3, n5, n4);
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

