/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.QObjectDeleteWrapper;
import org.eclipse.swt.internal.qt.SharedGCWrapper;
import org.eclipse.swt.internal.qt.graphics.Buffer;
import org.eclipse.swt.internal.qt.graphics.GraphicsContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    Composite parent;
    Menu menu;
    Font font;
    boolean toolTipTextExists;
    Object layoutData;
    Color foreground;
    Color background;
    Image backgroundImage;
    private Command[] commandList;
    protected boolean traverseDoit;
    protected boolean traverseCancel;
    Vector bufferedGcs;
    Vector gcBuffers;
    private byte isPainting;
    boolean bufferFlush;

    Control() {
    }

    public Control(Composite composite, int n) {
        this(composite, n, 0);
    }

    protected Control(Composite composite, int n, int n2) {
        super(composite, n, n2);
        this.parent = composite;
        this.createWidget(0);
        int n3 = this.internal_topHandle();
        OS.QWidget_setParent(n3, composite.handle);
        OS.QWidget_resize(n3, 0, 0);
        if (this.isParentMirrored()) {
            Point point = OS.QWidget_size(n3);
            OS.QWidget_move(n3, composite.getClientWidth() - point.x, 0);
        }
        OS.QWidget_setVisible(n3, true);
        this.parent.addControl(this);
    }

    void addCommand(Command command) {
        if (command.control != this) {
            return;
        }
        if (this.commandList == null) {
            this.commandList = new Command[1];
            this.commandList[0] = command;
            return;
        }
        int n = this.commandList.length;
        for (int i = 0; i < n; ++i) {
            if (this.commandList[i] != command) continue;
            return;
        }
        Command[] commandArray = new Command[n + 1];
        System.arraycopy(this.commandList, 0, commandArray, 0, n);
        commandArray[n] = command;
        this.commandList = commandArray;
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyBackgroundColor(Color color) {
        int n = OS.QWidget_swt_palette_new(this.internal_topHandle());
        try {
            this.setPaletteBgColor(n, color);
            OS.QWidget_setPalette(this.internal_topHandle(), n);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            OS.QPalette_delete(n);
            throw throwable;
        }
        OS.QPalette_delete(n);
        this.updateAutoFillBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyBackgroundImage(Image image) {
        int n = OS.QWidget_swt_palette_new(this.internal_topHandle());
        try {
            this.setPaletteBgImage(n, image);
            OS.QWidget_setPalette(this.internal_topHandle(), n);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            OS.QPalette_delete(n);
            throw throwable;
        }
        OS.QPalette_delete(n);
        this.updateAutoFillBackground();
    }

    protected void backgroundImageApplied(Image image) {
    }

    protected void backgroundImageInherited(Image image) {
    }

    protected boolean canInheritBackgroundImage() {
        return true;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFF7FFF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0) {
                this.state |= 0x8000;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    protected void checkBorder() {
        int n = this.internal_frameHandle();
        if (n != 0) {
            if ((this.style & 0x800) == 0) {
                OS.QFrame_setFrameStyle(n, 0);
            } else {
                int n2 = OS.QFrame_frameShape(n);
                if ((n2 & 7) == 0) {
                    OS.QFrame_setFrameStyle(n, n2 | 6);
                }
            }
        }
        if (this.getBorderWidth() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkBuffered() {
        this.style &= 0xDFFFFFFF;
    }

    void checkMirrored() {
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
        }
    }

    void checkNoBackground() {
        this.style &= 0xFFFBFFFF;
    }

    void checkNoFocus() {
    }

    void checkNoRedrawResize() {
        this.style &= 0xFFEFFFFF;
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.QWidget_updateGeometry(this.internal_topHandle());
        }
        Point point = OS.QWidget_sizeHint(this.internal_topHandle());
        if (point.x < 0) {
            point.x = 64;
        }
        if (point.y < 0) {
            point.y = 64;
        }
        int n3 = this.getBorderWidth();
        if (n != -1) {
            point.x = n + 2 * n3;
        }
        if (n2 != -1) {
            point.y = n2 + 2 * n3;
        }
        return point;
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n;
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void createWidget(int n) {
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.checkBuffered();
        this.checkMirrored();
        this.checkBorder();
        this.checkNoBackground();
        this.checkNoRedrawResize();
        this.checkNoFocus();
        this.checkBackground();
        if ((this.style & 0x4000000) != 0) {
            OS.QWidget_setLayoutDirection(this.internal_topHandle(), 1);
        } else {
            OS.QWidget_setLayoutDirection(this.internal_topHandle(), 0);
        }
        this.setBackground();
    }

    boolean doHandleMouseEvent(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.isEnabled()) {
            this.mouseToParent(n, n2, n3, n4, n5, n6, n7);
            return true;
        }
        Point point = this.mapToClientArea(n2, n4, n5);
        return this.sendMouseEvent(n, n3, false, point.x, point.y, n6, n7);
    }

    boolean doProcessShortCut(int n, int n2, int n3) {
        Event event = this.sendTraverseEvent(128, n, n2, n3);
        if (this.isDisposed()) {
            return true;
        }
        if (event.doit && this.doTraversal(event)) {
            return true;
        }
        this.sendKeyEvent(1, n, n2, n3);
        return true;
    }

    protected void doRedraw() {
        OS.QWidget_update(this.handle);
    }

    protected void doRedraw(int n, int n2, int n3, int n4) {
        OS.QWidget_update(this.handle, n, n2, n3, n4);
    }

    boolean doTraversal(Event event) {
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    void enableWidget(boolean bl) {
        OS.QWidget_setEnabled(this.internal_topHandle(), bl);
    }

    Control findBackgroundControl() {
        if (this.background != null || this.backgroundImage != null) {
            return this;
        }
        return (this.state & 0x8000) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    Control findNextControl(boolean bl) {
        Composite composite = this.getParent();
        if (composite == null) {
            return null;
        }
        Control control = null;
        boolean bl2 = false;
        Control[] controlArray = composite._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control2 = controlArray[i];
            if (!bl2) {
                if (!control2.equals(this)) continue;
                bl2 = true;
                continue;
            }
            control = controlArray[i];
        }
        if (control == null && bl && controlArray.length > 0 && controlArray[0] != this) {
            control = controlArray[0];
        }
        return control;
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFixedFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
        int n = OS.QApplication_desktop();
        if (n != 0) {
            OS.QWidget_setFocus(n, 7);
        }
    }

    void flushBuffers() {
        if (this.bufferedGcs != null) {
            for (int i = 0; i < this.bufferedGcs.size(); ++i) {
                GraphicsContext graphicsContext = (GraphicsContext)this.bufferedGcs.elementAt(i);
                Buffer buffer = (Buffer)this.gcBuffers.elementAt(i);
                graphicsContext.releaseTarget();
                graphicsContext.bindTarget(this);
                graphicsContext.render(buffer);
                graphicsContext.releaseTarget();
                graphicsContext.bindTarget(buffer, this);
            }
        }
    }

    public boolean forceFocus() {
        this.checkWidget();
        return this.forceFocus(7);
    }

    protected boolean forceFocus(int n) {
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        decorations.setSavedFocus(null);
        decorations.bringToTop(false);
        if (OS.windowServer == 2) {
            this.waitXRequestComplete();
            if (this.isDisposed()) {
                return false;
            }
        }
        OS.QWidget_setFocus(this.handle, n);
        if (this.isDisposed()) {
            return false;
        }
        decorations.setSavedFocus(this);
        if (OS.windowServer == 2) {
            return true;
        }
        return this._isFocusControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getBackground() {
        int[] nArray;
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.background != null) {
            return Color.qt_new(this.display, control.background.handle);
        }
        int n = 0;
        try {
            n = OS.QWidget_swt_palette_new(this.internal_topHandle());
            nArray = OS.QPalette_color(n, 0, this.getBackgroundColorRole());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            OS.QPalette_delete(n);
            throw throwable;
        }
        OS.QPalette_delete(n);
        return Color.qt_new(this.display, nArray[0] & 0xFF | (nArray[1] & 0xFF) << 8 | (nArray[2] & 0xFF) << 16);
    }

    int getBackgroundColorRole() {
        return 10;
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    protected int[] getBackgroundColorRoles() {
        return new int[]{10, 9, 1};
    }

    protected int[] getBackgroundImageRoles() {
        return new int[]{10, 9};
    }

    public int getBorderWidth() {
        this.checkWidget();
        int n = this.internal_frameHandle();
        if (n != 0) {
            return OS.QFrame_frameWidth(n);
        }
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = OS.QWidget_frameGeometry(this.internal_topHandle());
        if (this.isParentMirrored()) {
            rectangle.x = this.parent.getClientWidth() - rectangle.width - rectangle.x;
        }
        return rectangle;
    }

    int getClientWidth() {
        return OS.QWidget_rect((int)this.handle).width;
    }

    Command[] getCommands() {
        return this.commandList == null ? new Command[]{} : this.commandList;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this._getEnabled();
    }

    boolean _getEnabled() {
        return (this.state & 0x10) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : Font.qt_new(this.display, OS.SwtFontCache_cache(OS.QWidget_swt_font_new(this.internal_topHandle())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getForeground() {
        int[] nArray;
        this.checkWidget();
        if (this.foreground != null) {
            return Color.qt_new(this.display, this.foreground.handle);
        }
        int n = 0;
        try {
            n = OS.QWidget_swt_palette_new(this.handle);
            nArray = OS.QPalette_color(n, 0, this.getForegroundColorRole());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            OS.QPalette_delete(n);
            throw throwable;
        }
        OS.QPalette_delete(n);
        this.foreground = Color.qt_new(this.display, nArray[0] & 0xFF | (nArray[1] & 0xFF) << 8 | (nArray[2] & 0xFF) << 16);
        return Color.qt_new(this.display, this.foreground.handle);
    }

    int getForegroundColorRole() {
        return 0;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        Point point = OS.QWidget_pos(this.internal_topHandle());
        if (this.isParentMirrored()) {
            point.x = this.parent.getClientWidth() - point.x - OS.QWidget_geometry((int)this.internal_topHandle()).width;
        }
        return point;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getParentClientWidth() {
        if (this.parent != null) {
            return this.parent.getClientWidth();
        }
        return this.display.getClientArea().width;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    Control getShortcutHandler() {
        return this.display.getFocusControl();
    }

    public Point getSize() {
        this.checkWidget();
        return OS.QWidget_frameSize(this.internal_topHandle());
    }

    public String getToolTipText() {
        this.checkWidget();
        String string = null;
        if (this.toolTipTextExists) {
            string = OS.QWidget_toolTip(this.handle);
        }
        return string;
    }

    int getTraversalTypeForKey(int n, int n2, int n3) {
        int n4 = -1;
        switch (n) {
            case 0x1000000: {
                if (n2 != 0) break;
                n4 = 2;
                break;
            }
            case 0x1000004: 
            case 0x1000005: {
                if (n2 != 0 && ((n2 | 0x20000000) == 0 || n != 0x1000005)) break;
                n4 = 4;
                break;
            }
            case 0x1000001: {
                if (n2 != 0) break;
                n4 = 16;
                break;
            }
            case 0x1000002: {
                if ((n2 & 0xFDFFFFFF) != 0) break;
                n4 = 8;
                break;
            }
            case 0x1000012: 
            case 0x1000013: 
            case 0x1000014: 
            case 0x1000015: {
                boolean bl;
                if (n2 != 0) break;
                boolean bl2 = bl = n == 0x1000015 || n == 0x1000014;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (n == 0x1000012 || n == 0x1000014)) {
                    bl = !bl;
                }
                n4 = bl ? 16 : 8;
                break;
            }
            case 0x1000016: 
            case 0x1000017: {
                if (n2 != 0) break;
                n4 = n == 0x1000017 ? 512 : 256;
                break;
            }
        }
        return n4;
    }

    public boolean getVisible() {
        this.checkWidget();
        return !OS.QWidget_isHidden(this.internal_topHandle());
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        int n2;
        this.checkWidget();
        gCData.internalGc.releaseTarget();
        if (gCData.internalGc == SharedGCWrapper.getSharedGC()) {
            return;
        }
        if (this.bufferedGcs != null && (n2 = this.bufferedGcs.indexOf(gCData.internalGc)) >= 0) {
            this.bufferedGcs.removeElementAt(n2);
            this.gcBuffers.removeElementAt(n2);
        }
        gCData.internalGc.dispose();
    }

    protected int internal_frameHandle() {
        return 0;
    }

    public boolean internal_isDisposed() {
        return this.isDisposed();
    }

    public int internal_new_GC(GCData gCData) {
        GraphicsContext graphicsContext;
        this.checkWidget();
        gCData.internalGc = this.isPainting > 0 && (graphicsContext = SharedGCWrapper.getSharedGC()) != null ? graphicsContext : new GraphicsContext();
        gCData.drawable = OS.QWidget_swt_paintDevice(this.handle);
        gCData.device = this.display;
        gCData.background = this.getBackground();
        gCData.foreground = this.getForeground();
        gCData.font = this.getFont();
        int n = 0x6000000;
        if ((gCData.style & n) == 0) {
            gCData.style |= this.style & (n | 0x8000000);
        } else if ((gCData.style & 0x4000000) != 0) {
            gCData.style |= 0x8000000;
        }
        if (this.isPainting > 0) {
            gCData.buffered = false;
            gCData.internalGc.bindTarget(this);
        } else {
            gCData.buffered = true;
            if (this.bufferedGcs == null) {
                this.bufferedGcs = new Vector();
            }
            if (this.gcBuffers == null) {
                this.gcBuffers = new Vector();
            }
            Buffer buffer = new Buffer();
            gCData.internalGc.bindTarget(buffer, this);
            this.bufferedGcs.addElement(gCData.internalGc);
            this.gcBuffers.addElement(buffer);
        }
        return gCData.internalGc.getHandle();
    }

    boolean isActive() {
        Shell shell;
        Dialog dialog = this.display.getModalDialog();
        if (dialog != null && (shell = dialog.parent) != null && !shell.isDisposed() && shell != this.getShell()) {
            return false;
        }
        shell = null;
        Shell[] shellArray = this.display.modalShells;
        if (shellArray != null) {
            int n = 196608;
            int n2 = shellArray.length;
            while (--n2 >= 0) {
                Shell shell2 = shellArray[n2];
                if (shell2 == null) continue;
                if ((shell2.style & n) != 0) {
                    Control control = this;
                    while (control != null && control != shell2) {
                        control = control.parent;
                    }
                    if (control == shell2) break;
                    return false;
                }
                if ((shell2.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (shell2.parent != shell) continue;
                return false;
            }
        }
        if (shell == null) {
            shell = this.getShell();
        }
        return shell.getEnabled();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this._isFocusControl() && !this.isDisposed();
    }

    boolean _isFocusControl() {
        int n = this.handle;
        int n2 = OS.QWidget_focusProxy(this.handle);
        if (n2 != 0) {
            n = n2;
        }
        return OS.QApplication_focusWidget() == n;
    }

    boolean isMirrored() {
        return (this.style & 0x8000000) != 0;
    }

    boolean isParentMirrored() {
        if (this.parent != null) {
            return this.parent.isMirrored();
        }
        return false;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSize();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return true;
            }
        }
        return ((n = OS.QWidget_focusPolicy(this.internal_topHandle())) & 1) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return false;
            }
        }
        return ((n = OS.QWidget_focusPolicy(this.internal_topHandle())) & 1) == 0;
    }

    boolean isTraversalKey(int n, int n2, int n3) {
        return this.getTraversalTypeForKey(n, n2, n3) != -1;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Event makeMouseEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        Event event = new Event();
        event.button = Display.translateButton(n2);
        event.detail = 0;
        event.count = 0;
        event.x = this.isMirrored() ? this.getClientWidth() - n3 : n3;
        event.y = n4;
        event.stateMask = Display.translateModifiers(n5) | Display.translateButtons(n6);
        event.stateMask &= ~Display.translateButtons(n2);
        if (n == 4) {
            event.stateMask |= Display.translateButtons(n2);
        }
        return event;
    }

    Point mapToClientArea(int n, int n2, int n3) {
        if (n == this.handle) {
            return new Point(n2, n3);
        }
        Point point = OS.QWidget_mapToGlobal(n, n2, n3);
        return OS.QWidget_mapFromGlobal(this.handle, point.x, point.y);
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    void mouseToParent(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Composite composite = this.getParent();
        if (composite != null) {
            Point point = composite.mapToClientArea(n2, n4, n5);
            Event event = composite.makeMouseEvent(n, n3, point.x, point.y, n6, n7);
            event.widget = composite;
            event.type = n;
            this.display.post(event);
        }
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            Control control2 = null;
            int n = 0;
            n = this.parent == null ? Display.handle : this.parent.handle;
            int[] nArray = OS.QObject_children(n);
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                Widget widget;
                if (!bl && nArray[i] == control.internal_topHandle()) {
                    bl = true;
                    continue;
                }
                if (!bl || (widget = this.display.getWidget(nArray[i])) == null || widget == this || !(widget instanceof Control)) continue;
                control2 = (Control)widget;
                break;
            }
            if (control2 != null) {
                this.moveBelow(control2);
            } else {
                OS.QWidget_raise(this.internal_topHandle());
            }
        } else {
            OS.QWidget_raise(this.internal_topHandle());
        }
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            OS.QWidget_stackUnder(this.internal_topHandle(), control.internal_topHandle());
        } else {
            OS.QWidget_lower(this.internal_topHandle());
        }
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.setSize(this.computeSize(-1, -1, bl));
    }

    boolean qt_event_contextmenu(int n, int n2, int n3) {
        Event event = new Event();
        event.x = n;
        event.y = n2;
        this.sendEvent(35, event);
        if (event.doit && !this.isDisposed()) {
            int n4;
            int[] nArray = OS.QWidget_actions(this.handle);
            if ((nArray == null || nArray.length == 0) && this.menu == null) {
                return true;
            }
            int n5 = 0;
            n5 = this.menu == null || this.menu.isDisposed() ? OS.QMenu_new(this.handle) : this.menu.handle;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                OS.QMenu_addAction(n5, nArray[n4]);
            }
            OS.QMenu_exec(n5, event.x, event.y, 0);
            for (n4 = 0; n4 < nArray.length; ++n4) {
                OS.QWidget_removeAction(n5, nArray[n4]);
            }
            if (this.menu == null || this.menu.isDisposed()) {
                QObjectDeleteWrapper.deleteSafely(n5);
            }
        }
        return true;
    }

    protected boolean qt_event_focusIn(int n) {
        return false;
    }

    protected boolean qt_event_focusOut(int n) {
        return false;
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2;
        if (!this.hasFocus()) {
            return true;
        }
        int n5 = this.getTraversalTypeForKey(n2, n3, n4);
        boolean bl3 = bl2 = n5 != -1;
        if (bl2) {
            Event event = this.sendTraverseEvent(n5, n2, n3, n4);
            if (this.isDisposed()) {
                return true;
            }
            if (event.doit && this.doTraversal(event)) {
                return true;
            }
        }
        if (bl = super.qt_event_keypress(n, n2, n3, n4)) {
            return true;
        }
        return bl2 ? this.traverseCancel : false;
    }

    protected boolean qt_event_keyrelease(int n, int n2, int n3, int n4) {
        if (!this.hasFocus()) {
            return true;
        }
        if ((this.state & 0x2000000) != 0 && n != this.handle) {
            return true;
        }
        return this.sendKeyEvent(2, n2, n3, n4);
    }

    protected boolean qt_event_mouseButtonDblClick(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.state & 0x4000000) != 0 && n != this.handle) {
            return true;
        }
        return this.doHandleMouseEvent(8, n, n2, n3, n4, n5, n6);
    }

    protected boolean qt_event_mouseButtonPress(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.state & 0x4000000) != 0 && n != this.handle) {
            return true;
        }
        return this.doHandleMouseEvent(3, n, n2, n3, n4, n5, n6);
    }

    protected boolean qt_event_mouseButtonRelease(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.state & 0x4000000) != 0 && n != this.handle) {
            return true;
        }
        return this.doHandleMouseEvent(4, n, n2, n3, n4, n5, n6);
    }

    boolean qt_event_mouseMove(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.doHandleMouseEvent(5, n, n2, n3, n4, n5, n6);
    }

    protected void qt_swt_event_widgetMoved(int n) {
        if (n == this.internal_topHandle()) {
            this.sendEvent(10);
        }
    }

    protected void qt_swt_event_widgetResized(int n, int n2, int n3, int n4, int n5) {
        if (n == this.internal_topHandle()) {
            this.sendEvent(11);
        }
    }

    boolean qt_event_shortcut(int n, int n2, int n3) {
        this.display.mnemonicControl = this;
        Control control = this.getShortcutHandler();
        if (control == null) {
            return false;
        }
        return control.doProcessShortCut(n, n2, n3);
    }

    void qt_swt_event_bufferFlush() {
        this.bufferFlush = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void qt_swt_event_focusWasGained() {
        try {
            this.display.focusEvent = 15;
            this.sendEvent(15);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.display != null && !this.display.isDisposed()) {
                this.display.focusEvent = 0;
            }
            throw throwable;
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.focusEvent = 0;
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.commandArranger.focusedControlChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void qt_swt_event_focusWasLost() {
        try {
            this.display.focusEvent = 16;
            this.sendEvent(16);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.display != null && !this.display.isDisposed()) {
                this.display.focusEvent = 0;
            }
            throw throwable;
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.focusEvent = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void qt_swt_event_widgetPainted(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.isPainting = 1;
            this.qt_swt_event_widgetPainted_handler(n, n2, n3, n4, n5, n6);
            Object var8_7 = null;
            this.isPainting = 0;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.isPainting = 0;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void qt_swt_event_widgetPainted_handler(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.state & 0x40) != 0) {
            return;
        }
        if (n != this.handle) {
            return;
        }
        this.flushBuffers();
        if (this.bufferFlush) {
            this.bufferFlush = false;
            return;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return;
        }
        GC gC = new GC(this);
        Event event = new Event();
        event.count = 0;
        event.x = this.isMirrored() ? this.getClientWidth() - n2 - n4 : n2;
        event.y = n3;
        event.width = n4;
        event.height = n5;
        event.gc = gC;
        try {
            event.gc.setClipping(n2, n3, n4 - 1, n5 - 1);
            this.sendEvent(9, event);
            Object var10_9 = null;
            if (gC.isDisposed()) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (gC.isDisposed()) throw throwable;
            if (this.isDisposed()) {
                GCData gCData = gC.getGCData();
                gCData.internalGc.releaseTarget();
            }
            gC.dispose();
            throw throwable;
        }
        if (this.isDisposed()) {
            GCData gCData = gC.getGCData();
            gCData.internalGc.releaseTarget();
        }
        gC.dispose();
    }

    public void redraw() {
        this.checkWidget();
        this.doRedraw();
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (this.isMirrored()) {
            n = this.getClientWidth() - n - n3;
        }
        this.doRedraw(n, n2, n3, n4);
        if (bl) {
            this.redrawChildren();
        }
    }

    void redrawChildren() {
    }

    protected void releaseChildren(boolean bl) {
        Command[] commandArray = this.getCommands();
        for (int i = 0; i < commandArray.length; ++i) {
            Command command = commandArray[i];
            if (command == null || command.isDisposed()) continue;
            command.dispose();
        }
        super.releaseChildren(bl);
    }

    protected void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    protected void releaseParent() {
        this.parent.removeControl(this);
    }

    protected void releaseWidget() {
        super.releaseWidget();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.layoutData = null;
        this.background = null;
        this.foreground = null;
    }

    void removeCommand(Command command) {
        if (command.control != this) {
            return;
        }
        if (this.commandList == null || this.commandList.length == 0) {
            return;
        }
        if (this.commandList.length == 1 && command == this.commandList[0]) {
            this.commandList = null;
            return;
        }
        int n = this.commandList.length;
        Command[] commandArray = new Command[n - 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (command == this.commandList[i]) continue;
            commandArray[n2] = this.commandList[i];
            ++n2;
        }
        if (n2 == commandArray.length) {
            this.commandList = commandArray;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    boolean sendMouseEvent(int n, int n2, boolean bl, int n3, int n4, int n5, int n6) {
        Event event = this.makeMouseEvent(n, n2, n3, n4, n5, n6);
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return true;
            }
        } else {
            this.postEvent(n, event);
        }
        return !event.doit;
    }

    Event sendTraverseEvent(int n, int n2, int n3, int n4) {
        Event event = this.makeKeyEvent(n2, n3, n4);
        event.detail = n;
        event.stateMask = Display.translateModifiers(n3);
        this.setTraversalFlags(n, n2, n3, n4);
        event.doit = this.traverseDoit;
        if (this.hooks(31) || this.filters(31)) {
            this.sendEvent(31, event);
        }
        return event;
    }

    protected void setBackground() {
        if (this.backgroundImage != null) {
            this.applyBackgroundImage(this.backgroundImage);
            return;
        }
        if (this.background != null) {
            this.applyBackgroundColor(this.background);
            return;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.applyBackgroundImage(control.backgroundImage);
            return;
        }
        this.applyBackgroundColor(control.background);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.background == null && color == null) {
            return;
        }
        this.background = color == null ? null : Color.qt_new(this.display, color.handle);
        this.updateBackground();
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image == null && this.backgroundImage == null) {
            return;
        }
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
        this.updateBackground();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = 0;
        int n6 = this.internal_topHandle();
        Point point = OS.QWidget_size(n6);
        Point point2 = OS.QWidget_pos(n6);
        if (bl2 && (point.x != n3 || point.y != n4)) {
            if (this.isParentMirrored()) {
                try {
                    this.display.blockedQtEventType = 2003;
                    OS.QWidget_move(n6, point2.x - (n3 - point.x), point2.y);
                    Object var12_11 = null;
                    this.display.blockedQtEventType = 0;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    this.display.blockedQtEventType = 0;
                    throw throwable;
                }
            }
            OS.QWidget_resize(n6, n3, n4);
            n5 |= 0x100;
        }
        if (bl) {
            if (this.isParentMirrored()) {
                n = this.parent.getClientWidth() - n - OS.QWidget_size((int)n6).x;
            }
            if (point2.x != n || point2.y != n2) {
                OS.QWidget_move(n6, n, n2);
                n5 |= 0x80;
            }
        }
        return n5;
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.QWidget_grabMouse(this.handle);
        } else {
            OS.QWidget_releaseMouse(this.handle);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.enableWidget(bl);
        if (bl2) {
            this.fixFocus(control);
        }
    }

    boolean setFixedFocus() {
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus(7);
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.setFocus(7);
    }

    protected boolean setFocus(int n) {
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus(n);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if ((this.state & 0x4000) == 0 && font == null) {
            return;
        }
        this.font = font;
        if (font == null) {
            OS.QWidget_setFont(this.internal_topHandle(), OS.SwtFontCache_cache(OS.QApplication_swt_font_new(this.internal_topHandle())));
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            OS.QWidget_setFont(this.internal_topHandle(), font.handle);
        }
        this.state = font == null ? (this.state &= 0xFFFFBFFF) : (this.state |= 0x4000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.foreground == null && color == null) {
            return;
        }
        int n = OS.QWidget_swt_palette_new(this.internal_topHandle());
        try {
            this.foreground = color == null ? null : Color.qt_new(this.display, color.handle);
            this.setPaletteFgColor(n, color);
            OS.QWidget_setPalette(this.internal_topHandle(), n);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            OS.QPalette_delete(n);
            throw throwable;
        }
        OS.QPalette_delete(n);
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, 0, 0, true, false);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setPaletteBgColor(int n, Color color) {
        int[] nArray = this.getBackgroundColorRoles();
        if (color != null) {
            for (int i = 0; i < nArray.length; ++i) {
                OS.QPalette_setColor(n, nArray[i], color.getRed(), color.getGreen(), color.getBlue());
            }
        } else {
            int n2 = OS.QApplication_swt_palette_new();
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    OS.QPalette_swt_copyBrushFromPalette(n, n2, nArray[i]);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OS.QPalette_delete(n2);
                throw throwable;
            }
            OS.QPalette_delete(n2);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setPaletteBgImage(int n, Image image) {
        int[] nArray = this.getBackgroundImageRoles();
        if (image != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (this.findBackgroundControl() != this && this.canInheritBackgroundImage()) {
                    OS.QPalette_swt_setBrush(n, nArray[i], 0);
                    this.backgroundImageInherited(image);
                    continue;
                }
                OS.QPalette_swt_setBrush(n, nArray[i], image.internal_getPixmapHandle());
                this.backgroundImageApplied(image);
            }
        } else {
            int n2 = OS.QApplication_swt_palette_new();
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    OS.QPalette_swt_copyBrushFromPalette(n, n2, nArray[i]);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OS.QPalette_delete(n2);
                throw throwable;
            }
            OS.QPalette_delete(n2);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setPaletteFgColor(int n, Color color) {
        int[] nArray = new int[]{0, 6, 8};
        if (color != null) {
            for (int i = 0; i < nArray.length; ++i) {
                OS.QPalette_setColor(n, nArray[i], color.getRed(), color.getGreen(), color.getBlue());
            }
        } else {
            int n2 = OS.QApplication_swt_palette_new();
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    OS.QPalette_swt_copyBrushFromPalette(n, n2, nArray[i]);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OS.QPalette_delete(n2);
                throw throwable;
            }
            OS.QPalette_delete(n2);
            {
            }
        }
    }

    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        return false;
    }

    boolean setRadioFocus(boolean bl) {
        return false;
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        OS.QWidget_setUpdatesEnabled(this.handle, bl);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), false, true);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus(1);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string == null) {
            string = "";
            this.toolTipTextExists = false;
        } else {
            this.toolTipTextExists = true;
        }
        OS.QWidget_setToolTip(this.handle, string);
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        if ((this.state & 0x1000000) != 0) {
            this.traverseDoit = false;
            this.traverseCancel = false;
            return;
        }
        int n5 = 248;
        boolean bl = this.traverseDoit = (n & n5) != 0;
        if (n == 4) {
            this.traverseDoit = this.menuShell().defaultButton != null;
        }
        this.traverseCancel = true;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.getVisible() == bl) {
            return;
        }
        OS.QWidget_setVisible(this.internal_topHandle(), bl);
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        if (!bl) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        Point point = OS.QWidget_mapFromGlobal(this.handle, n, n2);
        if (this.isMirrored()) {
            point.x = this.getClientWidth() - point.x;
        }
        return point;
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        if (this.isMirrored()) {
            n = this.getClientWidth() - n;
        }
        return OS.QWidget_mapToGlobal(this.handle, n, n2);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        this.display.mnemonicControl = this;
        return this.doTraversal(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        int n;
        int n2;
        Control control = this.computeTabRoot();
        Control control2 = this.computeTabGroup();
        Control[] controlArray = control.computeTabList();
        int n3 = controlArray.length;
        for (n2 = 0; n2 < n3 && controlArray[n2] != control2; ++n2) {
        }
        if (n2 >= n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Control control3 = controlArray[n2];
            if (control3.isDisposed() || !control3.setTabGroupFocus()) continue;
            return true;
        }
        if (control2.isDisposed()) {
            return false;
        }
        return control2.setTabGroupFocus();
    }

    boolean traverseItem(boolean bl) {
        int n;
        int n2;
        Control[] controlArray = this.parent._getChildren();
        int n3 = controlArray.length;
        for (n2 = 0; n2 < n3 && controlArray[n2] != this; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char c) {
        if (this.display.mnemonicControl == null) {
            return false;
        }
        Control control = this.display.mnemonicControl.findNextControl(false);
        if (control != null) {
            control.setFocus(1);
            return true;
        }
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        return this.menuShell().invokeDefaultButton();
    }

    public void update() {
        this.checkWidget();
        this._update();
    }

    void _update() {
        OS.QCoreApplication_processEvents(Display.handle, 1);
        if (this.isDisposed()) {
            return;
        }
        OS.QCoreApplication_sendPostedEvents(Display.handle, this.handle, 12);
    }

    private void updateAutoFillBackground() {
        Control control = this.findBackgroundControl();
        boolean bl = false;
        if (control != null) {
            bl = control.background != null || control.backgroundImage != null;
        }
        OS.QWidget_setAutoFillBackground(this.internal_topHandle(), bl);
    }

    void updateBackground() {
        this.setBackground();
    }

    void updateBackgroundMode() {
        int n = this.state & 0x8000;
        this.checkBackground();
        if (n != (this.state & 0x8000)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean bl) {
    }

    void waitXRequestComplete() {
        OS.QApplication_syncX();
        this.display.noInterrupt = true;
        OS.QCoreApplication_processEvents(Display.handle, 1);
        this.display.noInterrupt = false;
    }
}

