/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.QObjectDeleteWrapper;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    Image image;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int restoreState;
    Point fixedSize;
    private int ownMenuBar;
    static int topTitleFrame = -1;
    static int leftTitleFrame = -1;
    static int rightTitleFrame = -1;
    static int bottomTitleFrame = -1;
    static int topThinFrame = -1;
    static int leftThinFrame = -1;
    static int rightThinFrame = -1;
    static int bottomThinFrame = -1;

    Decorations() {
    }

    public Decorations(Composite composite, int n) {
        super(composite, Decorations.checkStyle(n, composite));
    }

    static int checkStyle(int n, Composite composite) {
        if ((n & 8) != 0) {
            n &= 0xFFFFF30F;
        }
        if ((n & 0x4C0) != 0) {
            n |= 0x20;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkBorder() {
        if ((this.state & 2) != 0) {
            int n = this.internal_frameHandle();
            if (n != 0) {
                OS.QFrame_setFrameStyle(n, 0);
            }
        } else {
            super.checkBorder();
        }
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != null) continue;
            this.menus[i] = menu;
            return;
        }
        Menu[] menuArray = new Menu[this.menus.length + 4];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    protected void createWidget(int n) {
        super.createWidget(n);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        super.dispose();
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.hasState(2);
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public int internal_getOwnMenuBar() {
        if (this.menuBar != null && !this.menuBar.isDisposed()) {
            return this.menuBar.handle;
        }
        if (this.ownMenuBar == 0) {
            this.ownMenuBar = OS.QMenuBar_new(this.internal_topHandle());
            if (this.parent == null) {
                OS.QMainWindow_setMenuBar(this.internal_topHandle(), this.ownMenuBar);
            } else {
                int n = OS.QWidget_layout(this.internal_topHandle());
                OS.QLayout_setMenuBar(n, this.ownMenuBar);
            }
        }
        return this.ownMenuBar;
    }

    public int internal_ownMenuBar() {
        return this.ownMenuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.hasState(1);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return OS.QWidget_windowTitle(this.internal_topHandle());
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != menu) continue;
            this.menus[i] = null;
            return;
        }
    }

    protected void releaseChildren(boolean bl) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        if (this.ownMenuBar != 0) {
            QObjectDeleteWrapper.deleteSafely(this.ownMenuBar);
            this.ownMenuBar = 0;
        }
        super.releaseChildren(bl);
        if (this.menus != null) {
            for (int i = 0; i < this.menus.length; ++i) {
                Menu menu = this.menus[i];
                if (menu == null || menu.isDisposed()) continue;
                menu.dispose();
            }
            this.menus = null;
        }
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean bl = this.savedFocus != null && this.savedFocus.setFocus(7);
        return bl;
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean bl) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (bl) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (bl) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        int n = image != null ? image.internal_getIconHandle() : Image.internal_getNullIconHandle();
        OS.QWidget_setWindowIcon(this.internal_topHandle(), n);
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        if (OS.windowServer == 1 && this.parent == null && !bl && this.restoreState != 2 && this.restoreState != 1) {
            return;
        }
        this.setRestoreState(2, !bl);
    }

    protected void storeState(int n) {
        this.restoreState = (n & 1) != 0 ? 1 : ((n & 2) != 0 ? 2 : 0);
    }

    protected boolean hasState(int n) {
        int n2 = OS.QWidget_windowState(this.internal_topHandle());
        return (n2 & n) != 0;
    }

    final boolean sizeFixed() {
        return OS.QWidget_minimumSize(this.internal_topHandle()).equals(OS.QWidget_maximumSize(this.internal_topHandle()));
    }

    final void unlockSize() {
        OS.QWidget_setMaximumSize(this.internal_topHandle(), 0xFFFFFF, 0xFFFFFF);
        OS.QWidget_setMinimumSize(this.internal_topHandle(), 0, 0);
    }

    protected void setState(int n) {
        int n2 = OS.QWidget_windowState(this.internal_topHandle());
        if ((n2 & n) != 0) {
            return;
        }
        this.storeState(n2);
        int n3 = n2;
        int n4 = 7 & ~n;
        n3 &= ~n4;
        if (((n3 |= n) & 6) != 0 && (n2 & 6) == 0 && this.sizeFixed()) {
            this.fixedSize = OS.QWidget_minimumSize(this.internal_topHandle());
            this.style |= 0xB;
            this.unlockSize();
        }
        if ((n3 & 2) != 0 && (n2 & 4) != 0) {
            OS.QWidget_setWindowState(this.internal_topHandle(), 0);
        }
        OS.QWidget_setWindowState(this.internal_topHandle(), n3);
        if ((n3 & 6) == 0 && this.fixedSize != null) {
            OS.QWidget_setFixedSize(this.internal_topHandle(), this.fixedSize.x, this.fixedSize.y);
            this.style &= 0xFFFFFFF4;
            this.fixedSize = null;
        }
    }

    protected void restoreState() {
        if (this.restoreState == 1) {
            this.setState(1);
        } else if (this.restoreState == 2) {
            this.setState(2);
            this.bringToTop(false);
        } else {
            this.setState(0);
            this.bringToTop(false);
        }
        this.restoreState = 0;
    }

    void bringToTop(boolean bl) {
        if (this.isDisposed()) {
            return;
        }
        OS.QWidget_activateWindow(this.internal_topHandle());
        OS.QWidget_raise(this.internal_topHandle());
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
            if (this.menuBar != null) {
                this.menuBar.dispose();
            }
            if (this.parent == null) {
                OS.QMainWindow_setMenuBar(this.internal_topHandle(), menu.handle);
            } else {
                int n = OS.QWidget_layout(this.internal_topHandle());
                OS.QLayout_setMenuBar(n, menu.handle);
            }
            this.menuBar = menu;
            this.ownMenuBar = 0;
            this.display.commandArranger.menuBarChanged(this);
        }
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        this.setRestoreState(1, !bl);
    }

    protected void setRestoreState(int n, boolean bl) {
        int n2 = OS.QWidget_windowState(this.internal_topHandle());
        if (!bl) {
            this.setState(n);
        } else {
            if ((n2 & n) == 0) {
                return;
            }
            this.restoreState();
        }
    }

    void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        OS.QWidget_setWindowTitle(this.internal_topHandle(), string);
        OS.QWidget_setWindowIconText(this.internal_topHandle(), string);
    }

    boolean traverseItem(boolean bl) {
        return false;
    }

    boolean invokeDefaultButton() {
        int n;
        if (this.defaultButton != null && !this.defaultButton.isDisposed() && OS.QPushButton_isDefault(n = this.defaultButton.handle) && this.defaultButton.isVisible() && this.defaultButton.isEnabled()) {
            OS.QAbstractButton_click(n);
            return true;
        }
        return false;
    }

    void saveFocus() {
        Control control = this.display._getFocusControl();
        if (control != null && control != this && this == control.menuShell()) {
            this.setSavedFocus(control);
        }
    }

    boolean willBeDecorated() {
        if (OS.windowServer == 1) {
            return false;
        }
        int n = OS.QWidget_windowFlags(this.internal_topHandle());
        return (n & 0x800) == 0;
    }

    boolean thickFrame() {
        return this.willBeDecorated() && !this.thinFrame();
    }

    boolean thinFrame() {
        if (OS.windowServer == 1) {
            return false;
        }
        if ((this.style & 0x10) != 0) {
            return false;
        }
        int n = OS.QWidget_windowFlags(this.internal_topHandle());
        return (n & 0xF000) == 0;
    }

    int windowFrameTrim() {
        if (!this.willBeDecorated()) {
            return 0;
        }
        if (this.thinFrame()) {
            return leftThinFrame != -1 ? leftThinFrame : 4;
        }
        return leftTitleFrame != -1 ? leftTitleFrame : 5;
    }

    int windowTitleTrim() {
        if (!this.willBeDecorated()) {
            return 0;
        }
        if (this.thinFrame()) {
            return topThinFrame > -1 ? topThinFrame : 4;
        }
        return topTitleFrame > -1 ? topTitleFrame : 24;
    }

    boolean verifyTrim(int n, int n2, int n3, int n4) {
        if (this.willBeDecorated() && n == 0 | n2 == 0 | n3 == 0 | n4 == 0) {
            return false;
        }
        if (!this.willBeDecorated() && n != 0 | n2 != 0 | n3 != 0 | n4 != 0) {
            return false;
        }
        if (n2 < 0 || n < 0 || n4 < 0 || n3 < 0) {
            return false;
        }
        if (n2 != n3) {
            return false;
        }
        return !this.thickFrame() || n != n4;
    }

    void learnTrim() {
        if (!this.willBeDecorated()) {
            return;
        }
        int n = OS.QWidget_windowState(this.internal_topHandle());
        if ((n & 1) != 0) {
            return;
        }
        if ((n & 4) != 0) {
            return;
        }
        Rectangle rectangle = OS.QWidget_frameGeometry(this.internal_topHandle());
        Rectangle rectangle2 = OS.QWidget_geometry(this.internal_topHandle());
        int n2 = rectangle2.y - rectangle.y;
        int n3 = rectangle2.x - rectangle.x;
        int n4 = rectangle.width - rectangle2.width - n3;
        int n5 = rectangle.height - rectangle2.height - n2;
        if (!this.verifyTrim(n2, n3, n4, n5)) {
            return;
        }
        if (this.thickFrame()) {
            if (n2 > topTitleFrame) {
                topTitleFrame = n2;
            }
            if (n3 > leftTitleFrame) {
                leftTitleFrame = n3;
            }
            if (n4 > rightTitleFrame) {
                rightTitleFrame = n4;
            }
            if (n5 > bottomTitleFrame) {
                bottomTitleFrame = n5;
            }
        } else if (this.thinFrame()) {
            if (n2 > topThinFrame) {
                topThinFrame = n2;
            }
            if (n3 > leftThinFrame) {
                leftThinFrame = n3;
            }
            if (n4 > rightThinFrame) {
                rightThinFrame = n4;
            }
            if (n5 > bottomThinFrame) {
                bottomThinFrame = n5;
            }
        }
    }

    protected boolean qt_event_focusOut(int n) {
        boolean bl = super.qt_event_focusOut(n);
        this.saveFocus();
        return bl;
    }

    void qt_swt_event_focusWasGained() {
        super.qt_swt_event_focusWasGained();
        if (this.savedFocus != this) {
            this.restoreFocus();
        }
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    boolean qt_event_close() {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return true;
    }

    boolean qt_event_windowActivate(int n) {
        if (n == this.internal_topHandle()) {
            this.sendEvent(26);
        }
        return false;
    }

    boolean qt_event_windowDeactivate(int n) {
        if (n == this.internal_topHandle()) {
            this.sendEvent(27);
            this.saveFocus();
        }
        return false;
    }

    boolean qt_event_windowStateChange(int n, int n2) {
        int n3 = OS.QWidget_windowState(this.internal_topHandle());
        if ((n2 & 1) != 0 && (n3 & 1) == 0) {
            this.sendEvent(20);
            return false;
        }
        if ((n2 & 1) == 0 && (n3 & 1) != 0) {
            this.sendEvent(19);
            this.menuShell().saveFocus();
            return false;
        }
        return false;
    }
}

