/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames;
    String[] filterExtensions;
    String filterPath = "";
    String fileName;
    String[] fileNames = new String[0];
    int filterIndex = -1;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final String EXTENSION_SEPARATOR = ";;";
    String dialogID;
    static int dialogCount;

    public FileDialog(Shell shell) {
        this(shell, 0);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
        this.dialogID = this.toString() + String.valueOf(++dialogCount);
    }

    protected static int checkStyle(Shell shell, int n) {
        if (((n &= 0xF7FFFFFF) & 0x4000000) == 0 && shell != null && (shell.style & 0x4000000) != 0) {
            n |= 0x4000000;
        }
        if ((n & 0x1000) != 0 && (n & 0x2000) != 0) {
            n &= 0xFFFFEFFF;
        }
        if ((n & 0x2000) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if ((n & 0x2000000) != 0 && (n & 0x4000000) != 0) {
            n &= 0xFDFFFFFF;
        }
        return n;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        int n;
        int n2;
        int n3;
        this.checkDialog();
        String string = "";
        int n4 = this.filterExtensions != null ? this.filterExtensions.length : -1;
        int n5 = n3 = this.filterNames != null ? this.filterNames.length : -1;
        if (n4 > 0) {
            string = string + (n3 > 0 ? this.filterNames[0] + " " : "") + "(" + this.filterExtensions[0] + ")";
            for (int i = 1; i < n4; ++i) {
                string = string + EXTENSION_SEPARATOR + (i < n3 ? this.filterNames[i] + " " : "") + "(" + this.filterExtensions[i] + ")";
            }
        }
        String string2 = this.filterIndex > -1 && this.filterIndex < n4 ? this.filterExtensions[this.filterIndex] : "";
        int n6 = this.filterPath != null ? this.filterPath.length() : 0;
        String string3 = n6 > 0 ? this.filterPath : "";
        int n7 = n2 = this.fileName != null ? this.fileName.length() : 0;
        if (n6 > 0 && n2 > 0 && this.filterPath.charAt(n6 - 1) != SEPARATOR) {
            string3 = string3 + SEPARATOR;
        }
        if (n2 > 0) {
            string3 = string3 + this.fileName;
        }
        DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (disposeEvent.widget == FileDialog.this.parent) {
                    OS.QDialog_swt_closeDialogs(FileDialog.this.parent.handle, FileDialog.this.dialogID);
                }
            }
        };
        this.parent.addDisposeListener(disposeListener);
        int n8 = n = (this.style & 0x4000000) != 0 ? 1 : 0;
        String[] stringArray = (this.style & 0x2000) != 0 ? OS.QFileDialog_swt_getSaveFileName(this.parent.handle, this.title, string3, string, string2, this.dialogID, n) : ((this.style & 2) != 0 ? OS.QFileDialog_swt_getOpenFileNames(this.parent.handle, this.title, string3, string, string2, this.dialogID, n) : OS.QFileDialog_swt_getOpenFileName(this.parent.handle, this.title, string3, string, string2, this.dialogID, n));
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.removeDisposeListener(disposeListener);
        }
        this.parseResult(stringArray);
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }

    private void parseResult(String[] stringArray) {
        int n;
        this.filterPath = null;
        this.fileNames = null;
        this.fileName = null;
        this.filterIndex = -1;
        if (stringArray == null) {
            return;
        }
        int n2 = stringArray.length;
        if (n2 < 1) {
            return;
        }
        this.fileNames = new String[n2 - 1];
        String string = stringArray[0];
        int n3 = -1;
        if (string != null && string.length() > 0) {
            n3 = string.lastIndexOf(SEPARATOR);
            this.fileNames[0] = this.fileName = string.substring(n3 + 1);
            this.filterPath = string.substring(0, n3);
        }
        for (n = 1; n < n2 - 1; ++n) {
            string = stringArray[n];
            if (string != null && string.length() > 0) {
                n3 = string.lastIndexOf(SEPARATOR);
                this.fileNames[n] = string.substring(n3 + 1);
                continue;
            }
            this.fileNames[n] = null;
        }
        n = this.filterExtensions.length;
        String string2 = stringArray[n2 - 1];
        this.filterIndex = -1;
        if (n > 0 && string2 != null) {
            string2 = string2.substring(string2.indexOf(40) + 1);
            string2 = string2.substring(0, string2.indexOf(41));
            for (int i = 0; i < n; ++i) {
                if (!this.filterExtensions[i].equals(string2)) continue;
                this.filterIndex = i;
                break;
            }
        }
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    void checkDialog() {
        Display display;
        if (this.parent == null) {
            this.error(24);
        }
        if (this.parent.isDisposed()) {
            this.error(24);
        }
        if ((display = this.parent.display) == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
    }
}

