/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    protected String text;
    boolean keyFocusIn;
    static final String LINK_START = "<a>";
    static final String LINK_END = "</a>";

    public Link(Composite composite, int n) {
        this(composite, n, 0);
    }

    protected Link(Composite composite, int n, int n2) {
        super(composite, Link.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0), n2);
        this.setAlignment(n);
        OS.QLabel_setTextInteractionFlags(this.handle, 13);
        OS.QLabel_setOpenExternalLinks(this.handle, false);
        this.text = "";
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void createHandle(int n) {
        this.handle = OS.QLabel_new();
        this.state |= 8;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = OS.SignalHandler_new(this.handle, this.display, 1021);
        OS.QObject_connectOrThrow(this.handle, "linkActivated(const QString&)", n, "widgetSignal(const QString&)", 0);
    }

    protected int internal_frameHandle() {
        return this.handle;
    }

    protected boolean qt_event_focusIn(int n) {
        if (n != 0) {
            this.keyFocusIn = true;
        }
        return super.qt_event_focusIn(n);
    }

    protected boolean qt_event_focusOut(int n) {
        this.keyFocusIn = false;
        return super.qt_event_focusIn(n);
    }

    protected void qt_signal_linkActivated(String string) {
        Event event = new Event();
        event.text = string;
        this.sendEvent(13, event);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    protected void setAlignment(int n) {
        int n2 = 128;
        if ((n & 0x4000) != 0) {
            n2 |= 1;
        } else if ((n & 0x1000000) != 0) {
            n2 |= 4;
        } else if ((n & 0x20000) != 0) {
            n2 |= 2;
        }
        OS.QLabel_setAlignment(this.handle, n2);
    }

    public void setEnabled(boolean bl) {
        if (bl != this.getEnabled()) {
            OS.QLabel_setTextInteractionFlags(this.handle, bl ? 13 : 0);
        }
        super.setEnabled(bl);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.text = string;
        OS.QLabel_setText(this.handle, Link.adjustTags(this.text));
    }

    static String adjustTags(String string) {
        int n = string.indexOf(LINK_START);
        if (n == -1) {
            return string;
        }
        int n2 = 0;
        int n3 = n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n)).append("<a href=\"");
            n2 = n + LINK_START.length();
            n3 = string.indexOf(LINK_END, n2);
            if (n3 == -1) {
                return string;
            }
            string2 = string.substring(n2, n3);
            stringBuffer.append(string2);
            stringBuffer.append("\">" + string2 + LINK_END);
            n2 = n3 + LINK_END.length();
            n = string.indexOf(LINK_START, n2);
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        if (n == 4) {
            this.traverseDoit = false;
            this.traverseCancel = false;
            return;
        }
        super.setTraversalFlags(n, n2, n3, n4);
        switch (n2) {
            case 0x1000004: 
            case 0x1000005: {
                this.traverseDoit = false;
                this.traverseCancel = false;
                break;
            }
            case 0x1000001: {
                if (!this.isFocusControl() || !this.keyFocusIn) break;
                this.traverseDoit = false;
                this.traverseCancel = false;
                this.keyFocusIn = false;
                break;
            }
        }
    }
}

