/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int accelerator;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.createWidget(menu.getItemCount());
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        int n3 = menu.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void createHandle(int n) {
        int n2;
        this.handle = OS.QAction_new(this.parent.handle);
        this.state |= 8;
        if ((this.parent.style & 2) != 0) {
            OS.QMenuBar_addAction(this.parent.handle, this.handle);
        } else {
            n2 = this.parent.getItemCount();
            if (n2 > 0 && n < n2) {
                int n3 = this.parent.getItems()[n].handle;
                OS.QWidget_insertAction(this.parent.handle, n3, this.handle);
            } else {
                OS.QMenu_addAction(this.parent.handle, this.handle);
            }
        }
        n2 = 58;
        switch (this.style & n2) {
            case 2: {
                OS.QAction_setSeparator(this.handle, true);
                break;
            }
            case 16: {
                if (this.parent.actionGroupHandle == 0) {
                    this.parent.actionGroupHandle = OS.QActionGroup_new(this.parent.handle);
                    if ((this.parent.style & 0x400000) != 0) {
                        OS.QActionGroup_setExclusive(this.parent.actionGroupHandle, false);
                    }
                }
                OS.QAction_setCheckable(this.handle, true);
                OS.QActionGroup_addAction(this.parent.actionGroupHandle, this.handle);
                break;
            }
            case 32: {
                OS.QAction_setCheckable(this.handle, true);
                break;
            }
        }
    }

    void fixMenus(Decorations decorations) {
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.QAction_isEnabled(this.handle);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.QAction_isChecked(this.handle);
    }

    protected void qt_signal_triggered(boolean bl) {
        Event event = new Event();
        this.sendEvent(13, event);
    }

    void qt_signal_hover() {
        this.sendEvent(30);
    }

    protected void hookEvents() {
        int n;
        super.hookEvents();
        if ((this.style & 0x40) == 0) {
            n = OS.SignalHandler_new(this.handle, this.display, 1006);
            OS.QObject_connectOrThrow(this.handle, "triggered(bool)", n, "widgetSignal(bool)", 0);
        }
        n = OS.SignalHandler_new(this.handle, this.display, 1007);
        OS.QObject_connectOrThrow(this.handle, "hovered()", n, "widgetSignal()", 0);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    protected void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    protected void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    protected void releaseWidget() {
        if ((this.style & 0x10) != 0 && this.parent.actionGroupHandle != 0) {
            OS.QActionGroup_removeAction(this.parent.actionGroupHandle, this.handle);
        }
        OS.QWidget_removeAction(this.parent.handle, this.handle);
        super.releaseWidget();
        this.accelerator = 0;
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAccelerator(int n) {
        int n2;
        int n3;
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        int n4 = 0;
        if ((n & 0x10000) != 0) {
            n4 |= 0x8000000;
        }
        if ((n & 0x20000) != 0) {
            n4 |= 0x2000000;
        }
        if ((n & 0x40000) != 0) {
            n4 |= 0x4000000;
        }
        if ((n3 = Display.untranslateKey(n2 = n & 0x100FFFF)) != 0) {
            n2 = n3;
        }
        int n5 = OS.QKeySequence_new(n4 + n2);
        OS.QAction_setShortcut(this.handle, n5);
        this.accelerator = n;
        OS.QKeySequence_delete(n5);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        OS.QAction_setEnabled(this.handle, bl);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (image != null) {
            OS.QAction_setIcon(this.handle, image.internal_getIconHandle());
        } else {
            OS.QAction_setIcon(this.handle, Image.internal_getNullIconHandle());
        }
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        int n = 0;
        if (menu != null) {
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
            n = menu.handle;
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        OS.QAction_setMenu(this.handle, n);
        this.menu = menu;
        if (this.menu != null) {
            this.menu.cascade = this;
        }
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.QAction_setChecked(this.handle, bl);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        OS.QAction_setText(this.handle, string);
        this.text = string;
    }
}

