/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    private String message = "";
    private String dialogID;
    static int dialogCount;

    public MessageBox(Shell shell) {
        this(shell, 65570);
    }

    public MessageBox(Shell shell, int n) {
        super(shell, shell == null ? MessageBox.checkStyle(n) : MessageBox.checkStyle(shell, n));
        this.checkSubclass();
        this.checkDialog();
        this.dialogID = this.toString() + String.valueOf(++dialogCount);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public int open() {
        this.checkDialog();
        DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (disposeEvent.widget == MessageBox.this.parent) {
                    OS.QDialog_swt_closeDialogs(MessageBox.this.parent.handle, MessageBox.this.dialogID);
                }
            }
        };
        this.parent.addDisposeListener(disposeListener);
        int n = 0;
        if ((this.style & 2) != 0) {
            n = 1;
        }
        if ((this.style & 8) != 0) {
            n = 2;
        }
        if ((this.style & 4) != 0) {
            n = 4;
        }
        if ((this.style & 1) != 0) {
            n = 3;
        }
        int n2 = 0;
        if ((this.style & 0x20) != 0) {
            n2 |= 0x400;
        }
        if ((this.style & 0x100) != 0) {
            n2 |= 0x400000;
        }
        if ((this.style & 0x40) != 0) {
            n2 |= 0x4000;
        }
        if ((this.style & 0x80) != 0) {
            n2 |= 0x10000;
        }
        if ((this.style & 0x200) != 0) {
            n2 |= 0x40000;
        }
        if ((this.style & 0x400) != 0) {
            n2 |= 0x80000;
        }
        if ((this.style & 0x800) != 0) {
            n2 |= 0x100000;
        }
        int n3 = 1;
        if ((this.style & 0x30000) != 0) {
            n3 = 2;
        }
        int n4 = (this.style & 0x4000000) != 0 ? 1 : 0;
        int n5 = OS.QMessageBox_swt_exec(n, this.title, this.message, n2, this.parent.handle, n3, this.dialogID, n4);
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.removeDisposeListener(disposeListener);
        }
        return this.translateToSwtButton(n5);
    }

    private int translateToSwtButton(int n) {
        int n2 = 0;
        switch (n) {
            case 1024: {
                n2 = 32;
                break;
            }
            case 0x400000: {
                n2 = 256;
                break;
            }
            case 16384: {
                n2 = 64;
                break;
            }
            case 65536: {
                n2 = 128;
                break;
            }
            case 262144: {
                n2 = 512;
                break;
            }
            case 524288: {
                n2 = 1024;
                break;
            }
            case 0x100000: {
                n2 = 2048;
                break;
            }
        }
        return n2;
    }

    protected void checkDialog() {
        Display display;
        if (this.parent == null) {
            this.error(24);
        }
        if (this.parent.isDisposed()) {
            this.error(24);
        }
        if ((display = this.parent.display) == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
    }

    private static int checkStyle(int n) {
        int n2 = 4064;
        int n3 = n & n2;
        if (n3 == 32 || n3 == 256 || n3 == 288) {
            return n;
        }
        if (n3 == 64 || n3 == 128 || n3 == 192 || n3 == 448) {
            return n;
        }
        if (n3 == 1280 || n3 == 3584) {
            return n;
        }
        n = n & ~n2 | 0x20;
        return n;
    }

    protected static int checkStyle(Shell shell, int n) {
        return MessageBox.checkStyle(Dialog.checkStyle(shell, n));
    }
}

