/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    int value = -1;
    int thumb = 1;
    int selectionCause = 0;
    boolean dragOccurred = false;

    public Slider(Composite composite, int n) {
        super(composite, Slider.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Slider.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    protected void createHandle(int n) {
        this.state |= 8;
        this.handle = OS.QSlider_new();
        if ((this.style & 0x200) != 0) {
            OS.QSlider_setOrientation(this.handle, 2);
        } else {
            OS.QSlider_setOrientation(this.handle, 1);
        }
    }

    protected void hookEvents() {
        int n = OS.SignalHandler_new(this.handle, this.display, 1010);
        OS.QObject_connectOrThrow(this.handle, "valueChanged(int)", n, "widgetSignal(int)", 0);
    }

    public int getIncrement() {
        this.checkWidget();
        return OS.QSlider_singleStep(this.handle);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.QSlider_maximum(this.handle);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.QSlider_minimum(this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return OS.QSlider_pageStep(this.handle);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.QSlider_value(this.handle);
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.QSlider_setSingleStep(this.handle, n);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = OS.QSlider_minimum(this.handle);
        if (n >= 0 && n > n2) {
            this.thumb = Math.min(this.thumb, n - n2);
            this.setValue(Math.min(OS.QSlider_value(this.handle), n - this.thumb));
            OS.QSlider_setMaximum(this.handle, n);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.QSlider_maximum(this.handle);
        if (n >= n2) {
            return;
        }
        this.thumb = Math.min(this.thumb, n2 - n);
        this.setValue(Math.max(OS.QSlider_value(this.handle), n));
        OS.QSlider_setMinimum(this.handle, n);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.QSlider_setPageStep(this.handle, n);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.setValue(Math.max(Math.min(n, OS.QSlider_maximum(this.handle) - this.thumb), OS.QSlider_minimum(this.handle)));
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.QSlider_value(this.handle);
        int n3 = OS.QSlider_maximum(this.handle);
        this.thumb = n = Math.min(n, n3 - OS.QSlider_minimum(this.handle));
        this.setValue(Math.min(n2, n3 - n));
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        this.thumb = n4 = Math.min(n4, n3 - n2);
        OS.QSlider_setMaximum(this.handle, n3);
        OS.QSlider_setMinimum(this.handle, n2);
        OS.QSlider_setSingleStep(this.handle, n5);
        OS.QSlider_setPageStep(this.handle, n6);
        this.setValue(Math.min(Math.max(n, n2), n3 - n4));
    }

    protected void setValue(int n) {
        this.value = n;
        OS.QSlider_setValue(this.handle, n);
    }

    protected boolean qt_event_mouseButtonRelease(int n, int n2, int n3, int n4, int n5, int n6) {
        this.selectionCause = 0;
        if (this.dragOccurred) {
            this.dragOccurred = false;
            this.sendSliderSelectionEvent(this.selectionCause);
        }
        return super.qt_event_mouseButtonRelease(n, n2, n3, n4, n5, n6);
    }

    boolean qt_event_mouseMove(int n, int n2, int n3, int n4, int n5, int n6) {
        this.selectionCause = 1;
        return super.qt_event_mouseMove(n, n2, n3, n4, n5, n6);
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 0x1000010: 
            case 0x1000011: 
            case 0x1000012: 
            case 0x1000013: 
            case 0x1000014: 
            case 0x1000015: 
            case 0x1000016: 
            case 0x1000017: {
                this.selectionCause = Display.translateKey(n2, false);
                break;
            }
            default: {
                this.selectionCause = 0;
            }
        }
        return super.qt_event_keypress(n, n2, n3, n4);
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = true;
        this.traverseCancel = true;
        switch (n2) {
            case 0x1000012: 
            case 0x1000014: {
                if ((this.style & 0x100) != 0) {
                    this.traverseDoit = false;
                }
                this.traverseCancel = false;
                break;
            }
            case 0x1000013: 
            case 0x1000015: {
                if ((this.style & 0x200) != 0) {
                    this.traverseDoit = false;
                }
                this.traverseCancel = false;
                break;
            }
            case 0x1000010: 
            case 0x1000011: 
            case 0x1000016: 
            case 0x1000017: {
                this.traverseDoit = false;
                this.traverseCancel = false;
                break;
            }
        }
    }

    void qt_signal_slider_changed(int n) {
        if (this.value != n) {
            this.value = n;
            if (this.selectionCause == 1) {
                this.dragOccurred = true;
            }
            this.sendSliderSelectionEvent(this.selectionCause);
        }
    }

    void sendSliderSelectionEvent(int n) {
        Event event = new Event();
        event.widget = this;
        event.detail = n;
        this.sendEvent(13, event, true);
    }
}

