/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    int itemCount;
    int columnCount;
    TableItem currentItem;
    int minimumHeight;
    int heightRow;
    int lastIndexOf;
    int itemStateChangeKey;
    protected boolean apiSelection;
    boolean apiCheck;
    boolean currentItemChecked;
    Point imageSize = null;
    boolean wrap;
    boolean mouseSelection;
    int oldIndex = -1;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, n, false);
        return this.items[n];
    }

    static int checkStyle(int n) {
        if ((((n |= 0x10300) & 0x20) != 0 || (n & 2) != 0) && (n & 0x10) != 0) {
            n &= 0xFFFFFFEF;
        }
        return Table.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    boolean checkData(TableItem tableItem, int n) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            Event event = new Event();
            event.item = tableItem;
            event.index = n;
            tableItem.ensureValid(n);
            this.sendEvent(36, event);
            if (this.isDisposed()) {
                return false;
            }
            if (tableItem.isDisposed()) {
                return false;
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        return tableItem != null && !tableItem.isDisposed();
    }

    boolean checkData(TableItem tableItem) {
        return this.checkData(tableItem, this.indexOf(tableItem));
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int getBackgroundColorRole() {
        return 9;
    }

    int getForegroundColorRole() {
        return 6;
    }

    int getItemIndex(TableItem tableItem) {
        if (this.itemCount == 0 || this.items == null || tableItem == null || tableItem.parent != this) {
            return -1;
        }
        int n = OS.QTableWidget_row(this.internal_topHandle(), tableItem.internal_topHandle());
        if (n != -1) {
            return n;
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            for (int i = 0; i < this.itemCount; ++i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        } else {
            for (int i = this.itemCount - 1; i >= 0; --i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        }
        return -1;
    }

    int getNativeColumnIndex(int n) {
        return n + 1;
    }

    int getNativeColumnIndex(TableColumn tableColumn) {
        int n = this.getColumnIndex(tableColumn);
        if (n != -1) {
            return this.getNativeColumnIndex(n);
        }
        return -1;
    }

    int getColumnIndex(TableColumn tableColumn) {
        if (this.columnCount == 0 || this.columns == null) {
            return -1;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != tableColumn) continue;
            return i;
        }
        return -1;
    }

    int getCurrentColumnIndex() {
        return this.getCurrentColumnIndex(false);
    }

    int getCurrentColumnIndex(boolean bl) {
        int n = OS.QTableWidget_currentColumn(this.internal_topHandle());
        if (bl) {
            return n;
        }
        if (n != -1) {
            return n - 1;
        }
        return n;
    }

    void createColumn(TableColumn tableColumn, int n) {
        int n2;
        if (this.columnCount == this.columns.length) {
            n2 = Math.max(4, this.columns.length * 3 / 2);
            TableColumn[] tableColumnArray = new TableColumn[n2];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        if (this.columnCount > 1) {
            OS.QTableWidget_insertColumn(this.internal_topHandle(), this.getNativeColumnIndex(n));
            for (n2 = 0; n2 < this.itemCount; ++n2) {
                this.items[n2].addColumn(n2, n);
            }
        }
    }

    void createItem(TableItem tableItem, int n) {
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n2 = Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
    }

    void removeItem(int n) {
        TableItem tableItem;
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this._getItem(n)) != null && !tableItem.isDisposed()) {
            if ((this.style & 4) != 0 && (this.style & 0x10) != 0 && this.itemCount > 1 && OS.QAbstractButton_isChecked(this.items[n].radioButtonHandle)) {
                if (n > 0) {
                    OS.QAbstractButton_setChecked(this.items[n - 1].radioButtonHandle, true);
                } else if (n == 0) {
                    OS.QAbstractButton_setChecked(this.items[n + 1].radioButtonHandle, true);
                }
            }
            tableItem.release(false);
        }
        if (n == this.heightRow) {
            this.heightRow = -1;
        }
        OS.QTableWidget_removeRow(this.internal_topHandle(), n);
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
    }

    void updateImageSize(int n, int n2) {
        if (this.imageSize == null) {
            this.imageSize = new Point(n, n2);
            OS.QAbstractItemView_setIconSize(this.internal_topHandle(), n, n2);
        }
        if (this.imageSize.y > this.getItemHeight()) {
            this.updateRowHeight(false);
        }
    }

    void updateRowHeight(TableItem tableItem) {
        int n = this.internal_topHandle();
        int n2 = this.indexOf(tableItem);
        if (this.wrap) {
            int n3 = OS.QTableView_rowHeight(n, n2);
            int n4 = OS.QAbstractItemView_sizeHintForRow(n, n2);
            if (this.imageSize != null && this.imageSize.y > n4) {
                n4 = this.imageSize.y;
            }
            if ((n4 = Math.max(this.minimumHeight, n4)) != n3) {
                OS.QTableView_setRowHeight(n, n2, n4);
            }
        } else {
            int n5;
            int n6 = OS.QAbstractItemView_sizeHintForRow(n, n2);
            if (n6 > (n5 = this._getItemHeight())) {
                n6 = Math.max(this.minimumHeight, n6);
                this.heightRow = n2;
                for (int i = 0; i < this.itemCount; ++i) {
                    OS.QTableView_setRowHeight(n, i, n6);
                }
            } else if (n2 == this.heightRow && n6 < n5) {
                this.updateRowHeight(false);
            }
        }
    }

    void updateRowHeight(boolean bl) {
        block7: {
            int n;
            block6: {
                if (!this.wrap) break block6;
                int n2 = this.internal_topHandle();
                for (int i = 0; i < this.itemCount; ++i) {
                    int n3 = OS.QTableView_rowHeight(n2, i);
                    int n4 = OS.QAbstractItemView_sizeHintForRow(n2, i);
                    if (this.imageSize != null && this.imageSize.y > n4) {
                        n4 = this.imageSize.y;
                    }
                    if ((n4 = Math.max(this.minimumHeight, n4)) == n3) continue;
                    OS.QTableView_setRowHeight(n2, i, n4);
                }
                break block7;
            }
            int n5 = this.getItemHeight();
            if (bl) {
                n5 = this.minimumHeight;
            }
            int n6 = 0;
            int n7 = this.internal_topHandle();
            for (n = 0; n < this.itemCount; ++n) {
                int n8 = OS.QAbstractItemView_sizeHintForRow(n7, n);
                if (n8 <= n6) continue;
                this.heightRow = n;
                n6 = n8;
            }
            if (this.imageSize != null && this.imageSize.y > n6) {
                n6 = this.imageSize.y;
            }
            n6 = Math.max(this.minimumHeight, n6);
            if (!bl && n6 == n5) break block7;
            for (n = 0; n < this.itemCount; ++n) {
                OS.QTableView_setRowHeight(n7, n, n6);
            }
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void createHandle(int n) {
        this.scrollAreaHandle = OS.QTableWidget_new();
        this.handle = OS.QAbstractScrollArea_viewPort(this.internal_topHandle());
        this.state |= 8;
        this.state &= 0xFFFFFFFD;
        this.itemStateChangeKey = OS.windowServer == 2 ? 32 : (OS.windowServer == 1 ? -5 : 0);
        this.minimumHeight = this._getItemHeight();
        OS.QTableView_setWordWrap(this.internal_topHandle(), false);
        OS.QTableWidget_setColumnCount(this.internal_topHandle(), 2);
        OS.QHeaderView_setResizeMode(OS.QTableWidget_swt_header(this.internal_topHandle(), true), 0, 2);
        OS.QTableWidget_swt_setHeaderText(this.internal_topHandle(), 0, "");
        OS.QTableWidget_swt_setHeaderText(this.internal_topHandle(), 1, "");
        if ((this.style & 0x20) == 0 && (this.style & 0x10) == 0) {
            OS.QTableView_setColumnHidden(this.internal_topHandle(), 0, true);
        } else {
            int n2 = 0;
            OS.QTableWidget_insertRow(this.internal_topHandle(), 0);
            if ((this.style & 4) != 0 && (this.style & 0x10) != 0 || (this.style & 0x20) != 0) {
                int n3 = OS.QRadioButton_new();
                OS.QWidget_setFocusPolicy(n3, 0);
                OS.QTableWidget_setCellWidget(this.internal_topHandle(), 0, 0, n3);
                n2 = OS.QWidget_sizeHint((int)n3).x;
            }
            OS.QTableView_setColumnWidth(this.internal_topHandle(), 0, n2);
            OS.QTableWidget_removeRow(this.internal_topHandle(), 0);
        }
        if ((this.style & 2) != 0) {
            OS.QAbstractItemView_setSelectionMode(this.internal_topHandle(), 2);
        } else {
            OS.QAbstractItemView_setSelectionMode(this.internal_topHandle(), 1);
        }
        if ((this.style & 0x10000) != 0) {
            OS.QAbstractItemView_setSelectionBehavior(this.internal_topHandle(), 1);
        }
        OS.QTableWidget_swt_setHeaderVisible(this.internal_topHandle(), true, false);
        OS.QTableWidget_swt_setHeaderVisible(this.internal_topHandle(), false, false);
        OS.QTableView_setShowGrid(this.internal_topHandle(), false);
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                if (Table.this.columnCount == 0) {
                    int n = Table.this.internal_topHandle();
                    int n2 = Table.this.getClientArea().width;
                    if ((Table.this.style & 0x20) != 0 || (Table.this.style & 0x10) != 0) {
                        n2 -= OS.QTableView_columnWidth(n, 0);
                    }
                    OS.QTableView_setColumnWidth(n, 1, n2);
                    if (Table.this.wrap) {
                        Table.this.updateRowHeight(false);
                    }
                }
            }
        });
    }

    protected void createWidget(int n) {
        super.createWidget(n);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
    }

    void destroyItem(TableColumn tableColumn) {
        int n;
        for (n = 0; n < this.columnCount && this.columns[n] != tableColumn; ++n) {
        }
        if (n == this.columnCount) {
            return;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        if (this.columnCount > 0) {
            OS.QTableWidget_removeColumn(this.internal_topHandle(), this.getNativeColumnIndex(n));
            for (int i = 0; i < this.itemCount; ++i) {
                this.items[i].removeColumn(n);
            }
        }
    }

    void destroyItem(TableItem tableItem) {
        int n;
        for (n = 0; n < this.itemCount && this._getItem(n) != tableItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        this.removeItem(n);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        if ((this.style & 4) == 0 || (this.style & 0x10) == 0) {
            this._getItem(n).setSelected(false);
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        for (int i = n; i <= n2; ++i) {
            this.deselect(i);
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.deselect(nArray[i]);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.apiSelection = true;
        OS.QAbstractItemView_clearSelection(this.internal_topHandle());
        if ((this.style & 4) != 0) {
            OS.QTableWidget_setCurrentItem(this.internal_topHandle(), 0);
            if ((this.style & 0x10) != 0 && this.itemCount > 0) {
                OS.QAbstractButton_setChecked(this.items[0].radioButtonHandle, true);
            }
        }
        this.apiSelection = false;
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return OS.QTableView_showGrid(this.internal_topHandle()) ? 1 : 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return this._getHeaderHeight();
    }

    int _getHeaderHeight() {
        if (!OS.QTableWidget_swt_headerVisible(this.internal_topHandle(), true)) {
            return 0;
        }
        return OS.QTableWidget_swt_headerHeight(this.internal_topHandle(), true);
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.QTableWidget_swt_headerVisible(this.internal_topHandle(), true);
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        TableItem tableItem = this._getItem(n);
        tableItem.ensureValid(n);
        return tableItem;
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = -1;
        int n2 = OS.QTableWidget_itemAt(this.internal_topHandle(), point.x, point.y);
        if (n2 != 0) {
            n = OS.QTableWidget_row(this.internal_topHandle(), n2);
        }
        if (n >= 0 && n < this.itemCount) {
            TableItem tableItem = this._getItem(n);
            tableItem.ensureValid(n);
            return tableItem;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this._getItemHeight();
    }

    int _getItemHeight() {
        int n = 0;
        if (this.itemCount > 0) {
            n = OS.QTableView_rowHeight(this.internal_topHandle(), 0);
        } else {
            OS.QTableWidget_setRowCount(this.internal_topHandle(), 1);
            n = OS.QTableView_rowHeight(this.internal_topHandle(), 0);
            OS.QTableWidget_setRowCount(this.internal_topHandle(), 0);
        }
        return n;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            for (int i = 0; i < this.itemCount; ++i) {
                tableItemArray[i] = this._getItem(i);
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return OS.QTableView_showGrid(this.internal_topHandle());
    }

    public TableItem[] getSelection() {
        int[] nArray = this.getSelectionIndices();
        TableItem[] tableItemArray = new TableItem[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            tableItemArray[i] = this.items[nArray[i]];
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.QTableWidget_swt_selectionCount(this.internal_topHandle());
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            int[] nArray = this.getSelectionIndices();
            if (nArray.length > 0) {
                return nArray[0];
            }
            return -1;
        }
        if ((this.style & 4) != 0 && (this.style & 0x10) != 0) {
            return this._getSelectionIndex();
        }
        return OS.QTableWidget_currentRow(this.internal_topHandle());
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 0x10) != 0) {
            return new int[]{this._getSelectionIndex()};
        }
        return OS.QTableWidget_swt_selectedItems(this.internal_topHandle());
    }

    int _getSelectionIndex() {
        int n = 0;
        for (int i = 0; i < this.itemCount; ++i) {
            TableItem tableItem = this.getItem(i);
            if (!tableItem.getRadioSelected()) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.QTableWidget_topIndex(this.internal_topHandle());
    }

    protected boolean getWordWrap() {
        return this.wrap;
    }

    protected void hookEvents() {
        int n;
        super.hookEvents();
        if ((this.style & 4) == 0 || (this.style & 0x10) == 0) {
            n = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1015);
            OS.QObject_connectOrThrow(this.internal_topHandle(), "itemSelectionChanged()", n, "widgetSignal()", 0);
        }
        n = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1016);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "currentCellChanged(int,int,int,int)", n, "widgetSignal(int,int,int,int)", 0);
        int n2 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1017);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "cellChanged(int,int)", n2, "widgetSignal(int,int)", 0);
        int n3 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1018);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "cellActivated(int,int)", n3, "widgetSignal(int,int)", 0);
    }

    void sendSelectionEvent() {
        int n = OS.QTableWidget_currentRow(this.internal_topHandle());
        if (this.currentItem != null && n != -1) {
            Event event = new Event();
            event.widget = this;
            event.item = this._getItem(n);
            event.doit = true;
            this.sendEvent(13, event, true);
        }
    }

    void sendCheckEvent() {
        if (this.currentItem != null && (this.style & 0x20) != 0 && this.checkData(this.currentItem) && this.currentItemChecked != this.currentItem.getChecked()) {
            this.currentItemChecked = this.currentItem.getChecked();
            Event event = new Event();
            event.widget = this;
            event.item = this.currentItem;
            event.detail = 32;
            event.doit = true;
            this.sendEvent(13, event, true);
            if (!event.doit) {
                this.currentItem.setChecked(!this.currentItemChecked);
                this.currentItemChecked = !this.currentItemChecked;
            }
        }
    }

    void qt_signal_table_itemSelectionChanged() {
        if (!this.apiSelection) {
            this.sendSelectionEvent();
        }
    }

    void qt_signal_table_currentCellChanged(int n, int n2, int n3, int n4) {
        if (n != -1 && n2 == 0) {
            OS.QTableWidget_setCurrentCell(this.internal_topHandle(), n, 1);
        }
        if (n != -1 && this.items.length > 0) {
            this.currentItem = this._getItem(n);
            if ((this.style & 0x20) != 0 && this.checkData(this.currentItem, n)) {
                this.currentItemChecked = this.currentItem.getChecked();
            }
        }
    }

    void qt_signal_table_cellChanged(int n, int n2) {
        if (!this.apiCheck) {
            this.sendCheckEvent();
        }
    }

    boolean qt_event_paint(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == this.handle && (this.style & 0x10000000) != 0) {
            int n7 = OS.QTableView_rowAt(this.internal_topHandle(), n3);
            int n8 = OS.QTableView_rowAt(this.internal_topHandle(), n3 + n5);
            if (n7 != -1 || n8 != -1) {
                n7 = Math.max(0, n7);
                if (n8 == -1) {
                    n8 = this.itemCount - 1;
                }
                for (int i = n7; i <= n8; ++i) {
                    this.lastIndexOf = i;
                    this.checkData(this._getItem(i), i);
                }
            }
        }
        return super.qt_event_paint(n, n2, n3, n4, n5, n6);
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        boolean bl = super.qt_event_keypress(n, n2, n3, n4);
        if (this.items != null && this.itemCount > 0 && n4 == this.itemStateChangeKey && this.currentItem != null) {
            if ((this.style & 4) != 0 && (this.style & 0x10) != 0 && this.itemCount > 0) {
                OS.QAbstractButton_setChecked(this.currentItem.radioButtonHandle, true);
                this.sendSelectionEvent();
            } else {
                this.currentItem.setChecked(!this.currentItemChecked);
                this.sendCheckEvent();
            }
        }
        return bl;
    }

    protected boolean qt_event_mouseButtonPress(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == this.handle && (this.style & 4) != 0 && (this.style & 0x10) != 0) {
            int n7 = OS.QTableWidget_itemAt(this.internal_topHandle(), n3, n4);
            if (n7 != 0) {
                this.oldIndex = OS.QTableWidget_row(this.internal_topHandle(), n7);
            }
            this.mouseSelection = true;
        }
        return super.qt_event_mouseButtonPress(n, n2, n3, n4, n5, n6);
    }

    protected boolean qt_event_mouseButtonRelease(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == this.handle && this.mouseSelection && (this.style & 4) != 0 && (this.style & 0x10) != 0) {
            if (this.oldIndex != -1) {
                OS.QAbstractButton_setChecked(this.items[this.oldIndex].radioButtonHandle, true);
                this.sendSelectionEvent();
            } else if (this.currentItem != null) {
                Rectangle rectangle = OS.QTableWidget_visualItemRect(this.internal_topHandle(), this.currentItem.internal_topHandle());
                if (rectangle.y <= n4 && n4 <= rectangle.y + rectangle.height && n3 <= rectangle.x + rectangle.width) {
                    OS.QAbstractButton_setChecked(this.currentItem.radioButtonHandle, true);
                    this.sendSelectionEvent();
                }
            }
            this.mouseSelection = false;
            this.oldIndex = -1;
        }
        return super.qt_event_mouseButtonRelease(n, n2, n3, n4, n5, n6);
    }

    boolean qt_event_mouseMove(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mouseSelection && n == this.handle && (this.style & 4) != 0 && (this.style & 0x10) != 0) {
            int n7 = OS.QTableWidget_itemAt(this.internal_topHandle(), n3, n4);
            int n8 = -1;
            if (n7 != 0) {
                n8 = OS.QTableWidget_row(this.internal_topHandle(), n7);
            }
            Rectangle rectangle = OS.QTableWidget_visualItemRect(this.internal_topHandle(), this.currentItem.internal_topHandle());
            if (n8 != this.oldIndex) {
                if (rectangle.y > n4 || n4 > rectangle.y + rectangle.height || n3 > rectangle.x + rectangle.width) {
                    this.mouseSelection = false;
                    this.oldIndex = -1;
                }
            } else if (n8 == -1 && (rectangle.y > n4 || n4 > rectangle.y + rectangle.height || n3 >= rectangle.x + rectangle.width)) {
                this.mouseSelection = false;
            }
        }
        return super.qt_event_mouseMove(n, n2, n3, n4, n5, n6);
    }

    void qt_signal_released() {
        this.sendSelectionEvent();
    }

    void qt_signal_table_cellActivated(int n, int n2) {
        Event event = new Event();
        event.widget = this;
        event.item = this._getItem(n);
        event.doit = true;
        this.sendEvent(14, event, true);
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = false;
        this.traverseCancel = false;
        if (n == 4) {
            return;
        }
        switch (n2) {
            case 0x1000012: {
                if (this.getCurrentColumnIndex() != 0) break;
                this.traverseDoit = true;
                break;
            }
            case 0x1000014: {
                if (this.getCurrentColumnIndex() != this.columnCount - 1) break;
                this.traverseDoit = true;
                break;
            }
            case 0x1000013: {
                if (OS.QTableWidget_currentRow(this.internal_topHandle()) != 0) break;
                this.traverseDoit = true;
                break;
            }
            case 0x1000015: {
                if (OS.QTableWidget_currentRow(this.internal_topHandle()) != this.itemCount - 1) break;
                this.traverseDoit = true;
                break;
            }
            default: {
                super.setTraversalFlags(n, n2, n3, n4);
            }
        }
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        return this.getColumnIndex(tableColumn);
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        return this.getItemIndex(tableItem);
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return false;
        }
        return this._getItem(n).isSelected();
    }

    protected void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            for (n = 0; n < this.itemCount; ++n) {
                item = this.items[n];
                if (item == null || ((TableItem)item).isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.currentItem = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        this.removeItem(n);
    }

    public void remove(int n, int n2) {
        int n3;
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        for (int i = n2; i >= n; --i) {
            TableItem tableItem = this._getItem(i);
            if (tableItem == null || tableItem.isDisposed()) continue;
            tableItem.release(false);
        }
        if (this.heightRow >= n && this.heightRow <= n2) {
            this.heightRow = -1;
        }
        OS.QAbstractItemView_swt_removeRows(this.internal_topHandle(), n, n2 - n + 1);
        System.arraycopy(this.items, n2 + 1, this.items, n, this.itemCount - n2 - 1);
        for (n3 = this.itemCount - (n2 - n); n3 < this.itemCount; ++n3) {
            this.items[n3] = null;
        }
        this.itemCount = this.itemCount - (n2 - n) - 1;
        if ((this.style & 4) != 0 && (this.style & 0x10) != 0 && this.itemCount > 0) {
            n3 = 0;
            for (int i = 0; i < this.itemCount; ++i) {
                TableItem tableItem = this.getItem(i);
                if (!tableItem.getRadioSelected()) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) {
                if (n > 0) {
                    OS.QAbstractButton_setChecked(this.items[n - 1].radioButtonHandle, true);
                } else {
                    OS.QAbstractButton_setChecked(this.items[n + 1].radioButtonHandle, true);
                }
            }
        }
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (n2 < 0 || n >= this.itemCount || n < n2) {
            this.error(6);
        }
        int n3 = -1;
        for (int i = nArray2.length - 1; i >= 0; --i) {
            int n4 = nArray2[i];
            if (n4 == this.heightRow) {
                this.heightRow = -1;
            }
            if (n4 == n3) continue;
            this.remove(n4);
            n3 = n4;
        }
    }

    public void removeAll() {
        this.checkWidget();
        for (int i = 0; i < this.itemCount; ++i) {
            TableItem tableItem = this._getItem(i);
            if (tableItem == null || tableItem.isDisposed()) continue;
            tableItem.release(false);
        }
        OS.QTableWidget_clearContents(this.internal_topHandle());
        OS.QTableWidget_setRowCount(this.internal_topHandle(), 0);
        this.items = new TableItem[4];
        this.itemCount = 0;
        this.currentItem = null;
        this.heightRow = -1;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        this._select(n);
    }

    void _select(int n) {
        if (0 > n || n >= this.itemCount) {
            return;
        }
        TableItem tableItem = this._getItem(n);
        tableItem.setSelected(true);
        if ((this.style & 4) != 0) {
            this.apiSelection = true;
            int n2 = Math.max(1, OS.QTableWidget_currentColumn(this.internal_topHandle()));
            OS.QTableWidget_setCurrentCell(this.internal_topHandle(), n, n2);
            this.apiSelection = false;
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            this._select(i);
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this._select(nArray[i]);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.apiSelection = true;
        OS.QAbstractItemView_clearSelection(this.internal_topHandle());
        OS.QAbstractItemView_selectAll(this.internal_topHandle());
        this.apiSelection = false;
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        OS.QTableWidget_swt_setHeaderVisible(this.internal_topHandle(), true, bl);
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        this.remove(n, this.itemCount - 1);
        int n2 = Math.max(4, (n + 3) / 4 * 4);
        TableItem[] tableItemArray = new TableItem[n2];
        System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        this.items = tableItemArray;
        if (bl) {
            OS.QTableWidget_setRowCount(this.internal_topHandle(), n);
            this.itemCount = n;
        } else {
            for (int i = this.itemCount; i < n; ++i) {
                new TableItem(this, 0, i, true);
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        OS.QTableView_setShowGrid(this.internal_topHandle(), bl);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.select(n);
        OS.QTableView_showRow(this.internal_topHandle(), n);
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
            this.showSelection();
        } else {
            this._select(n);
            OS.QTableView_showRow(this.internal_topHandle(), n);
        }
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        if ((this.style & 2) != 0) {
            this.select(nArray);
            this.showSelection();
        } else {
            this._select(nArray[0]);
            OS.QTableView_showRow(this.internal_topHandle(), nArray[0]);
        }
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = tableItemArray.length;
        if (n != 0 && ((this.style & 4) == 0 || n <= 1)) {
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                int n2 = this.indexOf(tableItemArray[i]);
                if (n2 == -1) continue;
                if (bl) {
                    bl = false;
                    OS.QTableView_showRow(this.internal_topHandle(), n2);
                }
                this._select(n2);
            }
            this.showSelection();
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return;
        }
        int n2 = Math.max(0, this.getCurrentColumnIndex());
        int n3 = this._getItem(n).getHandle(n2);
        OS.QTableWidget_scrollToItem(this.internal_topHandle(), n3, 1);
    }

    protected void setWordWrap(boolean bl) {
        if (this.wrap != bl) {
            this.wrap = bl;
            OS.QTableView_setWordWrap(this.internal_topHandle(), this.wrap);
            this.updateRowHeight(true);
        }
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        if (this.itemCount == 0) {
            return;
        }
        int n = Math.max(0, OS.QTableWidget_currentRow(this.internal_topHandle()));
        int n2 = Math.max(0, this.getColumnIndex(tableColumn));
        TableItem tableItem = this._getItem(n);
        OS.QTableWidget_scrollToItem(this.internal_topHandle(), tableItem.getHandle(n2), 0);
    }

    public void showItem(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if (tableItem.parent != this) {
            return;
        }
        int n = tableItem.getHandle(this.getCurrentColumnIndex());
        OS.QTableWidget_scrollToItem(this.internal_topHandle(), n, 0);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = this.getSelection();
        if (tableItemArray.length == 0) {
            return;
        }
        this.showItem(tableItemArray[0]);
    }

    protected Point getPreferredClientAreaSize() {
        int n = this.internal_topHandle();
        Point point = OS.QWidget_sizeHint(n);
        if (this.itemCount > 0) {
            int n2 = 0;
            int n3 = 0;
            if ((this.style & 0x20) != 0 || (this.style & 0x10) != 0) {
                n2 += OS.QTableView_columnWidth(n, 0);
            }
            if (this.columnCount > 0) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.columns[i].useFixedWidth) {
                        n2 += OS.QTableView_columnWidth(n, this.getNativeColumnIndex(i));
                        continue;
                    }
                    n2 += this.columns[i].getPreferredColumnWidth(this.getNativeColumnIndex(i));
                }
            } else {
                n2 += OS.QAbstractItemView_sizeHintForColumn(n, 1);
            }
            n3 += this._getHeaderHeight();
            point.x = n2;
            point.y = n3 += this.itemCount * this._getItemHeight();
        }
        return point;
    }
}

