/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    int headerHandle;
    boolean useFixedWidth;

    public TableColumn(Table table, int n) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        this.createWidget(table.getColumnCount());
    }

    public TableColumn(Table table, int n, int n2) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        this.createWidget(n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TableColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int n) {
        if (n < 0 || n > this.parent.columnCount) {
            this.error(5);
        }
        this.useFixedWidth = false;
        this.headerHandle = 0;
        this.text = "";
        this.parent.createColumn(this, n);
        this.hookEvents();
        this.register();
        this.headerHandle = OS.QTableWidget_swt_header(this.parent.internal_topHandle(), true);
        this.setText(this.text);
        OS.QHeaderView_setResizeMode(this.headerHandle, this.parent.getNativeColumnIndex(n), 0);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    int getQtAlignment() {
        int n = 0;
        n = (this.style & 0x20000) != 0 ? 2 : ((this.style & 0x1000000) != 0 ? 4 : 1);
        return n |= 0x80;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    protected int getPreferredColumnWidth(int n) {
        if (n != -1) {
            int n2 = OS.QAbstractItemView_sizeHintForColumn(this.parent.internal_topHandle(), n);
            if (this.parent.getHeaderVisible()) {
                n2 = Math.max(n2, OS.QHeaderView_sectionSizeHint(this.headerHandle, n));
            }
            return n2;
        }
        return 0;
    }

    public boolean getResizable() {
        this.checkWidget();
        int n = this.parent.getNativeColumnIndex(this);
        if (n != -1) {
            int n2 = OS.QHeaderView_resizeMode(this.headerHandle, n);
            return n2 == 0;
        }
        return false;
    }

    public int getWidth() {
        this.checkWidget();
        int n = this.parent.getNativeColumnIndex(this);
        if (n != -1) {
            return OS.QTableView_columnWidth(this.parent.internal_topHandle(), n);
        }
        return 0;
    }

    public void pack() {
        this.checkWidget();
        int n = this.parent.getNativeColumnIndex(this);
        OS.QTableView_setColumnWidth(this.parent.internal_topHandle(), n, this.getPreferredColumnWidth(n));
        if (this.parent.getWordWrap()) {
            this.parent.updateRowHeight(false);
        }
    }

    protected void releaseHandle() {
        super.releaseHandle();
        this.deregister();
        this.parent = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.getColumnIndex(this);
        if (n2 <= 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n3 = this.getQtAlignment();
        for (int i = 0; i < this.parent.itemCount; ++i) {
            int n4 = this.parent._getItem(i).getHandle(n2);
            OS.QTableWidgetItem_setTextAlignment(n4, n3);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        int n = this.parent.getNativeColumnIndex(this);
        if (n != -1) {
            int n2 = image != null ? image.internal_getIconHandle() : Image.internal_getNullIconHandle();
            int n3 = OS.QTableWidget_swt_headerItem(this.parent.internal_topHandle(), n);
            OS.QTableWidgetItem_setIcon(n3, n2);
        }
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        int n = bl ? 0 : 2;
        int n2 = this.parent.getNativeColumnIndex(this);
        if (n2 != -1) {
            OS.QHeaderView_setResizeMode(this.headerHandle, n2, n);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        int n = this.parent.getNativeColumnIndex(this);
        if (n != -1) {
            int n2 = OS.QTableWidget_swt_headerItem(this.parent.internal_topHandle(), n);
            OS.QTableWidgetItem_setText(n2, string);
        }
    }

    public void setWidth(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = this.parent.getNativeColumnIndex(this);
        if (n2 != -1) {
            this.useFixedWidth = true;
            OS.QTableView_setColumnWidth(this.parent.internal_topHandle(), n2, n);
            if (this.parent.getWordWrap()) {
                this.parent.updateRowHeight(false);
            }
        }
        this.sendEvent(11);
    }
}

