/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.TextUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    private int textLimit;
    private boolean doubleClick;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";

    public Text(Composite composite, int n) {
        this(composite, n, 0);
    }

    public Text(Composite composite, int n, int n2) {
        super(composite, Text.checkStyle(n), n2);
    }

    static int checkStyle(int n) {
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    protected void createHandle(int n) {
        int n2 = 1;
        if ((this.style & 0x1000000) != 0) {
            n2 = 4;
        } else if ((this.style & 0x20000) != 0) {
            n2 = 2;
        }
        if (this.variant() == 0) {
            this.scrollAreaHandle = 0;
            this.handle = OS.QLineEdit_new();
            OS.QLineEdit_setAlignment(this.handle, n2 | 0x80);
            OS.QLineEdit_setMaxLength(this.handle, LIMIT);
            if ((this.style & 0x400000) != 0) {
                OS.QLineEdit_setEchoMode(this.handle, 2);
            }
        } else {
            this.scrollAreaHandle = OS.QTextEdit_new();
            this.handle = OS.QAbstractScrollArea_viewPort(this.scrollAreaHandle);
            OS.QTextEdit_setAlignment(this.scrollAreaHandle, n2);
            this.forceTextLayout();
        }
        OS.QWidget_setGeometry(this.internal_topHandle(), 0, 0, 0, 0);
        this.state |= 8;
        if ((this.style & 8) != 0) {
            this.setEditable(false);
        }
    }

    protected void createWidget(int n) {
        super.createWidget(n);
        this.doubleClick = true;
        this.textLimit = 0;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        TextUtils.append(this.variant(), this.internal_topHandle(), string, this.textLimit, this);
    }

    protected void checkBorder() {
        super.checkBorder();
        if (this.variant() == 0) {
            OS.QLineEdit_setFrame(this.internal_topHandle(), (this.style & 0x800) != 0);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        TextUtils.clearSelection(this.variant(), this.internal_topHandle());
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.QWidget_updateGeometry(this.internal_topHandle());
        }
        if (n != -1 && n < 0) {
            n = -1;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = -1;
        }
        Point point = n != -1 && n2 != -1 ? new Point(n, n2) : (this.variant() == 0 ? (n == -1 && n2 == -1 ? this.getPreferredSingleLineClientAreaSize() : (n2 == -1 ? new Point(n, this.getPreferredSingleLineClientAreaSize().y) : new Point(this.getPreferredSingleLineClientAreaSize().x, n2))) : (n == -1 && n2 == -1 ? this.getPreferredClientAreaSize(-1) : (n2 == -1 ? new Point(n, this.getPreferredClientAreaSize((int)n).y) : new Point(this.getPreferredClientAreaSize((int)n2).y, n2))));
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (this.variant() == 0) {
            if ((this.style & 0x800) != 0) {
                int n5 = OS.QLineEdit_swt_getBorderWidth(this.internal_topHandle());
                n -= n5;
                n2 -= n5;
                n3 += 2 * n5;
                n4 += 2 * n5;
            }
            return new Rectangle(n, n2, n3, n4);
        }
        return super.computeTrim(n, n2, n3, n4);
    }

    public void copy() {
        this.checkWidget();
        TextUtils.copy(this.variant(), this.internal_topHandle());
    }

    public void cut() {
        this.checkWidget();
        TextUtils.cut(this.variant(), this.internal_topHandle(), this);
    }

    protected void deregister() {
        super.deregister();
        if (this.variant() == 1) {
            this.display.removeWidget(this.scrollAreaHandle);
        }
    }

    protected void forceTextLayout() {
        if (this.isVisible()) {
            return;
        }
        OS.QTextEdit_setLineWrapMode(this.scrollAreaHandle, 0);
        if ((this.style & 0x40) != 0) {
            OS.QTextEdit_setLineWrapMode(this.scrollAreaHandle, 1);
        }
    }

    public int getBorderWidth() {
        this.checkWidget();
        if (this.variant() == 0) {
            return (this.style & 0x800) != 0 ? OS.QLineEdit_swt_getBorderWidth(this.internal_topHandle()) : 0;
        }
        return super.getBorderWidth();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if (this.variant() == 0) {
            return 0;
        }
        return OS.QTextEdit_swt_getCaretLineNumber(this.internal_topHandle());
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if (this.variant() == 0) {
            return new Point(0, 0);
        }
        Rectangle rectangle = OS.QTextEdit_cursorRect(this.internal_topHandle());
        return new Point(rectangle.x, rectangle.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        return TextUtils.getCaretPosition(this.variant(), this.internal_topHandle());
    }

    public int getCharCount() {
        this.checkWidget();
        return TextUtils.getCharCount(this.variant(), this.internal_topHandle());
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        int n;
        this.checkWidget();
        if (this.variant() == 0 && ((n = OS.QLineEdit_echoMode(this.internal_topHandle())) == 2 || n == 3)) {
            return '*';
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        return !TextUtils.getReadOnly(this.variant(), this.internal_topHandle());
    }

    public int getLineCount() {
        this.checkWidget();
        if (this.variant() == 0) {
            return 1;
        }
        this.forceTextLayout();
        return OS.QTextEdit_swt_getLineCount(this.internal_topHandle());
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        if (this.variant() == 0) {
            return OS.QWidget_QFontMetrics_lineSpacing(this.internal_topHandle());
        }
        return OS.QTextEdit_swt_getLineHeight(this.internal_topHandle());
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    protected Point getPreferredClientAreaSize() {
        if (this.variant() == 0) {
            return this.getPreferredSingleLineClientAreaSize();
        }
        return this.getPreferredClientAreaSize(-1);
    }

    private Point getPreferredClientAreaSize(int n) {
        Point point = OS.QTextEdit_swt_preferredClientSize(this.internal_topHandle(), n);
        if (point == null) {
            return new Point(64, 64);
        }
        if (point.x < 0) {
            point.x = 64;
        }
        if (point.y < 0) {
            point.y = 64;
        }
        return point;
    }

    private Point getPreferredSingleLineClientAreaSize() {
        Point point = OS.QLineEdit_swt_preferredClientSize(this.internal_topHandle());
        if (point == null) {
            return new Point(64, 64);
        }
        if (point.x < 0) {
            point.x = 64;
        }
        if (point.y < 0) {
            point.y = 64;
        }
        return point;
    }

    public Point getSelection() {
        this.checkWidget();
        return TextUtils.getSelection(this.variant(), this.internal_topHandle());
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point point = this.getSelection();
        return Math.abs(point.y - point.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        return TextUtils.getSelectionText(this.variant(), this.internal_topHandle());
    }

    public String getText() {
        this.checkWidget();
        return TextUtils.getText(this.variant(), this.internal_topHandle());
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || n2 < 0) {
            return "";
        }
        String string = this.getText();
        if (string != null) {
            if (n >= string.length()) {
                string = "";
            } else {
                n = Math.max(0, n);
                n2 = Math.min(n2, string.length() - 1);
                string = string.substring(n, n2 + 1);
            }
        }
        return string;
    }

    public int getTextLimit() {
        this.checkWidget();
        if (this.variant() == 0) {
            return OS.QLineEdit_maxLength(this.internal_topHandle());
        }
        return this.textLimit > 0 ? this.textLimit : LIMIT;
    }

    public int getTopIndex() {
        this.checkWidget();
        if (this.variant() == 0) {
            return 0;
        }
        return OS.QTextEdit_swt_getTopIndex(this.internal_topHandle());
    }

    public int getTopPixel() {
        this.checkWidget();
        if (this.variant() == 0) {
            return 0;
        }
        return OS.QScrollBar_value(OS.QAbstractScrollArea_verticalScrollBar(this.scrollAreaHandle));
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1009);
        if (this.variant() == 0) {
            OS.QObject_connectOrThrow(this.internal_topHandle(), "textChanged(const QString&)", n, "widgetSignal(const QString&)", 0);
            int n2 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1011);
            OS.QObject_connectOrThrow(this.internal_topHandle(), "returnPressed()", n2, "widgetSignal()", 0);
        } else {
            OS.QObject_connectOrThrow(this.internal_topHandle(), "textChanged()", n, "widgetSignal()", 0);
        }
    }

    public void insert(String string) {
        this.checkWidget();
        TextUtils.insert(this.variant(), this.internal_topHandle(), string, this.textLimit, this);
    }

    public void paste() {
        TextUtils.paste(this.variant(), this.internal_topHandle(), this.textLimit, this);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        TextUtils.selectAll(this.variant(), this.internal_topHandle());
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        if (this.variant() == 0) {
            int n = c == '\u0000' ? 0 : 2;
            OS.QLineEdit_setEchoMode(this.internal_topHandle(), n);
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        TextUtils.setReadOnly(this.variant(), this.internal_topHandle(), !bl);
    }

    public void setOrientation(int n) {
        this.setOrientation(this.internal_topHandle(), n);
    }

    public void setSelection(int n) {
        this.checkWidget();
        n = Math.min(Math.max(0, n), this.getCharCount());
        this.setSelection(n, n);
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        TextUtils.setSelection(this.variant(), this.internal_topHandle(), n, n2);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setText(String string) {
        this.checkWidget();
        TextUtils.setText(this.variant(), this.internal_topHandle(), string, this.textLimit, this);
        if (this.isDisposed()) {
            return;
        }
        if (this.variant() == 1) {
            OS.QScrollBar_setValue(OS.QAbstractScrollArea_verticalScrollBar(this.scrollAreaHandle), 0);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (n < 0 || n > LIMIT) {
            n = LIMIT;
        }
        if (this.variant() == 0) {
            OS.QLineEdit_setMaxLength(this.internal_topHandle(), n);
        } else {
            this.textLimit = n;
            if (this.getCharCount() > n) {
                OS.QTextEdit_setPlainText(this.internal_topHandle(), this.getText().substring(0, n));
            }
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (this.variant() == 1) {
            n = Math.min(Math.max(n, 0), OS.QTextEdit_swt_getLineCount(this.internal_topHandle()) - 1);
            OS.QTextEdit_swt_setTopIndex(this.internal_topHandle(), n);
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.variant() == 1) {
            OS.QTextEdit_ensureCursorVisible(this.internal_topHandle());
        }
    }

    public int internal_topHandle() {
        return this.variant() == 0 ? this.handle : this.scrollAreaHandle;
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        if (this.variant() == 1 && n != this.scrollAreaHandle) {
            return false;
        }
        if (super.qt_event_keypress(n, n2, n3, n4)) {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25) && this.textLimit <= 0) {
            return false;
        }
        Event event = this.makeKeyEvent(n2, n3, n4);
        return TextUtils.handle_keypress(this.variant(), n, n2, n3, n4, event, this.textLimit, this);
    }

    protected boolean qt_event_mouseButtonDblClick(int n, int n2, int n3, int n4, int n5, int n6) {
        super.qt_event_mouseButtonDblClick(n, n2, n3, n4, n5, n6);
        return !this.doubleClick;
    }

    protected void qt_signal_return_pressed() {
        this.sendEvent(14);
    }

    protected void qt_signal_text_changed(String string) {
        this.sendEvent(24);
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = false;
        this.traverseCancel = false;
        if (n == 128) {
            this.traverseDoit = true;
            return;
        }
        switch (n2) {
            case 0x1000004: 
            case 0x1000005: {
                this.traverseDoit = false;
                if ((this.getStyle() & 4) == 0 || this.variant() != 1) break;
                this.traverseCancel = true;
                break;
            }
            case 0x1000001: {
                this.traverseDoit = (this.getStyle() & 4) != 0;
                break;
            }
            case 0x1000013: {
                if ((n3 & 0x2000000) != 0 || this.getCaretLineNumber() != 0) break;
                this.traverseDoit = true;
                break;
            }
            case 0x1000015: {
                if ((n3 & 0x2000000) != 0 || this.getCaretLineNumber() != this.getLineCount() - 1) break;
                this.traverseDoit = true;
                break;
            }
            case 0x1000012: 
            case 0x1000014: {
                this.traverseDoit = false;
                break;
            }
            default: {
                super.setTraversalFlags(n, n2, n3, n4);
            }
        }
    }

    protected int variant() {
        return (this.getStyle() & 4) != 0 ? 0 : 1;
    }

    protected void setBackground() {
        if ((this.style & 2) != 0) {
            OS.QWidget_swt_unsetPalette(this.handle);
        }
        super.setBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backgroundImageApplied(Image image) {
        if ((this.style & 2) == 0) {
            return;
        }
        int n = 0;
        try {
            n = OS.QWidget_swt_palette_new(this.handle);
            int[] nArray = this.getBackgroundImageRoles();
            for (int i = 0; i < nArray.length; ++i) {
                OS.QPalette_swt_setBrush(n, nArray[i], 0);
            }
            OS.QWidget_setPalette(this.handle, n);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            OS.QPalette_delete(n);
            throw throwable;
        }
        OS.QPalette_delete(n);
    }
}

