/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.Vector;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.WrappedLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;

public class AddLocalScreen
extends AbsScreen
implements ModifyListener {
    Text name;
    Text url;
    Vector bookmarks = new Vector();
    Composite screenPane;
    ScrollBar scrollBarV;
    Rectangle screenPaneBounds;

    public AddLocalScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.screenPane = this.init(UIMessages.YouSelectedLocal, true);
        this.scrollBarV = this.screen.getVerticalBar();
        this.scrollBarV.addSelectionListener((SelectionListener)this);
        WrappedLabel wrappedLabel = new WrappedLabel(this.screenPane, 0, 0);
        if (3 == this.view.osType) {
            wrappedLabel.setText(UIMessages.EnterName2);
        } else {
            wrappedLabel.setText(UIMessages.EnterName);
        }
        this.name = new Text(this.screenPane, 2048);
        this.name.setLayoutData((Object)new GridData(768));
        this.name.addModifyListener((ModifyListener)this);
        WrappedLabel wrappedLabel2 = new WrappedLabel(this.screenPane, 0, 0);
        wrappedLabel2.setText(UIMessages.LocalSite);
        this.url = new Text(this.screenPane, 2048);
        this.url.setEditable(false);
        this.url.setLayoutData((Object)new GridData(768));
        this.fillSpace();
        this.separator();
        this.setButtons(1, 0, 4);
        if (3 == this.view.osType) {
            wrappedLabel.label.setFont(this.view.fontOnS60);
            this.name.setFont(this.view.fontOnS60);
            wrappedLabel2.label.setFont(this.view.fontOnS60);
            this.url.setFont(this.view.fontOnS60);
        }
        this.screen.pack();
        this.screen.layout();
    }

    protected void refresh() {
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.name.setText("");
        this.url.setText("");
        BookmarkUtil.load(this.view.bookmarkFile, this.bookmarks);
    }

    protected void action() {
        if (2 == this.view.osType) {
            this.url.setText("file://" + this.view.currentName);
        } else if (1 == this.view.osType) {
            this.url.setText("file:///" + this.view.currentName);
        } else if (3 == this.view.osType) {
            this.url.setText("file:/" + this.view.currentName);
        }
        this.name.setText(this.view.currentName.substring(0, this.view.currentName.lastIndexOf(47)));
        this.name.setSelection(this.name.getCharCount());
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.name.setFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.backButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(5, false);
        } else if (selectionEvent.widget == this.nextButton.widget) {
            BookmarkSite bookmarkSite = new BookmarkSite(this.name.getText(), this.url.getText(), false, true, true, "");
            this.bookmarks.add(bookmarkSite);
            BookmarkUtil.store(this.view.bookmarkFile, this.bookmarks);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, true);
        } else if (selectionEvent.widget == this.scrollBarV) {
            this.screenPane.setBounds(this.screenPaneBounds.x, this.screenPaneBounds.y - this.scrollBarV.getSelection(), this.screenPaneBounds.width, this.screenPaneBounds.height + this.scrollBarV.getSelection());
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (this.name.getText().length() == 0 || BookmarkUtil.searchByName(this.bookmarks, this.name.getText()) >= 0) {
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
    }

    public void controlResized(ControlEvent controlEvent) {
        if (!this.screen.isDisposed()) {
            this.screen.setBounds(this.view.parent.getClientArea());
        }
        if (this.buttonPane == null) {
            return;
        }
        this.screenPaneBounds = this.screenPane.getBounds();
        int n = this.buttonPane.getLocation().y + this.buttonPane.getSize().y;
        int n2 = this.screenPane.getSize().y;
        if (n > n2) {
            this.scrollBarV.setMaximum(n - n2);
            this.scrollBarV.setSelection(0);
            if (!this.scrollBarV.getVisible()) {
                this.scrollBarV.setVisible(true);
            }
        } else if (this.scrollBarV.getVisible()) {
            this.scrollBarV.setVisible(false);
        }
    }
}

