/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;

public class StatusUtil {
    protected static List flatten(IStatus iStatus) {
        ArrayList arrayList = new ArrayList();
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                IStatus iStatus2 = iStatusArray[n];
                if (iStatus2.isMultiStatus()) {
                    Iterator iterator = StatusUtil.flatten(iStatus2).iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(iterator.next());
                    }
                } else {
                    arrayList.add(iStatus2);
                }
                ++n;
            }
        } else {
            arrayList.add(iStatus);
        }
        return arrayList;
    }

    protected static IStatus newStatus(IStatus[] iStatusArray, String string, Throwable throwable) {
        Assert.isTrue(string != null);
        Assert.isTrue(string.trim().length() != 0);
        return new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 4, iStatusArray, string, throwable);
    }

    public static IStatus newStatus(String string, Throwable throwable) {
        return StatusUtil.newStatus(string, StatusUtil.getLocalizedMessage(throwable), throwable);
    }

    public static String getLocalizedMessage(Throwable throwable) {
        String string = throwable.getLocalizedMessage();
        if (string != null) {
            return string;
        }
        if (throwable instanceof CoreException) {
            CoreException coreException = (CoreException)throwable;
            return coreException.getStatus().getMessage();
        }
        return WorkbenchMessages.StatusUtil_errorOccurred;
    }

    public static IStatus newStatus(IStatus iStatus, String string) {
        return new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), string, iStatus.getException());
    }

    public static IStatus newStatus(String string, String string2, Throwable throwable) {
        return new Status(4, string, 0, string2, StatusUtil.getCause(throwable));
    }

    public static Throwable getCause(Throwable throwable) {
        Throwable throwable2 = null;
        if (throwable != null) {
            if (throwable instanceof CoreException) {
                CoreException coreException = (CoreException)throwable;
                throwable2 = coreException.getStatus().getException();
            }
            if (throwable2 == null) {
                throwable2 = throwable;
            }
        }
        return throwable2;
    }

    public static IStatus newStatus(int n, String string, Throwable throwable) {
        String string2 = string;
        if (string == null || string.trim().length() == 0) {
            string2 = throwable.getMessage() == null ? ((Object)throwable).toString() : throwable.getMessage();
        }
        return new Status(n, WorkbenchPlugin.PI_WORKBENCH, n, string2, StatusUtil.getCause(throwable));
    }

    public static IStatus newStatus(List list, String string, Throwable throwable) {
        IStatus iStatus;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iStatus = (IStatus)iterator.next();
            Iterator iterator2 = StatusUtil.flatten(iStatus).iterator();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        iStatus = new IStatus[arrayList.size()];
        arrayList.toArray((T[])iStatus);
        return StatusUtil.newStatus((IStatus[])iStatus, string, throwable);
    }
}

