/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public abstract class CategorizedPageRegistryReader
extends RegistryReader {
    public static final String ATT_CATEGORY = "category";
    static final String PREFERENCE_SEPARATOR = "/";
    List topLevelNodes;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object object, Object object2) {
            String string = ((CategoryNode)object).getFlatCategory();
            String string2 = ((CategoryNode)object2).getFlatCategory();
            return this.collator.compare(string, string2);
        }
    };

    void processNodes() {
        this.topLevelNodes = new ArrayList();
        Object object = null;
        String string = this.getFavoriteNodeId();
        if (string != null) {
            object = this.findNode(string);
        }
        if (object != null) {
            this.topLevelNodes.add(object);
        }
        Object[] objectArray = this.sortByCategories(this.getNodes());
        int n = 0;
        while (n < objectArray.length) {
            CategoryNode categoryNode = (CategoryNode)objectArray[n];
            Object object2 = categoryNode.getNode();
            if (object2 != object) {
                String string2 = this.getCategory(object2);
                if (string2 == null) {
                    this.topLevelNodes.add(object2);
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, PREFERENCE_SEPARATOR);
                    Object object3 = null;
                    while (stringTokenizer.hasMoreElements()) {
                        String string3 = stringTokenizer.nextToken();
                        Object object4 = null;
                        object4 = object3 == null ? this.findNode(string3) : this.findNode(object3, string3);
                        if (object4 == null) {
                            object3 = null;
                            break;
                        }
                        object3 = object4;
                    }
                    if (object3 != null) {
                        this.add(object3, object2);
                    } else {
                        WorkbenchPlugin.log("Invalid org.eclipse.jface.preference page path: " + categoryNode.getFlatCategory());
                        this.topLevelNodes.add(object2);
                    }
                }
            }
            ++n;
        }
    }

    abstract String getCategory(Object var1);

    abstract void add(Object var1, Object var2);

    abstract Collection getNodes();

    abstract String getFavoriteNodeId();

    Object[] sortByCategories(Collection collection) {
        ArrayList<CategoryNode> arrayList = new ArrayList<CategoryNode>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.createCategoryNode(this, iterator.next()));
        }
        Collections.sort(arrayList, comparer);
        return arrayList.toArray();
    }

    abstract CategoryNode createCategoryNode(CategorizedPageRegistryReader var1, Object var2);

    abstract Object findNode(String var1);

    abstract Object findNode(Object var1, String var2);

    abstract class CategoryNode {
        private final CategorizedPageRegistryReader reader;
        private String flatCategory;

        public CategoryNode(CategorizedPageRegistryReader categorizedPageRegistryReader2) {
            this.reader = categorizedPageRegistryReader2;
        }

        public String getFlatCategory() {
            if (this.flatCategory == null) {
                this.initialize();
                if (this.flatCategory == null) {
                    this.flatCategory = this.getLabelText();
                }
            }
            return this.flatCategory;
        }

        abstract String getLabelText();

        private void initialize() {
            String string = this.reader.getCategory(this.getNode());
            if (string == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, CategorizedPageRegistryReader.PREFERENCE_SEPARATOR);
            Object object = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                object = this.reader.findNode(string2);
                if (object == null) {
                    return;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(CategorizedPageRegistryReader.PREFERENCE_SEPARATOR);
                }
                stringBuffer.append(this.getLabelText(object));
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(CategorizedPageRegistryReader.PREFERENCE_SEPARATOR);
            }
            stringBuffer.append(this.getLabelText());
            this.flatCategory = ((Object)stringBuffer).toString();
        }

        abstract String getLabelText(Object var1);

        abstract Object getNode();
    }
}

