/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class ErrorRecoveryLog {
    public static final boolean RECOVERY_ON = false;
    private static final String ERROR_RECOVERY_LOG = "error_recovery.log";
    private static final String LOG_ENTRY_KEY = "LogEntry.";
    private static final String RETURN_CARRIAGE = "\r\n";
    private static final String END_OF_FILE = "eof=eof";
    public static final String START_INSTALL_LOG = "START_INSTALL_LOG";
    public static final String PLUGIN_ENTRY = "PLUGIN";
    public static final String FRAGMENT_ENTRY = "FRAGMENT";
    public static final String BUNDLE_MANIFEST_ENTRY = "BUNDLE_MANIFEST";
    public static final String BUNDLE_JAR_ENTRY = "BUNDLE";
    public static final String FEATURE_ENTRY = "FEATURE";
    public static final String ALL_INSTALLED = "ALL_FEATURES_INSTALLED";
    public static final String RENAME_ENTRY = "RENAME";
    public static final String END_INSTALL_LOG = "END_INSTALL_LOG";
    public static final String START_REMOVE_LOG = "REMOVE_LOG";
    public static final String END_ABOUT_REMOVE = "END_ABOUT_TO_REMOVE";
    public static final String DELETE_ENTRY = "DELETE";
    public static final String END_REMOVE_LOG = "END_REMOVE_LOG";
    public static boolean forceRemove = false;
    private static ErrorRecoveryLog inst;
    private FileWriter out;
    private int index;
    private List paths;
    private boolean open = false;
    private int nbOfOpen = 0;

    private ErrorRecoveryLog() {
    }

    public static ErrorRecoveryLog getLog() {
        if (inst == null) {
            inst = new ErrorRecoveryLog();
        }
        return inst;
    }

    public static String getLocalRandomIdentifier(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(File.separator) || string.endsWith("/")) {
            return string;
        }
        File file = new File(string);
        String string2 = UpdateManagerUtils.getLocalRandomIdentifier(file.getName(), new Date());
        while (new File(string2).exists()) {
            string2 = UpdateManagerUtils.getLocalRandomIdentifier(file.getName(), new Date());
        }
        File file2 = new File(file.getParentFile(), string2);
        return file2.getAbsolutePath();
    }

    public File getRecoveryLogFile() {
        IPlatformConfiguration iPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        URL uRL = iPlatformConfiguration.getConfigurationLocation();
        String string = uRL.getFile();
        File file = new File(string);
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        return new File(file, ERROR_RECOVERY_LOG);
    }

    public void open(String string) throws CoreException {
        if (this.open) {
            ++this.nbOfOpen;
            UpdateCore.warn("Open nested Error/Recovery log #" + this.nbOfOpen + ":" + string);
            return;
        }
        File file = null;
        try {
            file = this.getRecoveryLogFile();
            this.out = new FileWriter(file);
            this.index = 0;
            this.paths = null;
            this.open = true;
            this.nbOfOpen = 0;
            UpdateCore.warn("Start new Error/Recovery log #" + this.nbOfOpen + ":" + string);
        }
        catch (IOException iOException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.UpdateManagerUtils_UnableToLog, (Object[])new Object[]{file}), iOException);
        }
        this.append(string);
    }

    public void append(String string) throws CoreException {
        Object var2_2 = null;
        try {
            if (!this.open) {
                UpdateCore.warn("Internal Error: The Error/Recovery log is not open:" + string);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(LOG_ENTRY_KEY);
            stringBuffer.append(this.index);
            stringBuffer.append("=");
            stringBuffer.append(string);
            stringBuffer.append(RETURN_CARRIAGE);
            this.out.write(((Object)stringBuffer).toString());
            this.out.flush();
            ++this.index;
        }
        catch (IOException iOException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.UpdateManagerUtils_UnableToLog, (Object[])new Object[]{var2_2}), iOException);
        }
    }

    public void appendPath(String string, String string2) throws CoreException {
        if (string2 == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        this.append(((Object)stringBuffer).toString());
        this.addPath(string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(String string) throws CoreException {
        if (this.nbOfOpen > 0) {
            UpdateCore.warn("Close nested Error/Recovery log #" + this.nbOfOpen + ":" + string);
            --this.nbOfOpen;
            return;
        }
        UpdateCore.warn("Close Error/Recovery log #" + this.nbOfOpen + ":" + string);
        this.append(string);
        if (this.out == null) return;
        try {
            try {
                this.out.write(END_OF_FILE);
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.out = null;
            this.open = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.out = null;
            this.open = false;
            return;
        }
    }

    public void delete() {
        this.getRecoveryLogFile();
    }

    private void addPath(String string) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        this.paths.add(string);
    }

    public IStatus recover() {
        IStatus iStatus = this.createStatus(0, Messages.ErrorRecoveryLog_recoveringStatus, null);
        MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), iStatus.getCode(), iStatus.getMessage(), null);
        UpdateCore.warn("Recovering is turned off. Abort recovery");
        return multiStatus;
    }

    private IStatus createStatus(int n, String string, Exception exception) {
        String string2 = UpdateCore.getPlugin().getBundle().getSymbolicName();
        StringBuffer stringBuffer = new StringBuffer("");
        if (string != null) {
            stringBuffer.append(string);
        }
        if (exception != null) {
            stringBuffer.append("\r\n[");
            stringBuffer.append(((Object)exception).toString());
            stringBuffer.append("]\r\n");
        }
        return new Status(n, string2, 0, ((Object)stringBuffer).toString(), (Throwable)exception);
    }

    private IStatus processRecoverInstall(Properties properties) {
        IStatus iStatus = this.createStatus(0, "", null);
        MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), iStatus.getCode(), "", null);
        Collection<Object> collection = properties.values();
        if (collection.contains(END_INSTALL_LOG)) {
            this.delete();
            UpdateCore.warn("Found log file. Log file contains END_INSTALL_LOG. No need to process rename");
            multiStatus.add(this.createStatus(0, null, null));
            return multiStatus;
        }
        if (collection.contains(ALL_INSTALLED) && !forceRemove) {
            int n = 0;
            boolean bl = false;
            String string = properties.getProperty(LOG_ENTRY_KEY + n);
            while (string != null && !bl) {
                if (string.equalsIgnoreCase(ALL_INSTALLED)) {
                    bl = true;
                }
                IStatus iStatus2 = this.processRename(string);
                UpdateCore.log(iStatus2);
                if (iStatus2.getSeverity() != 0) {
                    multiStatus.add(iStatus2);
                }
                string = properties.getProperty(LOG_ENTRY_KEY + ++n);
            }
            if (string == null) {
                UpdateCore.warn(NLS.bind((String)Messages.ErrorRecoveryLog_wrongLogFile, (Object[])new String[]{LOG_ENTRY_KEY + n}));
                multiStatus.add(this.createStatus(4, NLS.bind((String)Messages.ErrorRecoveryLog_wrongLogFile, (Object[])new String[]{LOG_ENTRY_KEY + n}), null));
                return multiStatus;
            }
            this.delete();
            UpdateCore.warn("Found log file. Successfully recovered by renaming. Feature is installed.");
            multiStatus.add(this.createStatus(0, null, null));
        } else {
            int n = 0;
            String string = properties.getProperty(LOG_ENTRY_KEY + n);
            while (string != null) {
                IStatus iStatus3 = this.processRemove(string);
                UpdateCore.log(iStatus3);
                if (iStatus3.getSeverity() != 0) {
                    multiStatus.addAll(iStatus3);
                }
                string = properties.getProperty(LOG_ENTRY_KEY + ++n);
            }
            this.delete();
            UpdateCore.warn("Found log file. Successfully recovered by removing. Feature is removed.");
            multiStatus.add(this.createStatus(0, null, null));
        }
        return multiStatus;
    }

    private IStatus processRename(String string) {
        int n = -1;
        String string2 = null;
        if (string.startsWith(PLUGIN_ENTRY)) {
            n = PLUGIN_ENTRY.length();
            string2 = "plugin.xml";
        } else if (string.startsWith(BUNDLE_MANIFEST_ENTRY)) {
            n = BUNDLE_MANIFEST_ENTRY.length();
            string2 = "META-INF/MANIFEST.MF";
        } else if (string.startsWith(FRAGMENT_ENTRY)) {
            n = FRAGMENT_ENTRY.length();
            string2 = "fragment.xml";
        } else if (string.startsWith(FEATURE_ENTRY)) {
            n = FEATURE_ENTRY.length();
            string2 = "feature.xml";
        } else if (string.startsWith(BUNDLE_JAR_ENTRY)) {
            n = BUNDLE_JAR_ENTRY.length();
        }
        if (n == -1) {
            return this.createStatus(4, NLS.bind((String)Messages.ErrorRecoveryLog_noAction, (Object[])new String[]{string}), null);
        }
        String string3 = string.substring(n + 1);
        File file = new File(string3);
        File file2 = string.startsWith(BUNDLE_JAR_ENTRY) ? new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(".jar") + ".jar".length())) : new File(file.getParentFile(), string2);
        if (!file.exists()) {
            if (file2.exists()) {
                return this.createStatus(0, String.valueOf(Messages.ErrorRecoveryLog_fileAlreadyRenamed) + file2, null);
            }
            return this.createStatus(4, String.valueOf(Messages.ErrorRecoveryLog_cannotFindFile) + file, null);
        }
        boolean bl = false;
        if (file2.exists()) {
            UpdateManagerUtils.removeFromFileSystem(file2);
            UpdateCore.warn("Removing already existing file:" + file2);
        }
        if (!(bl = file.renameTo(file2))) {
            String string4 = NLS.bind((String)Messages.ErrorRecoveryLog_oldToNew, (Object[])new String[]{((Object)file).toString(), ((Object)file2).toString()});
            return this.createStatus(4, string4, null);
        }
        return this.createStatus(0, NLS.bind((String)Messages.ErrorRecoveryLog_renamed, (Object[])new String[]{((Object)file).toString(), ((Object)file2).toString()}), null);
    }

    private IStatus processRemove(String string) {
        IStatus iStatus = this.createStatus(0, "", null);
        MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), iStatus.getCode(), "", null);
        int n = -1;
        if (string.startsWith(BUNDLE_JAR_ENTRY)) {
            n = BUNDLE_JAR_ENTRY.length();
        }
        if (n == -1) {
            return this.createStatus(4, NLS.bind((String)Messages.ErrorRecoveryLog_noAction, (Object[])new String[]{string}), null);
        }
        String string2 = string.substring(n + 1);
        File file = new File(string2);
        if (!file.exists()) {
            multiStatus.add(this.createStatus(4, String.valueOf(Messages.ErrorRecoveryLog_cannotFindFile) + file, null));
            return multiStatus;
        }
        multiStatus.addAll(this.removeFromFileSystem(file));
        return multiStatus;
    }

    public IStatus removeFromFileSystem(File file) {
        Object object;
        IStatus iStatus = this.createStatus(0, "", null);
        MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), iStatus.getCode(), "", null);
        if (!file.exists()) {
            multiStatus.add(this.createStatus(4, NLS.bind((String)Messages.ErrorRecoveryLog_noFiletoRemove, (Object[])new String[]{((Object)file).toString()}), null));
            return multiStatus;
        }
        if (file.isDirectory() && (object = file.list()) != null) {
            int n = 0;
            while (n < ((String[])object).length) {
                multiStatus.addAll(this.removeFromFileSystem(new File(file, object[n])));
                ++n;
            }
        }
        if (!file.delete()) {
            object = "Unable to remove file" + file.getAbsolutePath();
            multiStatus.add(this.createStatus(4, (String)object, null));
        }
        return multiStatus;
    }

    private IStatus processRecoverRemove(Properties properties) {
        IStatus iStatus = this.createStatus(0, "", null);
        MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), iStatus.getCode(), "", null);
        Collection<Object> collection = properties.values();
        if (collection.contains(END_REMOVE_LOG)) {
            this.delete();
            UpdateCore.warn("Found log file. Log file contains END_REMOVE_LOG. No need to process rename");
            multiStatus.add(this.createStatus(0, null, null));
            return multiStatus;
        }
        if (!collection.contains(END_ABOUT_REMOVE)) {
            multiStatus.add(this.createStatus(4, Messages.ErrorRecoveryLog_removeFeature, null));
            return multiStatus;
        }
        int n = 0;
        boolean bl = false;
        String string = properties.getProperty(LOG_ENTRY_KEY + n);
        while (string != null && !bl) {
            if (string.equalsIgnoreCase(END_ABOUT_REMOVE)) {
                bl = true;
            }
            IStatus iStatus2 = this.processRemove(string);
            UpdateCore.log(iStatus2);
            if (iStatus2.getSeverity() != 0) {
                multiStatus.add(iStatus2);
            }
            string = properties.getProperty(LOG_ENTRY_KEY + ++n);
        }
        if (string == null) {
            UpdateCore.warn(NLS.bind((String)Messages.ErrorRecoveryLog_wrongLogFile, (Object[])new String[]{LOG_ENTRY_KEY + n}));
            multiStatus.add(this.createStatus(4, NLS.bind((String)Messages.ErrorRecoveryLog_wrongLogFile, (Object[])new String[]{LOG_ENTRY_KEY + n}), null));
            return multiStatus;
        }
        this.delete();
        UpdateCore.warn("Found log file. Successfully recovered by deleting. Feature is removed.");
        multiStatus.add(this.createStatus(0, null, null));
        return multiStatus;
    }
}

