/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.LocalSite;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class SiteStatusAnalyzer {
    private static List allConfiguredFeatures;
    private LocalSite siteLocal;

    public SiteStatusAnalyzer(LocalSite localSite) {
        this.siteLocal = localSite;
    }

    private IStatus getStatus(IFeature iFeature) {
        IStatus iStatus;
        ISite iSite = iFeature.getSite();
        if (iSite == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Cannot determine status of feature:" + iFeature.getLabel() + ". Site is NULL.");
            }
            String string = NLS.bind((String)Messages.SiteLocal_UnableToDetermineFeatureStatusSiteNull, (Object[])new Object[]{iFeature.getURL()});
            return this.createStatus(4, 1, string, null);
        }
        ConfiguredSite configuredSite = (ConfiguredSite)iSite.getCurrentConfiguredSite();
        if (configuredSite == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.warn("Cannot determine status of feature: " + iFeature.getLabel() + ". Configured Site is NULL.");
            }
            String string = NLS.bind((String)Messages.SiteLocal_UnableToDetermineFeatureStatusConfiguredSiteNull, (Object[])new Object[]{iFeature.getURL()});
            return this.createStatus(4, 1, string, null);
        }
        ISiteFeatureReference iSiteFeatureReference = configuredSite.getSite().getFeatureReference(iFeature);
        if (iSiteFeatureReference != null) {
            if (!configuredSite.getConfigurationPolicy().isConfigured(iSiteFeatureReference)) {
                return this.createStatus(0, -1, "", null);
            }
        } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.warn("Unable to find reference for feature " + iFeature + " in site " + configuredSite.getSite().getURL());
        }
        if ((iStatus = configuredSite.getBrokenStatus(iFeature)).getSeverity() != 0) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Feature broken:" + iFeature.getLabel() + ".Site:" + configuredSite.toString());
            }
            return iStatus;
        }
        IPluginEntry[] iPluginEntryArray = iFeature.getPluginEntries();
        return this.status(iPluginEntryArray);
    }

    public IStatus getFeatureStatus(IFeature iFeature) throws CoreException {
        IFeature iFeature2 = null;
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
        String string = Messages.SiteLocal_FeatureDisable;
        int n = -1;
        IStatus iStatus = this.getStatus(iFeature);
        MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), n, string, null);
        if (iStatus.getSeverity() == 4) {
            if (iStatus.isMultiStatus()) {
                multiStatus.addAll(iStatus);
            } else {
                multiStatus.add(iStatus);
            }
        }
        if (iStatus.getCode() > n) {
            n = iStatus.getCode();
        }
        if (n != -1) {
            int n2 = 0;
            while (n2 < iIncludedFeatureReferenceArray.length) {
                if (!UpdateManagerUtils.isOptional(iIncludedFeatureReferenceArray[n2])) {
                    String string2;
                    Object object;
                    block22: {
                        try {
                            iFeature2 = iIncludedFeatureReferenceArray[n2].getFeature(null);
                        }
                        catch (CoreException coreException) {
                            iFeature2 = null;
                            if (UpdateManagerUtils.isOptional(iIncludedFeatureReferenceArray[n2])) break block22;
                            UpdateCore.warn("Error retrieving feature:" + iIncludedFeatureReferenceArray[n2]);
                        }
                    }
                    if (iFeature2 == null) {
                        UpdateCore.warn("getFeatureStatus: Feature is null for:" + iIncludedFeatureReferenceArray[n2]);
                        object = iIncludedFeatureReferenceArray[n2].getURL();
                        object = iIncludedFeatureReferenceArray[n2].getVersionedIdentifier();
                        string2 = NLS.bind((String)Messages.SiteLocal_NestedFeatureUnavailable, (Object[])new Object[]{object});
                        multiStatus.add(this.createStatus(4, 2, string2, null));
                        if (2 > n) {
                            n = 2;
                        }
                    } else {
                        String string3;
                        IStatus iStatus2 = this.getFeatureStatus(iFeature2);
                        if (iStatus2.getCode() == -1) {
                            object = iFeature2.getVersionedIdentifier();
                            string2 = object == null ? "" : ((VersionedIdentifier)object).getVersion().toString();
                            string3 = NLS.bind((String)Messages.SiteLocal_NestedFeatureDisable, (Object[])new String[]{iFeature2.getLabel(), string2});
                            multiStatus.add(this.createStatus(4, iStatus2.getCode(), string3, null));
                            if (2 > n) {
                                n = 2;
                            }
                        }
                        if (iStatus2.getSeverity() != 0) {
                            object = iFeature2.getVersionedIdentifier();
                            string2 = object == null ? "" : ((VersionedIdentifier)object).getVersion().toString();
                            string3 = NLS.bind((String)Messages.SiteLocal_NestedFeatureUnHappy, (Object[])new String[]{iFeature2.getLabel(), string2});
                            multiStatus.add(this.createStatus(4, iStatus2.getCode(), string3, null));
                            if (iStatus2.getCode() > n) {
                                n = iStatus2.getCode();
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        switch (n) {
            case 0: {
                string = Messages.SiteLocal_FeatureHappy;
                break;
            }
            case 2: {
                string = Messages.SiteLocal_FeatureUnHappy;
                break;
            }
            case 1: {
                string = Messages.SiteLocal_FeatureAmbiguous;
                break;
            }
            case -1: {
                string = Messages.SiteLocal_FeatureDisable;
                break;
            }
            default: {
                string = Messages.SiteLocal_FeatureStatusUnknown;
            }
        }
        MultiStatus multiStatus2 = new MultiStatus(iStatus.getPlugin(), n, string, null);
        multiStatus2.addAll((IStatus)multiStatus);
        return multiStatus2;
    }

    private IStatus status(IPluginEntry[] iPluginEntryArray) {
        String string = Messages.SiteLocal_FeatureHappy;
        String string2 = Messages.SiteLocal_FeatureAmbiguous;
        IStatus iStatus = this.createStatus(0, 0, "", null);
        Object object = new MultiStatus(iStatus.getPlugin(), 1, string2, null);
        PackageAdmin packageAdmin = UpdateCore.getPlugin().getPackageAdmin();
        int n = 0;
        while (n < iPluginEntryArray.length) {
            MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), 1, string2, null);
            VersionedIdentifier versionedIdentifier = iPluginEntryArray[n].getVersionedIdentifier();
            boolean bl = false;
            String string3 = String.valueOf('[') + versionedIdentifier.getVersion().toString() + ',' + versionedIdentifier.getVersion().toString() + ']';
            Bundle[] bundleArray = packageAdmin.getBundles(versionedIdentifier.getIdentifier(), string3);
            if (bundleArray != null && bundleArray.length == 1) {
                bl = true;
            } else {
                String string4;
                bundleArray = packageAdmin.getBundles(versionedIdentifier.getIdentifier(), null);
                int n2 = 0;
                while (bundleArray != null && n2 < bundleArray.length) {
                    Object[] objectArray;
                    string4 = (String)bundleArray[n2].getHeaders().get("Bundle-Version");
                    IFeature iFeature = this.getFeatureForId(new VersionedIdentifier(bundleArray[n2].getSymbolicName(), string4));
                    String string5 = null;
                    if (iFeature == null) {
                        objectArray = new Object[]{bundleArray[n2].getSymbolicName(), versionedIdentifier.getVersion(), string4};
                        string5 = NLS.bind((String)Messages.SiteLocal_TwoVersionSamePlugin1, (Object[])objectArray);
                    } else {
                        objectArray = iFeature.getLabel();
                        String string6 = iFeature.getVersionedIdentifier().getVersion().toString();
                        Object[] objectArray2 = new Object[]{bundleArray[n2].getSymbolicName(), versionedIdentifier.getVersion(), string4, objectArray, string6};
                        string5 = NLS.bind((String)Messages.SiteLocal_TwoVersionSamePlugin2, (Object[])objectArray2);
                    }
                    UpdateCore.warn("Found another version of the same plugin on the path:" + bundleArray[n2].getSymbolicName() + " " + string4);
                    multiStatus.add(this.createStatus(4, 1, string5, null));
                    ++n2;
                }
                if (!bl) {
                    if (multiStatus.getChildren().length > 0) {
                        object.addAll((IStatus)multiStatus);
                    } else {
                        if (object.getCode() != 2) {
                            String string7 = Messages.SiteLocal_FeatureUnHappy;
                            string4 = new MultiStatus(iStatus.getPlugin(), 2, string7, null);
                            string4.addAll((IStatus)object);
                            object = string4;
                        }
                        String string8 = NLS.bind((String)Messages.SiteLocal_NoPluginVersion, (Object[])new String[]{versionedIdentifier.getIdentifier()});
                        object.add(this.createStatus(4, 2, string8, null));
                    }
                }
            }
            ++n;
        }
        if (!object.isOK()) {
            return object;
        }
        return this.createStatus(0, 0, string, null);
    }

    private IStatus createStatus(int n, int n2, String string, Exception exception) {
        String string2 = UpdateCore.getPlugin().getBundle().getSymbolicName();
        StringBuffer stringBuffer = new StringBuffer("");
        if (string != null) {
            stringBuffer.append(string);
        }
        if (exception != null) {
            stringBuffer.append("\r\n[");
            stringBuffer.append(((Object)exception).toString());
            stringBuffer.append("]\r\n");
        }
        return new Status(n, string2, n2, ((Object)stringBuffer).toString(), (Throwable)exception);
    }

    private IFeature[] getAllConfiguredFeatures() {
        IAdaptable[] iAdaptableArray;
        if (allConfiguredFeatures == null) {
            allConfiguredFeatures = new ArrayList();
            iAdaptableArray = this.siteLocal.getCurrentConfiguration().getConfiguredSites();
            int n = 0;
            while (n < iAdaptableArray.length) {
                IFeatureReference[] iFeatureReferenceArray = iAdaptableArray[n].getConfiguredFeatures();
                IFeature iFeature = null;
                int n2 = 0;
                while (n2 < iFeatureReferenceArray.length) {
                    iFeature = null;
                    try {
                        iFeature = iFeatureReferenceArray[n2].getFeature(null);
                    }
                    catch (CoreException coreException) {}
                    if (iFeature != null) {
                        allConfiguredFeatures.add(iFeature);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        iAdaptableArray = new IFeature[allConfiguredFeatures.size()];
        if (allConfiguredFeatures.size() > 0) {
            allConfiguredFeatures.toArray(iAdaptableArray);
        }
        return iAdaptableArray;
    }

    private IFeature getFeatureForId(VersionedIdentifier versionedIdentifier) {
        if (versionedIdentifier == null) {
            return null;
        }
        IFeature[] iFeatureArray = this.getAllConfiguredFeatures();
        IFeature iFeature = null;
        IPluginEntry[] iPluginEntryArray = null;
        IPluginEntry iPluginEntry = null;
        int n = 0;
        while (n < iFeatureArray.length) {
            iFeature = iFeatureArray[n];
            iPluginEntryArray = iFeature.getPluginEntries();
            int n2 = 0;
            while (n2 < iPluginEntryArray.length) {
                iPluginEntry = iPluginEntryArray[n2];
                if (versionedIdentifier.equals(iPluginEntry.getVersionedIdentifier())) {
                    return iFeature;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public class PluginIdentifier {
        private VersionedIdentifier id;
        private String label;
        private boolean isFragment = false;

        public PluginIdentifier(VersionedIdentifier versionedIdentifier, String string, boolean bl) {
            this.id = versionedIdentifier;
            this.label = string;
            this.isFragment = bl;
        }

        public VersionedIdentifier getVersionedIdentifier() {
            return this.id;
        }

        public boolean isFragment() {
            return this.isFragment;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

