/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.search.BaseFilter;

public class BackLevelFilter
extends BaseFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accept(IFeatureReference iFeatureReference) {
        try {
            PluginVersionIdentifier pluginVersionIdentifier = iFeatureReference.getVersionedIdentifier().getVersion();
            IFeature[] iFeatureArray = UpdateUtils.getInstalledFeatures(iFeatureReference.getVersionedIdentifier(), false);
            if (iFeatureArray.length == 0) {
                return true;
            }
            int n = 0;
            while (true) {
                if (n >= iFeatureArray.length) {
                    return true;
                }
                PluginVersionIdentifier pluginVersionIdentifier2 = iFeatureArray[n].getVersionedIdentifier().getVersion();
                if (!pluginVersionIdentifier.isGreaterThan(pluginVersionIdentifier2)) {
                    return false;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

