/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.eworkbench;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.registry.IWorkbenchRegistryConstants;

/**
 * A strategy to read application extensions from the registry.
 */
public class ApplicationRegistryReader extends RegistryReader {

	private static final String TAG_APPLICATION = "application"; //$NON-NLS-1$
	private static final String TAG_VIEWS = "views"; //$NON-NLS-1$
	public static final String ATT_LARGE = "large"; //$NON-NLS-1$
	public static final String ATT_NORMAL = "normal"; //$NON-NLS-1$
	public static final String ATT_STATUS = "status"; //$NON-NLS-1$
	private static final String ATT_ICON = "icon";
	private static final String ATT_VIEW_ID = "id";
	private static final String EXTENSION_POINT_VIEW = "org.eclipse.ui.views"; //$NON-NLS-1$

    private ApplicationRegistry registry;

    public ApplicationRegistryReader(ApplicationRegistry out) {
        super();
    	registry = out;
    }

    private String getIconPath(String id, String view) {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_VIEW);
		if(point == null)
			return null;

		IExtension[] extensions = point.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			if(!extensions[i].getNamespaceIdentifier().equals(id))
				continue;
			IConfigurationElement[] elements = extensions[i].getConfigurationElements();
			for (int j = 0; j < elements.length; j++) {
				if(!view.equals(elements[j].getAttribute(ATT_VIEW_ID)))
					continue;
				return elements[j].getAttribute(ATT_ICON);
			}
		}

		return null;
    }

    /**
     * readElement method comment.
     */
    // for dynamic UI - change access from protected to public
    protected boolean readElement(IConfigurationElement element) {

		if (element.getName().equals(TAG_APPLICATION)) {
            try {
                ApplicationDescriptor desc = new ApplicationDescriptor(
						element.getAttribute(IWorkbenchRegistryConstants.ATT_ID), element);
				
				IConfigurationElement[] children = element.getChildren();
				for (int i=0; i<children.length; i++) {
					if (children[i].getName().equals(TAG_VIEWS)) {
			            String view_id = children[i].getAttribute(ATT_NORMAL);
			            if (view_id != null) {
				            String icon = getIconPath(desc.getPluginId(), view_id);
				            desc.setImage(element.getNamespaceIdentifier(), icon);
			            	desc.setViewId(ATT_NORMAL, view_id);
			            } else {
			                WorkbenchPlugin.log(
			                        "Unable to find normal view in application descriptor.");//$NON-NLS-1$
			            }

			            view_id = children[i].getAttribute(ATT_LARGE);
			            if (view_id != null)
			            	desc.setViewId(ATT_LARGE, view_id);
			            
			            view_id = children[i].getAttribute(ATT_STATUS);
			            if (view_id != null)
			            	desc.setViewId(ATT_STATUS, view_id);
					}
				}

                registry.addApplication(desc);
			} catch (CoreException e) {
                // log an error since its not safe to open a dialog here
                WorkbenchPlugin.log(
                        "Unable to create application descriptor.", e.getStatus());//$NON-NLS-1$
            }
            return true;
        }
 
        return false;
    }

    public void readApplications(IExtensionRegistry in) {
        readRegistry(in, eWorkbenchPlugin.PLUGIN_ID, eWorkbenchPlugin.PL_APPLICATIONS);
    }
}
