/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.eworkbench;


import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;



/** Default perspective defines how eRCP apps get displayed 
 *
 */
public class DefaultPerspective implements IPerspectiveFactory{
	public static final String ID_PERSPECTIVE = "org.eclipse.ercp.eworkbench.DefaultPerspective"; //$NON-NLS-1$

	private static DefaultPerspective defaultPerspective;
	private IFolderLayout viewFolder;
	
	
    public DefaultPerspective() {
    	defaultPerspective = this;
	}
	
	public void addView(String viewId) {
	}
	
	static public DefaultPerspective getDefault() {
		return defaultPerspective;
	}

	public void createInitialLayout(IPageLayout layout) {
		//         layout.setEditorAreaVisible(false);
        // Top left.
        viewFolder = layout.createFolder(
	        "topLeft", IPageLayout.LEFT, (float) 0.26, null); //$NON-NLS-1$
	    viewFolder.addView(DefaultView.ID_VIEW);
        layout.addPerspectiveShortcut(ID_PERSPECTIVE);
        layout.addShowViewShortcut(DefaultView.ID_VIEW);		
	}

}