/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.eworkbench;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.IWorkbenchGraphicConstants;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;


public class DefaultView extends ViewPart implements IOpenListener, SelectionListener {
    public static final String ID_VIEW = "org.eclipse.ercp.eworkbench.DefaultView"; //$NON-NLS-1$
    public static final String ID_VIEW_2 = "org.eclipse.ercp.eworkbench.SimpleDefaultView";		 //$NON-NLS-1$
    private Composite parent;
    private TableViewer viewer;
	private IViewRegistry viewReg;
	private Command launchCommand;
	private Command listCommand;
	private Command exitCommand;
	private Command preferenceCommand;
	private String  currentPrefPage;
	
	
    class ViewContentProvider implements IStructuredContentProvider {
	    public void dispose() {
	        //no-op
	    }

	    public Object[] getElements(Object element) {
	        if (element instanceof IApplicationRegistry) {
	            return ((IApplicationRegistry) element).getApplications();
	        }
	        return null;
	    }

	    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	        //no-op
	    }
    }
    
    class ViewLabelProvider extends LabelProvider implements ITableLabelProvider {
	    /**
	     * List of all Image objects this label provider is responsible for.
	     */
	    private HashMap imageCache = new HashMap(5);

	    /**
	     * Indicates whether the default perspective is visually marked.
	     */
	    private boolean markDefault;

	    /**
	     * Creates a new label provider for applications.
	     * The default application is visually marked.
	     */
	    public ViewLabelProvider() {
	        this(true);
	    }

	    /**
	     * Creates a new label provider for apps.
	     * 
	     * @param markDefault <code>true</code> if the default app is to be
	     * visually marked, and <code>false</code> if the default app is
	     * not treated as anything special
	     */
	    public ViewLabelProvider(boolean markDefault) {
	        super();
	        this.markDefault = markDefault;
	    }

	    public final Image getImage(Object element) {
	        if (element instanceof IApplicationDescriptor) {
	            IApplicationDescriptor desc = (IApplicationDescriptor) element;
	            ImageDescriptor imageDescriptor = desc.getImageDescriptor();
	            if (imageDescriptor == null) {
	                imageDescriptor = WorkbenchImages
	                        .getImageDescriptor(IWorkbenchGraphicConstants.IMG_ETOOL_DEF_PERSPECTIVE);
	            }
	            Image image = (Image) imageCache.get(imageDescriptor);
	            if (image == null) {
	                image = imageDescriptor.createImage();
	                imageCache.put(imageDescriptor, image);
	            }
	            return image;
	        }
	        return null;
	    }

	    public final void dispose() {
	        for (Iterator i = imageCache.values().iterator(); i.hasNext();) {
	            ((Image) i.next()).dispose();
	        }
	        imageCache.clear();
	    }

	    public final String getText(Object element) {
	        if (element instanceof IApplicationDescriptor) {
	            IApplicationDescriptor desc = (IApplicationDescriptor) element;
	            String label = desc.getLabel();
	            return label;
	        }
	        return Messages.getString("AppNameUnknown"); //$NON-NLS-1$
	    }

	    public final Image getColumnImage(Object element, int columnIndex) {
	        return getImage(element);
	    }

	    public final String getColumnText(Object element, int columnIndex) {
	        return getText(element);
	    }
    }
    
	
	public DefaultView() {
		currentPrefPage = null;
	}
			
    public void createPartControl(Composite parent) {
    	this.parent = parent;
    	
		IApplicationRegistry appReg = eWorkbenchPlugin.getDefault().getApplicationRegistry();
		viewReg = eWorkbenchPlugin.getDefault().getWorkbench().getViewRegistry();
		
		viewer = new TableViewer(parent, SWT.H_SCROLL | SWT.V_SCROLL);
        viewer.setContentProvider(new ViewContentProvider());
        viewer.setLabelProvider(new ViewLabelProvider(false));
        viewer.setInput(appReg);
//mdr        viewer.addSelectionChangedListener(this);
        viewer.addOpenListener(this);
        
        enableLaunchCommand(true);

        exitCommand = new Command(parent.getShell(), Command.EXIT, 0);
        exitCommand.setText(Messages.getString("DefaultView.1")); //$NON-NLS-1$
        exitCommand.addSelectionListener(this);
    }

    private void enablePreferencesCommand(boolean enable) {
    	if (enable) {
			preferenceCommand= new Command(parent.getShell(), Command.SELECT, 10);
    		preferenceCommand.setText(Messages.getString("DefaultView.2")); //$NON-NLS-1$
    		preferenceCommand.addSelectionListener(this);
    	} else if (preferenceCommand != null) {
    		preferenceCommand.dispose();
    	}
    }	
    
    private void enableLaunchCommand(boolean enable) {
    	if (enable) {
    		launchCommand = new Command(parent.getShell(), Command.SELECT, 10);	
    		launchCommand.setText(Messages.getString("DefaultView.3")); //$NON-NLS-1$
    		launchCommand.setLongLabel(Messages.getString("DefaultView.4")); //$NON-NLS-1$
    		launchCommand.addSelectionListener(this);
    	} else if (launchCommand != null) {
    		launchCommand.dispose();
    	}
    }	
    
    private void enableListCommand(boolean enable) {
    	if (enable) {
    		listCommand = new Command(parent.getShell(), Command.SELECT, 1);	
    		listCommand.setText(Messages.getString("DefaultView.5")); //$NON-NLS-1$
    		listCommand.setLongLabel(Messages.getString("DefaultView.6")); //$NON-NLS-1$
    		listCommand.addSelectionListener(this);
    	} else if (listCommand != null){
    		listCommand.dispose();
    	}
    }	
    
    public void setFocus() {
        viewer.getControl().setFocus();
    }
	
    /**
     * Notifies that open request was made
     * 
     * @param event event object describing the selection
     */
    public void open(OpenEvent event) {
    	launchSelection(event.getSelection());
    }
    
    private void launchSelection(ISelection selection) {
    	if (selection.isEmpty())
    		return;
    	ApplicationDescriptor desc;
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection ss = (IStructuredSelection)selection;
			desc = (ApplicationDescriptor)ss.getFirstElement();
		}
		else if (selection instanceof ApplicationDescriptor) {
			desc = (ApplicationDescriptor) selection;
		}
		else
			return;
				
		// if screen size is larger than VGA try large view
		String viewId = null;
		Point size = parent.getSize();
		if ((size.x >= size.y && size.x > 640 && size.y > 480) ||
		    (size.x < size.y && size.y > 640 && size.x > 480)) {
			viewId = desc.getViewId(ApplicationRegistryReader.ATT_LARGE);
		}
		
		if (viewId == null) {
			viewId = desc.getViewId(ApplicationRegistryReader.ATT_NORMAL);
		}
		
		String viewName = desc.getLabel();
		if (viewName != null) {
			parent.getShell().setText(viewName);
		}
		
		try {
			eWorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()
				.getActivePage().showView(viewId);
			enablePreferencesCommand(hasPrefs(desc));
			enableLaunchCommand(false);
			enableListCommand(true);
		} catch (PartInitException ex) {
			System.out.println(ex);
		}
    }

	public void widgetSelected(SelectionEvent e) {
		
		if (e.widget == launchCommand) {
			launchSelection(viewer.getSelection());
		}
		else if (e.widget == listCommand) {
			try {
				parent.getShell().setText(Messages.getString("eRCP_Workbench")); //$NON-NLS-1$
				eWorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()
				.getActivePage().showView(ID_VIEW);
				enableLaunchCommand(true);
				enableListCommand(false);
				enablePreferencesCommand(false);
			} catch (PartInitException e1) {
				e1.printStackTrace();
			}
		}
		else if (e.widget == exitCommand) {
			eWorkbenchPlugin.getDefault().getWorkbench().close();
			eWorkbenchPlugin.getDefault().getWorkbench().getDisplay().dispose();
		}
		else if (e.widget == preferenceCommand) {
			
			PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null,
					currentPrefPage, null, null);
			dialog.open();
		}
	}

	public void widgetDefaultSelected(SelectionEvent arg0) {
	}

	private boolean hasPrefs(ApplicationDescriptor desc) {
    	List nodes = ((WorkbenchPreferenceManager)PlatformUI.
    			getWorkbench().getPreferenceManager()).getElements(PreferenceManager.PRE_ORDER);	
		if (nodes!=null && nodes.size() > 0){
			Iterator i = nodes.iterator();
			while (i.hasNext()) {
				WorkbenchPreferenceNode node = (WorkbenchPreferenceNode) i.next();
				if (node.getPluginId().equals(desc.getPluginId())) {
					currentPrefPage = node.getId();
					return true;
				}	
			}
		}

		return false;
	}
	
}