/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.eworkbench;


/**
 * The workbench's global registry of applications. 
 * <p>
 * This registry contains a descriptor for each application in the workbench.
 * </p><p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * @see IWorkbench#getApplicationRegistry
 */
public interface IApplicationRegistry {
 
    /**
     * Finds and returns the registered application with the given app id.
     *
     */
    public IApplicationDescriptor findApplicationWithId(String appId);

    /**
     * Finds and returns the registered application with the given app id.
     *
     */
    public IApplicationDescriptor findApplicationWithLabel(String label);

    /**
     * Returns a list of the applications known to the workbench.
     *
     * @return a list of applications
     */
    public IApplicationDescriptor[] getApplications();

}
