/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.eworkbench;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * This internal class represents the main app.
 *
 */
public class eWorkbenchPlugin extends AbstractUIPlugin {
	
	// eWorkbench Extension Point Names
    public static final String PL_APPLICATIONS = "applications"; //$NON-NLS-1$

    // Default instance of the receiver
    private static eWorkbenchPlugin inst;

    // Global workbench ui plugin flag. Only workbench implementation is allowed to use this flag
    // All other plugins, examples, or test cases must *not* use this flag.
    public static boolean DEBUG = false;

    /**
     * The workbench plugin ID.
     */
    public static final String PLUGIN_ID = "org.eclipse.ercp.eworkbench"; //$NON-NLS-1$

	private ApplicationRegistry appsRegistry;
	
	/**
	 * Create an instance of the receiver.
	 */
	public eWorkbenchPlugin() {
		super();
		inst = this;
	}
	
	/**
     * Return the application registry.
     * @return IApplicationRegistry. The registry for the receiver.
     */
    public synchronized IApplicationRegistry getApplicationRegistry() {
        if (appsRegistry == null) {
            appsRegistry = new ApplicationRegistry();
            appsRegistry.load();
        }
        return appsRegistry;
    }
	
    /**
     * Creates an extension.  If the extension plugin has not
     * been loaded a busy cursor will be activated during the duration of
     * the load.
     *
     * @param element the config element defining the extension
     * @param classAttribute the name of the attribute carrying the class
     * @return Object the extension object
     * @throws CoreException
     */
    public static Object createExtension(final IConfigurationElement element,
            final String classAttribute) throws CoreException {
        // If plugin has been loaded create extension.
        // Otherwise, show busy cursor then create extension.
        return null;
    }

    /* Return the default instance of the receiver. This represents the runtime plugin.
     *
     * @see AbstractPlugin for the typical implementation pattern for plugin classes.
     */
    public static eWorkbenchPlugin getDefault() {
        return inst;
    }

    /* (non-javadoc)
     * Method declared on AbstractUIPlugin
     */
    protected void refreshPluginActions() {
        // do nothing
    }

}

