/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     James D Miles (IBM Corp.) - bug 53858, selective install for multiuser
 *                                 with managed-only policy
*******************************************************************************/
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.*;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.*;
import org.eclipse.update.core.*;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.operations.*;

/**
 * Configure a feature.
 * ConfigOperation
 */
public class InstallOperation
	extends OptionalFeatureOperation
	implements IInstallFeatureOperation {
	
	public boolean equals(Object arg) {
		if (arg == null) {
			return false;
		}
		
		if (!(arg instanceof InstallOperation)) {
			return false;
		}
		
		InstallOperation io = (InstallOperation)arg;
		
		return io.getFeature().getVersionedIdentifier().equals(this.getFeature().getVersionedIdentifier());
	}

	public int hashCode() {
		// TODO Auto-generated method stub
		return super.getFeature().hashCode();
	}

	private IVerificationListener verifier;

	/**
	 * Constructor
	 * @param site
	 * @param feature
	 * @param optionalFeatures optional features to install. If null, the operation will install them all (if any)
	 * @param unconfiguredOptionalElements optional features unconfigured before the operation. They should remain unconfigured after the install.
	 * @param verifier
	 */
	public InstallOperation(
		IConfiguredSite site,
		IFeature feature,
		IFeatureReference[] optionalFeatures,
		IFeature[] unconfiguredOptionalElements,
		IVerificationListener verifier) {
		super(site, feature);
		IFeature[] installed = UpdateUtils.getInstalledFeatures(feature);
		if (installed.length > 0)
			this.oldFeature = installed[0];
		this.unconfiguredOptionalFeatures = unconfiguredOptionalElements;
		this.optionalFeatures = optionalFeatures;
		this.verifier = verifier;
	}

	public IFeatureReference[] getOptionalFeatures() {
		return optionalFeatures;
	}

	public boolean execute(IProgressMonitor pm, IOperationListener listener)
		throws CoreException {

		boolean reinstall = false;
		if (oldFeature != null
			&& feature.getVersionedIdentifier().equals(
				oldFeature.getVersionedIdentifier()))
			reinstall = true;

		setOptionalFeatures();

		if (optionalFeatures == null)
			targetSite.install(feature, verifier, pm);
		else
			targetSite.install(feature, optionalFeatures, verifier, pm);

		if (!reinstall && !isManagedOnly()) {

			if (oldFeature != null) { //&& isOptionalDelta()) {
				preserveOptionalState();

				boolean oldSuccess = unconfigure(oldFeature, null); // pick any site containing old feature
				if (!oldSuccess) {
					IInstallConfiguration config = SiteManager.getLocalSite().getCurrentConfiguration();
					if (!UpdateUtils.isNestedChild(config, oldFeature)) {
						// "eat" the error if nested child
						String message =
							NLS.bind(Messages.OperationsManager_error_old, (new String[] { oldFeature.getLabel() }));
						IStatus status =
							new Status(
								IStatus.ERROR,
								UpdateUtils.getPluginId(),
								IStatus.OK,
								message,
								null);
						throw new CoreException(status);
					}
				}
			}

//			if (oldFeature == null) {
//				ensureUnique();
//			}
		}
		return true;
	}

}
