/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     James D Miles (IBM Corp.) - bug 53858, selective install for multiuser
 *                                 with managed-only policy
 *******************************************************************************/
package org.eclipse.update.internal.operations;

import java.util.HashSet;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configurator.IPlatformConfiguration.ISitePolicy;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.InstallConfiguration;

public abstract class OptionalFeatureOperation extends FeatureOperation {

	IFeatureReference[] optionalFeatures;
	IFeature[] unconfiguredOptionalFeatures;

	public OptionalFeatureOperation(IConfiguredSite targetSite, IFeature feature) {
		super(targetSite, feature);
	}

	void preserveOptionalState() {
		if (unconfiguredOptionalFeatures == null)
			return;

		for (int i = 0; i < unconfiguredOptionalFeatures.length; i++) {
			try {
				// Get the feature that matches the original unconfigured ones.
				IFeature localFeature =
					UpdateUtils.getLocalFeature(
						targetSite,
						unconfiguredOptionalFeatures[i]);
				if (localFeature != null)
					targetSite.unconfigure(localFeature);

			} catch (CoreException e) {
				// Ignore this - we will leave with it
			}
		}
	}
	
	void setOptionalFeatures() {
		try {
			// Ensure optional features are correctly set
			if (optionalFeatures == null && UpdateUtils.hasOptionalFeatures(feature) ) {
				JobRoot jobRoot = new JobRoot(this);
				IInstallConfiguration config = SiteManager.getLocalSite().getCurrentConfiguration();
				HashSet set = new HashSet();
				boolean update = oldFeature != null;
				boolean patch = UpdateUtils.isPatch(feature);
				FeatureHierarchyElement[] elements = jobRoot.getElements();
				for (int i = 0; i < elements.length; i++) {
					elements[i].addCheckedOptionalFeatures(update, patch, config, set);
				}
				optionalFeatures = new IFeatureReference[set.size()];
				set.toArray(optionalFeatures);
				unconfiguredOptionalFeatures = jobRoot.getUnconfiguredOptionalFeatures(config, targetSite);
			}
		} catch (CoreException e) {
			UpdateUtils.logException(e);
		}
	}

	boolean isManagedOnly(){
		int policy = InstallConfiguration.getDefaultPolicy();
		if(policy == ISitePolicy.MANAGED_ONLY){
			return true;
		}
		return false;
	}

}
