/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update;

import org.eclipse.ui.plugin.*;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;

import java.util.MissingResourceException;
import java.util.ResourceBundle;


/**
 * The main plugin class to be used in the desktop.
 */
public class AppPlugin extends AbstractUIPlugin {

//	public static int DEFAULT_HISTORY = 100;//Integer.MAX_VALUE;
	
	//The shared instance.
	public static AppPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public AppPlugin() {
		super();
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
		resourceBundle = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static AppPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ercp.update", path);
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = AppPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		try {
			if (resourceBundle == null)
				resourceBundle = ResourceBundle.getBundle("org.eclipse.ercp.update.AppPluginResources"); //$NON-NLS-1$
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
		return resourceBundle;
	}

//	/**
//	 * Logs a status
//	 */
//	public static void log(IStatus status){
//		AppPlugin.getPlugin().getLog().log(status);		
//	}
//	
//	/**
//	 * Logs an error
//	 */
//	public static void log(Throwable t){		
//		log("", t); //$NON-NLS-1$
//	}
//
//	/**
//	 * Logs a string and an  error
//	 */
//	public static void log(String msg, Throwable e){
//		IStatus status = null;
//		if (e instanceof CoreException) 
//			status = ((CoreException)e).getStatus();
//		else 
//			status = Utilities.newCoreException(msg,e).getStatus();		
//		if (status!=null)
//			log(status);
//	}		
//	/*
//	 * Method log.
//	 * @param newConfiguration
//	 */
//	public static void log(IInstallConfiguration newConfiguration) {
//		if (log!=null)
//			log.log(newConfiguration);
//	}
//
//	/**
//	 * dumps a String in the trace
//	 */
//	public static void debug(String s) {
//		StringBuffer msg = new StringBuffer();
//		msg.append(getPlugin().toString());
//		msg.append("^"); //$NON-NLS-1$
//		msg.append(Integer.toHexString(Thread.currentThread().hashCode()));
//		msg.append(" "); //$NON-NLS-1$
//		msg.append(s);
//		System.out.println(msg.toString());
//	}
//	
//	/**
//	 * Dumps a String in the log if WARNING is set to true
//	 */
//	public static void warn(String s) {
//		if (DEBUG && DEBUG_SHOW_WARNINGS) {
//			if (s!=null){
//				s="WARNING: "+s; //$NON-NLS-1$
//			}
//			log(s, null); 
//		}
//	}
//
//	/**
//	 * Dumps an exception in the log if WARNING is set to true
//	 * 
//	 * @param s log string
//	 * @param e exception to be logged
//	 * @since 2.0
//	 */
//	public static void warn(String s, Throwable e) {
//		if (DEBUG && DEBUG_SHOW_WARNINGS){
//			if (s!=null){
//				s="UPDATE MANAGER INFO: "+s; //$NON-NLS-1$
//			}
//			log(s,e);
//		}
//	}

}
