/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class UIImage {

	public static final ImageDescriptor ICON_SITE		= create("icons/site_obj.gif"); //$NON-NLS-1$
	public static final ImageDescriptor ICON_CATEGORY	= create("icons/category_obj.gif"); //$NON-NLS-1$
	public static final ImageDescriptor ICON_FEATURE	= create("icons/feature_obj.gif"); //$NON-NLS-1$
	public static final ImageDescriptor ICON_EWORKBENCH	= create("icons/sample.gif"); //$NON-NLS-1$
	public static final ImageDescriptor ICON_INCOMPATIBLE_FEATURE	= create("icons/incompatible_feature_obj.gif"); //$NON-NLS-1$
	public static final ImageDescriptor ICON_BROKEN_FEATURE			= create("icons/broken_feature_obj.gif"); //$NON-NLS-1$


	private static ImageDescriptor create(String imageName) {
		return ImageDescriptor.createFromURL(
				FileLocator.find(AppPlugin.getDefault().getBundle(), new Path(imageName), null));
	}


	public static Image createImage(ImageDescriptor imageDescriptor) {
		ImageData imageData = null;
		if (Display.getCurrent().getDPI().equals(new Point(192,192)))		// Default is Point(96, 96)
			imageData = imageDescriptor.getImageData().scaledTo(32, 32);	// Default is 16, DPI 192 device needs double.
		else
			imageData = imageDescriptor.getImageData();

		return new Image(Display.getCurrent(), imageData);
	}
}
