/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import org.eclipse.ercp.update.UIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;


public class AddBookmarkScreen extends AbsScreen {

	Button remoteButton, localButton;
	
	public AddBookmarkScreen(NormalView view) {
		super(view);
	}
	
	protected void createScreen() {
		if (NormalView.OS_ARM_SYMBIAN == view.osType)
			init(UIMessages.InstallLocalOrRemote2);
		else
			init(UIMessages.InstallLocalOrRemote);
	
		Composite choicePane = new Composite(screen, SWT.NONE);
		choicePane.setLayoutData(new GridData(GridData.FILL_BOTH));
		choicePane.setLayout(new GridLayout(2, false));
		
		remoteButton = new Button(choicePane, SWT.RADIO);
		remoteButton.setText(UIMessages.Remote);
		remoteButton.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
//		Text remoteLabel = new Text(choicePane, SWT.READ_ONLY | SWT.MULTI | SWT.WRAP);
		WrappedLabel remoteLabel = new WrappedLabel(choicePane, SWT.NONE, SWT.NONE);
		GridData rData = new GridData(GridData.FILL_BOTH);
		rData.verticalIndent = 2;
		remoteLabel.setLayoutData(rData);
		remoteLabel.setText(UIMessages.RemoteHelp);
		
		localButton = new Button(choicePane, SWT.RADIO);
		localButton.setText(UIMessages.Local);
		localButton.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
//		Text localLabel = new Text(choicePane, SWT.READ_ONLY | SWT.MULTI | SWT.WRAP);
		WrappedLabel localLabel = new WrappedLabel(choicePane, SWT.NONE, SWT.NONE);
		GridData lData = new GridData(GridData.FILL_BOTH);
		lData.verticalIndent = 2;
		localLabel.setLayoutData(lData);
		localLabel.setText(UIMessages.LocalHelp);
		
		choicePane.layout();
		
		separator();
		setButtons(BACK, NONE, NEXT);

		if (NormalView.OS_ARM_SYMBIAN == view.osType) {
			remoteButton.setFont(view.fontOnS60);
			remoteLabel.label.setFont(view.fontOnS60);
			localButton.setFont(view.fontOnS60);
			localLabel.label.setFont(view.fontOnS60);
		}
		screen.layout();
	}

	protected void refresh() {
		backButton.setEnabled(true);
		nextButton.setEnabled(true);
		remoteButton.setSelection(false);
		localButton.setSelection(true); // set local as default
	}

	protected void action() {
		setDefaultFocus();
		screen.pack();
	}

	protected void setDefaultFocus() {
		if (view.inputType == NormalView.INPUT_SHOW_SOFTKEY_MODE)
			localButton.setFocus();
		else
			nextButton.setFocus();
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == backButton.widget) {
			setVisible(false);
			view.showScreen(view.BOOKMARKS_SCREEN, view.NO_REFRESH);
		}
		else if (e.widget == nextButton.widget) {
			if (remoteButton.getSelection()) {
				setVisible(false);
				view.showScreen(view.ADD_REMOTE_SCREEN, view.REFRESH_IT);
			} else {
				FileDialog fd = new FileDialog(view.parent.getShell(), SWT.NONE);
				if (NormalView.OS_ARM_SYMBIAN == view.osType)
					fd.setText(UIMessages.SelectSite2);
				else
					fd.setText(UIMessages.SelectSite);
				String[] extensions = new String[1];
				if (NormalView.WM_SMARTPHONE == view.wmType) {
					// FileDialog on SmartPhone doesn't support the specific-name filter. It needs as least one '*'.
					extensions[0] = "*.xml"; //$NON-NLS-1$
				}
				else {
					extensions[0] = "site.xml"; //$NON-NLS-1$
				}
				fd.setFilterExtensions(extensions);
				String[] names = new String[1];
				names[0] = UIMessages.SiteXMLfiles;
				fd.setFilterNames(names);
				if (fd.open() == null) {
					return;
				}

				String site = null;
				if (NormalView.OS_ARM_SYMBIAN == view.osType) {
					site = fd.getFilterPath() + "/" + fd.getFileName();
				}
				else {
					site = fd.getFilterPath() + fd.getFileName();
				}
				if (site != null)
					view.currentName = site.replace('\\', '/');

				setVisible(false);
				view.showScreen(view.ADD_LOCAL_SCREEN, view.REFRESH_IT);
			}
		}
	}
}
