/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import java.util.Vector;

import org.eclipse.ercp.update.UIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;


public class AddRemoteScreen extends AbsScreen implements ModifyListener {

	Button remoteButton, localButton;
	Text name, url;
	Vector bookmarks = new Vector();
	Composite screenPane;
	ScrollBar scrollBarV;
	Rectangle screenPaneBounds;
	
	public AddRemoteScreen(NormalView view) {
		super(view);
	}
	
	protected void createScreen() {
		screenPane = init(UIMessages.YouSelectedRemote, true);
		scrollBarV = screen.getVerticalBar();
		scrollBarV.addSelectionListener(this);

		WrappedLabel nameLabel = new WrappedLabel(screenPane, SWT.NONE, SWT.NONE);
		if (NormalView.OS_ARM_SYMBIAN == view.osType)
			nameLabel.setText(UIMessages.EnterName2);
		else
			nameLabel.setText(UIMessages.EnterName);
		name = new Text(screenPane, SWT.BORDER);
		name.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		name.addModifyListener(this);

		WrappedLabel addrLabel = new WrappedLabel(screenPane, SWT.NONE, SWT.NONE);
		if (NormalView.OS_ARM_SYMBIAN == view.osType)
			addrLabel.setText(UIMessages.EnterURL2);
		else
			addrLabel.setText(UIMessages.EnterURL);
		url = new Text(screenPane, SWT.BORDER);
		url.setSelection(7, 7);
		url.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		fillSpace();
		separator();
		setButtons(BACK, NONE, FINISHED);

		if (NormalView.OS_ARM_SYMBIAN == view.osType) {
			nameLabel.label.setFont(view.fontOnS60);
			name.setFont(view.fontOnS60);
			addrLabel.label.setFont(view.fontOnS60);
			url.setFont(view.fontOnS60);
		}
		screen.pack();
		screen.layout();
	}
	
	protected void refresh() {
		backButton.setEnabled(true);
		nextButton.setEnabled(false);
		BookmarkUtil.load(view.bookmarkFile, bookmarks);
		name.setText(""); //$NON-NLS-1$
		url.setText("http://"); //$NON-NLS-1$
	}

	protected void action() {
		setDefaultFocus();
		screen.pack();
	}

	protected void setDefaultFocus() {
		name.setFocus();
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == backButton.widget) {
			setVisible(false);
			view.showScreen(view.ADD_BOOKMARK_SCREEN, view.NO_REFRESH);
		}
		else if (e.widget == nextButton.widget) {
			BookmarkSite newBookmark = new BookmarkSite(name.getText(), url.getText(), false, true, false, ""); //$NON-NLS-1$
			bookmarks.add(newBookmark);
			BookmarkUtil.store(view.bookmarkFile, bookmarks);

			setVisible(false);
			view.showScreen(view.BOOKMARKS_SCREEN, view.REFRESH_IT);
		}
		else if (e.widget == scrollBarV) {
			screenPane.setBounds(screenPaneBounds.x,
					screenPaneBounds.y - scrollBarV.getSelection(),
					screenPaneBounds.width,
					screenPaneBounds.height + scrollBarV.getSelection());
		}
	}
	
	public void modifyText(ModifyEvent e) {
		if ((name.getText().length() == 0)
				|| (BookmarkUtil.searchByName(bookmarks, name.getText()) >= 0)) {
			//empty name or the same name has existed.
			nextButton.setEnabled(false);
		}
		else
			nextButton.setEnabled(true);
	}

	public void controlResized(ControlEvent e) {
		if (!screen.isDisposed())
			screen.setBounds(view.parent.getClientArea());

		if (buttonPane == null)
			return;

		screenPaneBounds = screenPane.getBounds();
		int screenFloor = screenPane.getSize().y;
		int buttonFloor = buttonPane.getLocation().y + buttonPane.getSize().y;
		if (buttonFloor > screenFloor) {
			scrollBarV.setMaximum(buttonFloor - screenFloor);
			scrollBarV.setSelection(0);
			if (!scrollBarV.getVisible()) {
				scrollBarV.setVisible(true);
			}
		}
		else {
			if (scrollBarV.getVisible())
				scrollBarV.setVisible(false);
		}
	}
}
