/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class CommandButton {
	public Widget widget = null;
	public Command theCommand = null;
	public Button theButton = null;
	private int inputMode = NormalView.INPUT_SKIP_SOFTKEY_MODE;
	
	public CommandButton(Composite parent, int attribute) {
		this.inputMode = NormalView.INPUT_SKIP_SOFTKEY_MODE;

		if (this.inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			theButton = new Button(parent, attribute);
			widget = theButton;
		}
	}

	public CommandButton(Composite parent, int attribute, int priority) {
		this.inputMode = NormalView.INPUT_SHOW_SOFTKEY_MODE;

		if (this.inputMode == NormalView.INPUT_SHOW_SOFTKEY_MODE) {
			theCommand = new Command(parent, attribute, priority);
			widget = theCommand;
		}
	}

	public void setText(String text) {

		if (inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			theButton.setText(text);
		}
		else {
			theCommand.setText(text);
		}
	}

	public void setFont(Font font) {

		if (inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			theButton.setFont(font);
		}
	}

	public void addSelectionListener(SelectionListener listener) {
		if (inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			theButton.addSelectionListener(listener);
		}
		else {
			theCommand.addSelectionListener(listener);
		}
	}

	public Point getLocation() {
		if (inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			return theButton.getLocation();
		}
		return new Point(0, 0);
	}

	public void setLayoutData(FormData layoutData) {
		if (inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			theButton.setLayoutData(layoutData);	
		}
	}

	public void setEnabled(boolean enabled) {
		if (inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			theButton.setEnabled(enabled);
		}
		else {
			theCommand.setEnabled(enabled);
		}
	}

	public boolean getEnabled() {
		if (inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			return theButton.getEnabled();
		}
		return theCommand.getEnabled();
	}

	public void setFocus() {
		if (inputMode == NormalView.INPUT_SKIP_SOFTKEY_MODE) {
			theButton.setFocus();
		}
	}
}
