/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import java.util.Vector;

import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;


public class EditBookmarkScreen extends AbsScreen implements ModifyListener {

	Text name, url;
	Button changeUrlButton;
	Vector bookmarks = new Vector();
	BookmarkSite selectedBookmark = null;
	
	public EditBookmarkScreen(NormalView view) {
		super(view);
	}
	
	protected void createScreen() {
		init(UIMessages.EditBookmark);

		CaptionedControl namecc = new CaptionedControl(screen, SWT.NONE);
		name = new Text(namecc, SWT.BORDER);
		name.addModifyListener(this);

		namecc.setText(UIMessages.BookmarkName);
		namecc.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		CaptionedControl urlcc = new CaptionedControl(screen, SWT.NONE);
		url = new Text(urlcc, SWT.BORDER);
		urlcc.setText(UIMessages.BookmarkURL);
		urlcc.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		changeUrlButton = new Button(screen, SWT.PUSH);
		changeUrlButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		changeUrlButton.setText(UIMessages.ChangeURL);
		changeUrlButton.addSelectionListener(this);

		fillSpace();
		separator();
		setButtons(BACK, NONE, FINISHED);

		if (NormalView.OS_ARM_SYMBIAN == view.osType) {
			namecc.setFont(view.fontOnS60);
			name.setFont(view.fontOnS60);
			urlcc.setFont(view.fontOnS60);
			url.setFont(view.fontOnS60);
			changeUrlButton.setFont(view.fontOnS60);
		}
		screen.layout();
	}

	protected void refresh() {
		backButton.setEnabled(true);
		nextButton.setEnabled(true);
		if ((view.currentName != null) && (view.bookmarkFile != null)) {
			BookmarkUtil.load(view.bookmarkFile, bookmarks);
			for (int i=0; i<bookmarks.size(); i++ ) {
				selectedBookmark = (BookmarkSite) bookmarks.elementAt(i);
				if (view.currentName.equals(selectedBookmark.getName())) {
					//This is the one we selected.
					name.setText(selectedBookmark.getName());
					url.setText(selectedBookmark.getURL().toString());
					// Local site data is read-only
					url.setEditable(!selectedBookmark.getLocal());
					changeUrlButton.setVisible(selectedBookmark.getLocal());
					break;
				}
			}
		}
	}

	protected void action() {
		setDefaultFocus();
		screen.pack();
	}

	protected void setDefaultFocus() {
		name.setSelection(name.getCharCount());
		name.setFocus();
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == backButton.widget) {
			setVisible(false);
			view.showScreen(view.BOOKMARKS_SCREEN, view.NO_REFRESH);
		}
		else if (e.widget == nextButton.widget) {
			selectedBookmark.setName(name.getText());
			selectedBookmark.setURL(url.getText());
			BookmarkUtil.store(view.bookmarkFile, bookmarks);
			setVisible(false);
			view.showScreen(view.BOOKMARKS_SCREEN, view.REFRESH_IT);
		}
		else if (e.widget == changeUrlButton) {
			FileDialog fd = new FileDialog(view.parent.getShell(), SWT.NONE);
			if (NormalView.OS_ARM_SYMBIAN == view.osType)
				fd.setText(UIMessages.SelectSite2);
			else
				fd.setText(UIMessages.SelectSite);
			String[] extensions = new String[1];
			if (NormalView.WM_SMARTPHONE == view.wmType) {
				// FileDialog on SmartPhone doesn't support the specific-name filter. It needs as least one '*'.
				extensions[0] = "*.xml"; //$NON-NLS-1$
			}
			else {
				extensions[0] = "site.xml"; //$NON-NLS-1$
			}
			fd.setFilterExtensions(extensions);
			String[] names = new String[1];
			names[0] = UIMessages.SiteXMLfiles;
			fd.setFilterNames(names);
			if (fd.open() != null) {
//				String site = fd.getFilterPath() + fd.getFileName();
//				if (Platform.OS_WIN32.equals(Platform.getOS())
//						&& Platform.ARCH_X86.equals(Platform.getOSArch())) {
//					// here is on windows desktop.
//					// it should be the format of "file:///D:\site-folder\site.xml".
//					url.setText("file:///" + site); //$NON-NLS-1$
//				}
//				else {
//					url.setText("file://" + site); //$NON-NLS-1$
//				}

				if (NormalView.OS_ARM_WIN32 == view.osType) {
					// here is windows device.
					url.setText("file://" + fd.getFilterPath() + fd.getFileName()); //$NON-NLS-1$
				}
				else if (NormalView.OS_X86_WIN32 == view.osType) {
					// here is windows desktop.
					// it should be the format of "file:///D:\site-folder\site.xml".
					url.setText("file:///" + fd.getFilterPath() + fd.getFileName()); //$NON-NLS-1$
				}
				else if (NormalView.OS_ARM_SYMBIAN == view.osType) {
					// here is symbian.
					// it should be the format of "file:/c:/site-folder/site.xml".
					url.setText("file:/" + fd.getFilterPath() //$NON-NLS-1$
								  + "/" + fd.getFileName()); //$NON-NLS-1$
				}
			}
		}
	}

	public void modifyText(ModifyEvent e) {
		if (!name.getText().equals(view.currentName)) {
			// if the name has been changed to different one.
			if ((name.getText().length() == 0)
					|| (BookmarkUtil.searchByName(bookmarks, name.getText()) >= 0)) {
				//empty name or the same name has existed.
				nextButton.setEnabled(false);
				return;
			}
		}

		nextButton.setEnabled(true);
	}
}
