/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.util.FeatureWrap;


public class LicenseScreen extends AbsScreen {

	SortedList featureList;
	Text licenseArea;
	Button acceptButton, noAcceptButton;
	Label acceptText, noAcceptText;

	Composite pane, namePane;
	FormData fdFeatures, fdLicense;
	FormData fdAcceptButton;
	FormData fdNoAcceptButton;
	
	public LicenseScreen(NormalView view) {
		super(view);
	}

	protected void createScreen() {
		init(null);

		pane = new Composite(screen, SWT.NONE);
		pane.setLayout(new FormLayout());
		pane.setLayoutData(new GridData(GridData.FILL_BOTH));

		// feature list
		featureList = new SortedList(pane, SWT.V_SCROLL | SWT.BORDER);
		featureList.addSelectionListener(this);

		// license area
		licenseArea = new Text(pane, SWT.MULTI | SWT.WRAP | SWT.V_SCROLL | SWT.BORDER);
		licenseArea.setEditable(false);

		// accept button - radio portion
		acceptButton = new Button(pane, SWT.RADIO | SWT.WRAP);
		acceptButton.setText(UIMessages.Accept);
		acceptButton.addSelectionListener(this);

		// no-accept button - radio portion
		noAcceptButton = new Button(pane, SWT.RADIO | SWT.WRAP);
		noAcceptButton.setText(UIMessages.NoAccept);
		noAcceptButton.addSelectionListener(this);

		// process buttons
		setButtons(NONE, NONE, NONE);

		fdFeatures = new FormData();
		fdLicense = new FormData();
		fdAcceptButton = new FormData();
		fdNoAcceptButton = new FormData();

		if (NormalView.OS_ARM_SYMBIAN == view.osType) {
			featureList.setFont(view.fontOnS60);
			licenseArea.setFont(view.fontOnS60);
			acceptButton.setFont(view.fontOnS60);
			noAcceptButton.setFont(view.fontOnS60);
		}
	}

	protected void refresh() {
		acceptButton.setSelection(false);
		noAcceptButton.setSelection(false);
//		backButton.setEnabled(true);
//		cancelButton.setEnabled(true);
//		nextButton.setEnabled(false);
		featureList.removeAll();
		licenseArea.setText(""); //$NON-NLS-1$

		FeatureWrap fw = null;
		for (int i=0; i< view.availableFeatures.size(); i++) {
			fw = (FeatureWrap) view.availableFeatures.elementAt(i);
			if (fw.isSelected()) {
				featureList.add(fw.getShowedName());
				if (licenseArea.getText().length() < 1) {
					// Use the first non-empty license as default showed one.
					featureList.select(fw.getShowedName());
					licenseArea.setText(fw.getLicense());
				}
			}
		}

//		MobileDevice md = MobileDevice.getMobileDevice();
//		Screen[] screens = md.getScreens();
		int rateTop		= 20;
		int rateMed		= 40;
		int rateFoot	= 100 - rateTop - rateMed;
		if (view.parent.getClientArea().width > view.parent.getClientArea().height) {
//		if (screens[0].getOrientation() == Screen.LANDSCAPE) {
			//featureList : left, licenseArea : right, accept/no-accept : foot
			fdFeatures.top = new FormAttachment(0, 0);
			fdFeatures.bottom = new FormAttachment(rateTop+rateMed, -5); //-5 is featureList's reserved margin to accept/noAccept.
			fdFeatures.left = new FormAttachment(0, 0);
			fdFeatures.right = new FormAttachment(100/2, -2); //-2 is featureList's reserved margin to licenseArea.

			fdLicense.top = new FormAttachment(0, 0);
			fdLicense.bottom = new FormAttachment(rateTop+rateMed, -5); //-5 is licenseArea's reserved margin to accept/noAccept.
			fdLicense.left = new FormAttachment(100/2, 2); //2 is licenseArea's reserved margin to featureList.
			fdLicense.right = new FormAttachment(100, 0);
		} else {
			//featureList : top, licenseArea : median, accept/no-accept : foot
			fdFeatures.top = new FormAttachment(0, 0);
			fdFeatures.bottom = new FormAttachment(rateTop, 0);
			fdFeatures.left = new FormAttachment(0, 0);
			fdFeatures.right = new FormAttachment(100, 0);

			fdLicense.top = new FormAttachment(rateTop, 5); //5 is licenseArea's reserved margin to featureList.
			fdLicense.bottom = new FormAttachment(rateTop+rateMed, -5); //-5 is licenseArea's reserved margin to accept/noAccept.
			fdLicense.left = new FormAttachment(0, 0);
			fdLicense.right = new FormAttachment(100, 0);
		}
		fdAcceptButton.top = new FormAttachment(100-rateFoot, 0);
		fdAcceptButton.bottom = new FormAttachment(100-rateFoot/2, 0);
		fdAcceptButton.left = new FormAttachment(0, 0);
		fdAcceptButton.right = new FormAttachment(100, 0);

		fdNoAcceptButton.top = new FormAttachment(100-rateFoot/2, 0);
		fdNoAcceptButton.bottom = new FormAttachment(100, 0);
		fdNoAcceptButton.left = new FormAttachment(0, 0);
		fdNoAcceptButton.right = new FormAttachment(100, 0);

		featureList.setLayoutData(fdFeatures);
		licenseArea.setLayoutData(fdLicense);
		acceptButton.setLayoutData(fdAcceptButton);
		noAcceptButton.setLayoutData(fdNoAcceptButton);
		screen.layout();
	}

	protected void action() {
		setDefaultFocus();
	}

	protected void setDefaultFocus() {
		acceptButton.setFocus();
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == featureList) {
			String[] selectedStrings = featureList.getSelection();
			if (selectedStrings.length > 0) {
				for (int i=0; i< view.availableFeatures.size(); i++) {
					FeatureWrap fw = (FeatureWrap) view.availableFeatures.elementAt(i);
					if ( fw.isSelected() && (selectedStrings[0].equals(fw.getShowedName()))) {
						licenseArea.setText(fw.getLicense());
					}
				}
			}
		}

		if (e.widget == acceptButton) {
//			nextButton.setEnabled(true);
			if (acceptButton.getSelection()) {
				setVisible(false);
				view.showScreen(view.INSTALLING_SCREEN, view.REFRESH_IT);
			}	
		}
		else if (e.widget == noAcceptButton) {
//			nextButton.setEnabled(false);
			if (noAcceptButton.getSelection()) {
				setVisible(false);
				view.showScreen(view.ROOT_SCREEN, view.NO_REFRESH);
			}
		}
//		else if (e.widget == backButton) {
//			setVisible(false);
//			view.showScreen(view.SELECT_FEATURES_SCREEN, view.NO_REFRESH);
//		}
//		else if (e.widget == cancelButton) {
//			setVisible(false);
//			view.showScreen(view.ROOT_SCREEN, view.NO_REFRESH);
//		}
//		else if (e.widget == nextButton) {
//			setVisible(false);
//			view.showScreen(view.INSTALLING_SCREEN, view.REFRESH_IT);
//		}
	}

//	public void widgetDefaultSelected(SelectionEvent e) {
//		// forward the event for device environment.
//		if (e.widget == featureList) {
//			widgetSelected(e);
//		}
//	}
}
