/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import java.lang.reflect.Method;
import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.swt.mobile.MobileDevice;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;


public class NormalView extends ViewPart {
	
	public Composite parent;
	private AbsScreen updateScreens[];

	protected final int ROOT_SCREEN				=  0;
	protected final int BOOKMARKS_SCREEN		=  1;
	protected final int SELECT_FEATURES_SCREEN	=  2;
	protected final int LICENSE_SCREEN			=  3;
	protected final int INSTALLING_SCREEN		=  4;
	protected final int ADD_BOOKMARK_SCREEN		=  5;
	protected final int ADD_REMOTE_SCREEN		=  6;
	protected final int ADD_LOCAL_SCREEN		=  7;
	protected final int EDIT_BOOKMARK_SCREEN	=  8;
	protected final int UPDATING_SCREEN			=  9;
	protected final int MANAGE_SCREEN			= 10;
	protected final int PROPERTIES_SCREEN		= 11;
	protected final int UNINSTALL_SCREEN		= 12;

	public final static int OS_UNKNOWN				= 0;
	public final static int OS_X86_WIN32			= 1;
	public final static int OS_ARM_WIN32			= 2;
	public final static int OS_ARM_SYMBIAN			= 3;

	public final static int RUNTIME_ERCP			= 0+8;
	public final static int RUNTIME_TITAN			= 1+8;

	public final static int WM_PROFESSIONAL			= 0+64;
	public final static int WM_SMARTPHONE			= 1+64;

	public final static int DEVICE_IS_TOUCH_SCREEN	= 0+512;
	public final static int DEVICE_NO_TOUCH_SCREEN	= 1+512;

	public final static int INPUT_SKIP_SOFTKEY_MODE	= 0+4096;
	public final static int INPUT_SHOW_SOFTKEY_MODE	= 1+4096;

	protected final boolean REFRESH_IT = true;
	protected final boolean NO_REFRESH = false;

	protected String bookmarkFile = null;
	protected String currentName = null;
	protected Vector viewedTree = new Vector();
	protected Vector availableFeatures = new Vector();
	protected Vector deletedFeatures = new Vector();
	protected Vector installedFeatures = new Vector();
	protected IConfiguredSite targetSite = null;
	protected boolean enableRestartCommand = false;
	protected boolean isDPI192Device = false;
	public int osType		= OS_ARM_WIN32;
	public int runtimeType	= RUNTIME_ERCP;
	public int wmType		= WM_PROFESSIONAL;
	public int deviceType	= DEVICE_IS_TOUCH_SCREEN;
	public int inputType	= INPUT_SKIP_SOFTKEY_MODE;
	public Font fontOnS60 = null;
	public Color colorOnS60 = null;
	private int currentScreen = 0;
	public String[] RuntimeName = new String[] {""}; //$NON-NLS-1$

	/**
	 * The constructor.
	 */
	public NormalView() {
		updateScreens = new AbsScreen[14];
	}

	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		this.parent = parent;
		String name = System.getProperty("org.eclipse.ercp.update.runtimeName"); //$NON-NLS-1$
		if ((name != null) && (name.length()>0)) {
			RuntimeName = new String[] {name};
		}
		determineEnvironment();
		showScreen(ROOT_SCREEN, REFRESH_IT);
	}
		
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		updateScreens[currentScreen].setDefaultFocus();
	}

	/**
	 * Set and show the assigned screen on top
	 * @param screen the ID of the assigned screen.
	 * @param refresh boolean value to refresh the cache for this screen, or not.
	 */
	public void showScreen(int screen, boolean refresh) {
		if (updateScreens[screen] == null) {
			switch (screen) {
				case ROOT_SCREEN:
					updateScreens[screen] = new RootScreen(this);
					break;
					
				case BOOKMARKS_SCREEN:
					updateScreens[screen] = new BookmarksScreen(this);
					break;

				case SELECT_FEATURES_SCREEN:
					updateScreens[screen] = new SelectFeaturesScreen(this);
					break;

				case LICENSE_SCREEN:
					updateScreens[screen] = new LicenseScreen(this);
					break;

				case INSTALLING_SCREEN:
					updateScreens[screen] = new InstallingScreen(this);
					break;

				case ADD_BOOKMARK_SCREEN:
					updateScreens[screen] = new AddBookmarkScreen(this);
					break;
				
				case ADD_REMOTE_SCREEN:
					updateScreens[screen] = new AddRemoteScreen(this);
					break;

				case ADD_LOCAL_SCREEN:
					updateScreens[screen] = new AddLocalScreen(this);
					break;

				case EDIT_BOOKMARK_SCREEN:
					updateScreens[screen] = new EditBookmarkScreen(this);
					break;

				case UPDATING_SCREEN:
					updateScreens[screen] = new UpdatingScreen(this);
					break;
					
				case MANAGE_SCREEN:
					updateScreens[screen] = new ManageScreen(this);
					break;

				case PROPERTIES_SCREEN:
					updateScreens[screen] = new PropertiesScreen(this);
					break;
				
				case UNINSTALL_SCREEN:
					updateScreens[screen] = new UninstallScreen(this);
					break;

				default:
					return;
			}		
		}
		currentScreen = screen;
		updateScreens[screen].show(refresh);
	}

	/**
	 * refresh the Vector installedFeatures
	 */
	public void refreshInstalledFeatures() {
		try {
			// re-record all installed features in all configured sites.
			IConfiguredSite[] allSites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
			IFeatureReference[] frs;
			installedFeatures.clear();
			for (int i=0; i<allSites.length; i++) {
				if (!allSites[i].isEnabled())
					continue;

				frs = allSites[i].getFeatureReferences();
				for (int j=0; j<frs.length; j++) {
					installedFeatures.add(frs[j]);
				}
			}
		}
		catch (CoreException ce) {
			ce.printStackTrace();
		}
	}

	protected void determineEnvironment() {
		// Query the runtime type and os type.
		if ("arm".equalsIgnoreCase(Platform.getOSArch())		//$NON-NLS-1$
				&&	"win32".equalsIgnoreCase(Platform.getWS())	//$NON-NLS-1$
				&&	"win32".equalsIgnoreCase(Platform.getOS())	//$NON-NLS-1$
		){
			runtimeType = RUNTIME_ERCP;
			osType = OS_ARM_WIN32;
		}
		else
		if ("x86".equalsIgnoreCase(Platform.getOSArch())		//$NON-NLS-1$
				&&	"win32".equalsIgnoreCase(Platform.getWS())	//$NON-NLS-1$
				&&	"win32".equalsIgnoreCase(Platform.getOS())	//$NON-NLS-1$
		){
			runtimeType = RUNTIME_ERCP;
			osType = OS_X86_WIN32;
		}
		else
		if ("arm".equalsIgnoreCase(Platform.getOSArch())		//$NON-NLS-1$
			&&	"s60".equalsIgnoreCase(Platform.getWS())		//$NON-NLS-1$
			&&	"s60".equalsIgnoreCase(Platform.getOS())		//$NON-NLS-1$
		){
			runtimeType = RUNTIME_ERCP;
			osType = OS_ARM_SYMBIAN;
		}
		else
		if ("windows ce".equalsIgnoreCase(Platform.getOS())		//$NON-NLS-1$
			&&	"windows ce".equalsIgnoreCase(Platform.getWS())	//$NON-NLS-1$
		){
			runtimeType = RUNTIME_TITAN;
			osType = OS_ARM_WIN32;
		}

//		// temp additional code
//		if ("S60".equalsIgnoreCase(System.getProperty("Symbian"))) { //$NON-NLS-1$ //$NON-NLS-2$
//			osType = OS_ARM_SYMBIAN;
//		}
		
		// Additional work on s60
		if (osType == OS_ARM_SYMBIAN) {
			fontOnS60 = new Font(Display.getCurrent(), "Arial", 7, SWT.None); //$NON-NLS-1$
			colorOnS60 = new Color(Display.getDefault(), 0, 0, 80);
		}

		// Because of SPR JCSY7K7B96, we need a temp workaround when running Sprint Titan on the Rafael.
		// Will remove it after the bug can be fixed on eSWT.
		if (Display.getCurrent().getDPI().equals(new Point(192,192))) {	// Default is Point(96, 96)
			isDPI192Device = true;
		}

		// Query the windows mobile type.
		// The org.eclipse.swt.internal.Platform.isSmartPhone() is not a public method, but it's the only way I know to check if it's STD.
		wmType = WM_PROFESSIONAL;
		try {
			Method mIsSmartPhone = org.eclipse.swt.internal.Platform.class.getDeclaredMethod("isSmartPhone", null); //$NON-NLS-1$
			if (mIsSmartPhone != null) {
				Boolean bIsSmartPhone = (Boolean) mIsSmartPhone.invoke(null, null);
				if (bIsSmartPhone.booleanValue()) {
					wmType = WM_SMARTPHONE;
				}
			}
		}
		catch (Exception e) {
			//e.printStackTrace();
		}

		// Query if the touch screen is supported.
		deviceType = DEVICE_IS_TOUCH_SCREEN;
		if (runtimeType == RUNTIME_TITAN) {
			// On Sprint Titan 1.0 (earlier eSWT), the method Screen.isTouchScreen() doesn't work correctly,
			// so we assume PRO always supports touch screen and STD always doesn't.
			if (wmType == WM_SMARTPHONE) {
				deviceType = DEVICE_NO_TOUCH_SCREEN;
			}
		}
		else {
			// On general runtime
			try {
				if (!MobileDevice.getMobileDevice().getScreens()[0].isTouchScreen())
					deviceType = DEVICE_NO_TOUCH_SCREEN;
				}
			catch (Exception e) {}	// in case of any exception. there should be no.
		}

		// Determine if going to use soft key mode.
		// If there is touch screen, then we don't run it on soft key mode. 
		// If there is no touch screen, then we run it on soft key mode.
		// There are 2 exceptions that soft key mode is not supported.
		// 1. WinCE.  But WinCE has touch screen, so we don't use soft key mode.
		// 2. WM with 'version < 5'. But we don't support earlier WM.
		if (deviceType == DEVICE_IS_TOUCH_SCREEN)
			inputType = INPUT_SKIP_SOFTKEY_MODE;
		else {
			inputType = INPUT_SHOW_SOFTKEY_MODE;

			// To full support earlier WM, enable the checker below.
//			try {
//				Method mIsWindowMobile = org.eclipse.swt.internal.Platform.class.getDeclaredMethod("isWindowMobile", null); //$NON-NLS-1$
//				if (mIsWindowMobile != null) {
//					Boolean bIsWindowMobile = (Boolean) mIsWindowMobile.invoke(null, null);
//					if (bIsWindowMobile.booleanValue() && org.eclipse.swt.internal.Platform.MAJOR_VERSION < 5)
//						inputType = INPUT_SKIP_SOFTKEY_MODE;
//				}
//			}
//			catch (Exception e) {e.printStackTrace();}
		}

		/*
		System.out.println("Debug code for platform setting");
		osType		= OS_ARM_SYMBIAN;
		runtimeType	= RUNTIME_ERCP;
		wmType		= WM_PROFESSIONAL;
		deviceType	= DEVICE_NO_TOUCH_SCREEN;
		inputType	= INPUT_SHOW_SOFTKEY_MODE;
		//*/
		/*
		System.out.println("Os Type      = " + osType);
		System.out.println("Runtime Type = " + runtimeType);
		System.out.println("WM Type      = " + wmType);
		System.out.println("Device Type  = " + deviceType);
		System.out.println("Input Type   = " + inputType);
		//*/
	}
}