/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.internal.scheduler.ScheduledPluginUninstall;
import org.eclipse.update.internal.scheduler.ScheduledSiteInitialize;


public class RootScreen extends AbsScreen {
	
	private Button installButton;
	private Button updateButton;
	private Button manageButton;

	private Button widestButton;
	
	public RootScreen(NormalView view) {
		super(view);
	}

	protected void createScreen() {
		init(UIMessages.SelectOption);

		// Because of SPR JCSY7K7B96, we need a temp workaround when running Sprint Titan on Rafael.
		// Remove it after the bug can be fixed on eSWT.
		if ((NormalView.RUNTIME_TITAN == view.runtimeType)
			&& view.isDPI192Device) {
			createScreen_onSprintRafael();
			return;
		}
		// End of the temp code.
		
		// TODO - Julian : change the "OS_UNKNOWN" to Symbian related term after available.
		if (Platform.OS_UNKNOWN.equals(Platform.getOS()))
			((GridLayout)screen.getLayout()).verticalSpacing = 10;
		else
			((GridLayout)screen.getLayout()).verticalSpacing = 20;
		
		installButton = new Button(screen, SWT.PUSH);
		installButton.setText(UIMessages.InstallFeatures);
		installButton.addSelectionListener(this);
//		installButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

	    updateButton = new Button(screen, SWT.PUSH);
	    updateButton.setText(UIMessages.UpdateAllFeatures); 
		updateButton.addSelectionListener(this);
//		updateButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    
	    manageButton = new Button(screen, SWT.PUSH);
	    manageButton.setText(UIMessages.ManageFeatures);
		manageButton.addSelectionListener(this);
//		manageButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		if (NormalView.OS_ARM_SYMBIAN == view.osType) {
			installButton.setForeground(view.colorOnS60);
			updateButton.setForeground(view.colorOnS60);
			manageButton.setForeground(view.colorOnS60);
		}
		screen.layout();
		environmentInitialize();

		// Find out the widest button. The screen may need to resize the button width later.
		if (installButton.getBounds().width > updateButton.getBounds().width) {
			widestButton = installButton;
		}
		else {
			widestButton = updateButton;
		}
		if (widestButton.getBounds().width < manageButton.getBounds().width)
			widestButton = manageButton;
	}

	protected void environmentInitialize() {
		
		// Here are some initialization works.

		// 1. make sure the features marked as deleted have been uninstalled.
		// This double-check is necessary for some device environments,
		// because the ui.startup thread "ScheduledPluginUninstall" on those devices is too late to be started.
		ScheduledPluginUninstall.uninstallFeatures();

		// 2. set target installation site
		// If the ui.startup thread "ScheduledSiteInitialize" is started too late,
		// then this action will also help to create the target site under "workspace\". 
		try {
			view.targetSite = ScheduledSiteInitialize.createTargetSite();
		}
		catch (Exception e) {
			e.printStackTrace();
		}

		// TODO - Julian, this action should be done by hWorkbench.
		if (ScheduledSiteInitialize.isRestartNeeded()) {
			MessageBox mb1 = new MessageBox(screen.getShell(), SWT.ICON_INFORMATION | SWT.YES | SWT.NO);
			mb1.setText(UIMessages.ConfirmRestart);
			mb1.setMessage(NLS.bind(UIMessages.RecommendToRestartForMigration, view.RuntimeName));
			if (mb1.open() == SWT.YES) {
				System.getProperties().put("eworkbench.returnCode", new Integer(PlatformUI.RETURN_RESTART)); //$NON-NLS-1$
				PlatformUI.getWorkbench().close();
				return;
			}
		}
		
		// 3. set the network time-out value as 6 second.
		if (System.getProperty("sun.net.client.defaultConnectTimeout") == null) //$NON-NLS-1$
			System.setProperty("sun.net.client.defaultConnectTimeout", "6000"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void refresh() {
		// dynamically set the button width to avoid being truncated.
		int availableWidth;
		Font newFont = null;
		FontData newFontData = null;

		availableWidth = screen.getShell().getClientArea().width - widestButton.getBounds().x - 5;
//		System.out.println("[eUpdate Debug] available screen width = " + availableWidth);					//$NON-NLS-1$
//		System.out.println("[eUpdate Debug] widest button width    = " + widestButton.getBounds().width);	//$NON-NLS-1$

		if (	(widestButton.getBounds().width > availableWidth)
			&&	(widestButton.getFont().getFontData().length > 0))
		{
			newFontData = widestButton.getFont().getFontData()[0];
			// make sure the got font is the same as the one applied on the screen.
			newFont = new Font(Display.getCurrent(), newFontData);
			installButton.setFont(newFont);
			updateButton.setFont(newFont);
			manageButton.setFont(newFont);

			newFont = null;
			while (widestButton.computeSize(SWT.DEFAULT, SWT.DEFAULT).x > availableWidth) {
				if(newFontData.getHeight() < 6) {
					//too small font is not viewable.
					break;
				}
				newFontData.setHeight(newFontData.getHeight()-1);
				newFont = new Font( Display.getCurrent(), newFontData);
				widestButton.setFont(newFont);
//				System.out.println("[eUpdate Debug] new font size        = " + newFontData.getHeight()); //$NON-NLS-1$
//				System.out.println("[eUpdate Debug] button computed size = " + widestButton.computeSize(SWT.DEFAULT, SWT.DEFAULT)); //$NON-NLS-1$
			}
			
			if (newFont != null) {
				// "not null" means font data has been changed, update it.
				installButton.setFont(newFont);
				updateButton.setFont(newFont);
				manageButton.setFont(newFont);
				screen.layout();
			}
		}

//		// refresh some data
//		try {
//			// re-record all installed features in all configured sites.
//			IConfiguredSite[] allSites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
//			IFeatureReference[] frs;
//			view.installedFeatures.clear();
//			for (int i=0; i<allSites.length; i++) {
//				if (!allSites[i].isEnabled())
//					continue;
//
//				frs = allSites[i].getFeatureReferences();
//				for (int j=0; j<frs.length; j++) {
//					view.installedFeatures.add(frs[j]);
//				}
//			}
//		}
//		catch (CoreException ce) {
//			ce.printStackTrace();
//		}
	}

	protected void action() {
		setDefaultFocus();
		screen.pack();
	}

	protected void setDefaultFocus() {
		screen.setFocus();
		installButton.setFocus();
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == installButton) {
			// refresh installed feature vector
			view.refreshInstalledFeatures();

			setVisible(false);
			view.showScreen(view.BOOKMARKS_SCREEN, view.REFRESH_IT);
		}
		else if (e.widget == updateButton) {
			// refresh installed feature vector
			view.refreshInstalledFeatures();
			// empty vector means to update everything.
			view.availableFeatures.removeAllElements();

			setVisible(false);
			view.showScreen(view.UPDATING_SCREEN, view.REFRESH_IT);
		}
		else if (e.widget == manageButton) {
			// refresh installed feature vector
			view.refreshInstalledFeatures();

			setVisible(false);
			view.showScreen(view.MANAGE_SCREEN, view.REFRESH_IT);
		}
	}
	
	// Because of SPR JCSY7K7B96, we need a temp workaround when running Sprint Titan on Rafael.
	// Remove it after the bug can be fixed on eSWT.
	private void createScreen_onSprintRafael() {
		Composite pane;
		FormData fdInstallButton, fdUpdateButton, fdManageButton;

		pane = new Composite(screen, SWT.NONE);
		pane.setLayout(new FormLayout());
		pane.setLayoutData(new GridData(GridData.FILL_BOTH));

		fdInstallButton = new FormData();
		fdInstallButton.top		= new FormAttachment( 10,  0);
		fdInstallButton.bottom	= new FormAttachment( 26,  0);
		fdInstallButton.left	= new FormAttachment(  0,  2);
		fdInstallButton.right	= new FormAttachment(100, -2);

		fdUpdateButton = new FormData();
		fdUpdateButton.top		= new FormAttachment( 30,  0);
		fdUpdateButton.bottom	= new FormAttachment( 46,  0);
		fdUpdateButton.left		= new FormAttachment(  0,  2);
		fdUpdateButton.right	= new FormAttachment(100, -2);

		fdManageButton = new FormData();
		fdManageButton.top		= new FormAttachment( 50,  0);
		fdManageButton.bottom	= new FormAttachment( 66,  0);
		fdManageButton.left		= new FormAttachment(  0,  2);
		fdManageButton.right	= new FormAttachment(100, -2);

		installButton = new Button(pane, SWT.PUSH);
		installButton.setText(UIMessages.InstallFeatures);
		installButton.addSelectionListener(this);
		installButton.setLayoutData(fdInstallButton);

	    updateButton = new Button(pane, SWT.PUSH);
	    updateButton.setText(UIMessages.UpdateAllFeatures); 
		updateButton.addSelectionListener(this);
		updateButton.setLayoutData(fdUpdateButton);
	    
	    manageButton = new Button(pane, SWT.PUSH);
	    manageButton.setText(UIMessages.ManageFeatures);
		manageButton.addSelectionListener(this);
		manageButton.setLayoutData(fdManageButton);

		screen.layout();
		
		environmentInitialize();
		widestButton = installButton;
	}
	// End of the temp code.
}