/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ScrolledText extends Composite {
	public Text text;
	private int maxTextHeight = Integer.MAX_VALUE;
	private boolean isScrollenabled = true;

	public ScrolledText(Composite parent, int compositeAttribute, int textAttribute) {
		super(parent, compositeAttribute);
		init(textAttribute, -1);
	}

	public ScrolledText(Composite parent, int compositeAttribute, int textAttribute, int maxLineCount) {
		super(parent, textAttribute);
		init(textAttribute, maxLineCount);
	}

	private void init(int textAttribute, int maxLineCount) {
		if (maxLineCount < 0)
			isScrollenabled = false;

		this.setLayout(new FormLayout());
		this.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		text = new Text(this, textAttribute | SWT.WRAP | SWT.V_SCROLL);
		text.setEditable(false);

		FormData fdName = new FormData();
		fdName.top = new FormAttachment(0, 0);
		fdName.bottom = new FormAttachment(100, 0);
		fdName.left = new FormAttachment(0, 0);
		fdName.right = new FormAttachment(100, 0);
		text.setLayoutData(fdName);

		if (maxLineCount >= 0) { // 0 means hidden Text
			text.setText(""); //$NON-NLS-1$
			maxTextHeight = text.computeSize(SWT.DEFAULT, SWT.DEFAULT).y * maxLineCount;
		}
	}

	public Rectangle computeTrim(int x, int y, int width, int height) {
		if (isScrollenabled == false) {
			return super.computeTrim(x, y, width, height);
		}

		Rectangle result = super.computeTrim(x, y, width, height);
		if (result.height > maxTextHeight) {
			return new Rectangle(result.x, result.y, result.width, maxTextHeight);
		}

		return result;
	}

	public void setEditable(boolean b) {
		text.setEditable(b);
	}

	public void setFont(Font f) {
		text.setFont(f);
	}

	public void setForeground(Color color) {
		text.setForeground(color);
	}	

	public void setSelection(int start, int end) {
		text.setSelection(start, end);
	}

	public void setText(String labelMessage) {
		text.setText(labelMessage);
	}
}
