/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;


public class UninstallScreen extends AbsScreen {

	private final static int PROGRESS_MAX_VALUE = 20;

	private Composite pane;
	private Label featureLabel;
	private Label featureName;
	private ProgressBar featureProgress;
	private IFeature uninstalledFeature;
	boolean isThreadStarted = false;
//Remove the following code when duplicated-timerExec() bug is fixed.
	private boolean isMessageBoxOpening = false;
//End.
	
	UninstallScreen(NormalView view) {
		super(view);
	}
	
	protected void createScreen() {
		init(null);
	
		pane = new Composite(screen, SWT.NONE);
		pane.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
//		if (NormalView.OS_ARM_SYMBIAN == view.osType) {
			pane.setLayout(new GridLayout(1, false));
//		}
//		else
//			pane.setLayout(new RowLayout(SWT.HORIZONTAL));
		
		featureLabel = new Label(pane, SWT.NONE);
		featureLabel.setText(UIMessages.Uninstalling);
		featureName = new Label(pane, SWT.NONE);
		featureName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		featureProgress = new ProgressBar(screen, SWT.SMOOTH);
		featureProgress.setMaximum(PROGRESS_MAX_VALUE);
		featureProgress.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		fillSpace();

		if (NormalView.OS_ARM_SYMBIAN == view.osType) {
			featureLabel.setFont(view.fontOnS60);
			featureName.setFont(view.fontOnS60);
		}
		screen.layout();
	}

	public void refresh () {
		uninstalledFeature = (IFeature) view.availableFeatures.elementAt(0);
		featureName.setText(uninstalledFeature.getLabel());
		screen.layout();// force to re-update the screen
	}

	protected void action() {
		isThreadStarted = false;

		Display.getCurrent().timerExec(500, new Runnable() {
			public void run() {
				if (isThreadStarted) {
					// Bug on eSWT ?
					// If the run() is never ended ( because it's blocked by MessageBox.open() ), 
					// then the timerExec will continue to call run() again and again.
					return;
				}

				isThreadStarted = true;
				action2();
			}
		});
		featureProgress.setSelection(PROGRESS_MAX_VALUE * 1 / 5); // to feel better on s60
	}

	protected void setDefaultFocus() {
		pane.setFocus();
	}

	protected void action2() {
		ShowFinalDialogRunnable showFinalDialogRunnable = null;
		String impactedShortcut = null;

		if (uninstalledFeature == null) {
			// should never happen.
			uninstalledFeature = (IFeature) view.availableFeatures.elementAt(0);
		}

		if (NormalView.RUNTIME_TITAN == view.runtimeType) {
			// On Sprint Titan, Application Manager needs to handle the shortcut of removed application plug-in.
			// First, go to find out the related shortcut.
			impactedShortcut = getImpactedShortcut();
			System.out.println("[eUpdate debug] Impacted application plugin is \"" + impactedShortcut + "\""); //$NON-NLS-1$  //$NON-NLS-2$
		}

		IConfiguredSite configuredSite = null;
		configuredSite = uninstalledFeature.getSite().getCurrentConfiguredSite();
		featureProgress.setSelection(PROGRESS_MAX_VALUE * 1 / 3);
//		try {
//			if (SiteManager.getLocalSite().getCurrentConfiguration()
//					.getConfiguredSites().length > 0) {
//				configuredSite = SiteManager.getLocalSite()
//											.getCurrentConfiguration()
//											.getConfiguredSites()[0];
//			}
//			featureProgress.setSelection(PROGRESS_MAX_VALUE * 1 / 3);
//		}
//		catch (CoreException ce) {
//			//TODO - Julian: error logging.
//			ce.printStackTrace();
//		}

		if ((configuredSite == null)) {
			//TODO - Julian: error logging.
			System.out.println("Error: error to get configured site for uninstallation."); //$NON-NLS-1$
			return;
		}

		boolean isUninstallSuccessful = false;
		//TODO - Julian: do more check for uninstalling.
		final UnconfigureAndUninstallFeatureOperation unconfigureAndUninstallOperation =
			(UnconfigureAndUninstallFeatureOperation) ((OperationFactory)OperationsManager.getOperationFactory()).createUnconfigureAndUninstallFeatureOperation(
					configuredSite, uninstalledFeature);

		try {
			isUninstallSuccessful = unconfigureAndUninstallOperation.execute(null, null);
			SiteManager.getLocalSite().save();
			featureProgress.setSelection(PROGRESS_MAX_VALUE);
		} catch (CoreException ce) {
			//TODO - Julian: error logging.
			ce.printStackTrace();
		} catch (InvocationTargetException ite) {
			//TODO - Julian: error logging.
			ite.printStackTrace();
		}

		view.enableRestartCommand = true;
		if (isUninstallSuccessful) {

			if (NormalView.RUNTIME_TITAN == view.runtimeType) {
				if (impactedShortcut != null) {
					// remove related shortcut
					// TODO - Julian: use better way to determine it's pro or std
					File deletedShortcut = new File("/Windows/Start Menu/Programs/Other/" + impactedShortcut + ".lnk"); //$NON-NLS-1$  //$NON-NLS-2$
					if (deletedShortcut.exists()) {
						System.out.println("[eUpdate debug] will delete shortcut [" + deletedShortcut.getAbsolutePath() + "]."); //$NON-NLS-1$  //$NON-NLS-2$
						deletedShortcut.delete();
					}
					else {
						// WM6STD has different path, try again.
						deletedShortcut = new File("/Windows/Start Menu/Other/" + impactedShortcut + ".lnk"); //$NON-NLS-1$  //$NON-NLS-2$
						System.out.println("[eUpdate debug] will delete shortcut [" + deletedShortcut.getAbsolutePath() + "]."); //$NON-NLS-1$  //$NON-NLS-2$
						if (deletedShortcut.exists()) {
							deletedShortcut.delete();
						}
					}
				}
			}
			if (uninstalledFeature.getVersionedIdentifier().getIdentifier().startsWith(ManageScreen.JVM_LIB_FEATURE_NAME)) {
				// Some of JVM library is removed, and the command and parameters to launch the JVM are also changed.
				// It's needed for the user to manually close the runtime and restart it,
				// because current auto-restart function will launch the JVM with the original command and parameters.
				showFinalDialogRunnable = new ShowFinalDialogRunnable();
				showFinalDialogRunnable.setStatus(ShowFinalDialogRunnable.FINISHED_MANUAL_RESTART);
				Display.getCurrent().timerExec(300, showFinalDialogRunnable);
/*
				MessageBox mb1 = new MessageBox(screen.getShell(), SWT.ICON_INFORMATION | SWT.YES | SWT.NO);
				mb1.setText(UIMessages.ConfirmRestart);
				mb1.setMessage(NLS.bind(UIMessages.NeedRestartManually, view.RuntimeName));
				if (mb1.open() == SWT.YES) {
					if (NormalView.RUNTIME_TITAN != view.runtimeType) {
						// Sprint Titan doesn't support restart yet.
						System.getProperties().put("eworkbench.returnCode", new Integer(PlatformUI.RETURN_OK)); //$NON-NLS-1$
						PlatformUI.getWorkbench().close();
					}
					else {
						// Sprint Titan doesn't support restart yet.
						view.deletedFeatures.add(uninstalledFeature.getVersionedIdentifier());
						setVisible(false);
						view.showScreen(view.ROOT_SCREEN, view.REFRESH_IT);
					}
				}
*/
			}
			else {
				showFinalDialogRunnable = new ShowFinalDialogRunnable();
				showFinalDialogRunnable.setStatus(ShowFinalDialogRunnable.FINISHED_AUTO_RESTART);
				Display.getCurrent().timerExec(300, showFinalDialogRunnable);
/*
				MessageBox mb2 = new MessageBox(screen.getShell(), SWT.ICON_INFORMATION | SWT.YES | SWT.NO);
				mb2.setText(UIMessages.ConfirmRestart);
				mb2.setMessage(NLS.bind(UIMessages.RecommendToRestart, view.RuntimeName));
				if (mb2.open() == SWT.YES) {
					if (NormalView.RUNTIME_TITAN != view.runtimeType) {
						// Sprint Titan doesn't support restart yet.
						System.getProperties().put("eworkbench.returnCode", new Integer(PlatformUI.RETURN_RESTART)); //$NON-NLS-1$
						PlatformUI.getWorkbench().close();
					}
					else {
						// Sprint Titan doesn't support restart yet.
						view.deletedFeatures.add(uninstalledFeature.getVersionedIdentifier());
						setVisible(false);
						view.showScreen(view.ROOT_SCREEN, view.REFRESH_IT);
					}
				}
				else {
					view.deletedFeatures.add(uninstalledFeature.getVersionedIdentifier());
					setVisible(false);
					view.showScreen(view.ROOT_SCREEN, view.REFRESH_IT);
				}
*/
			}
		}
		else {
			showFinalDialogRunnable = new ShowFinalDialogRunnable();
			showFinalDialogRunnable.setStatus(ShowFinalDialogRunnable.FAILED);
			Display.getCurrent().timerExec(300, showFinalDialogRunnable);
/*
			MessageBox mb3 = new MessageBox(screen.getShell(), SWT.ICON_ERROR | SWT.OK);
			mb3.setText(UIMessages.UninstallStatus);
			mb3.setMessage(UIMessages.UninstallNotCompleted);
			mb3.open();

			setVisible(false);
			view.showScreen(view.ROOT_SCREEN, view.REFRESH_IT);
*/
		}
	}

	private String getImpactedShortcut() {
		IPluginEntry[] beingRemovedPlugins = uninstalledFeature.getPluginEntries();

		IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.ercp.eworkbench", "applications"); //$NON-NLS-1$  //$NON-NLS-2$
		if (extensionPoint == null)
			return null;  // should never happen, because at least this is one.
		IExtension[] extensions = extensionPoint.getExtensions();
		
		for (int i = 0; i < beingRemovedPlugins.length ; i++) {
			for (int j=0; j<extensions.length; j++) {
				if (beingRemovedPlugins[i].getVersionedIdentifier().getIdentifier()
						.equalsIgnoreCase(extensions[j].getNamespaceIdentifier()))
				{
					//TODO - Julian: there may be more than one impacted shortcuts.
					return extensions[j].getConfigurationElements()[0].getAttribute("name"); //$NON-NLS-1$
				}
			}
		}

		return null;
	}

	public void widgetSelected(SelectionEvent e) {
	}


	/**
	 * 
	 */
	private class ShowFinalDialogRunnable implements Runnable {

		public final static int FINISHED_AUTO_RESTART	= 0;
		public final static int FINISHED_MANUAL_RESTART	= 1;
		public final static int FAILED					= 2;

		private int status = FINISHED_AUTO_RESTART;
		private int result = 0;
		private int buttonSet = 0;

		public void run() {
//Remove the following code when duplicated-timerExec() bug is fixed.
			if (isMessageBoxOpening)
				return;
			else
				isMessageBoxOpening = true;
//End.

			if (status == FINISHED_MANUAL_RESTART) {
				if (NormalView.RUNTIME_TITAN == view.runtimeType)
					buttonSet = SWT.OK;
				else
					buttonSet = SWT.YES | SWT.NO;
				MessageBox mb1 = new MessageBox(screen.getShell(), SWT.ICON_INFORMATION | buttonSet);
				mb1.setText(UIMessages.ConfirmRestart);
				mb1.setMessage(NLS.bind(UIMessages.NeedRestartManually, view.RuntimeName));
				result = mb1.open();
//Remove the following code when duplicated-timerExec() bug is fixed.
				isMessageBoxOpening = false;
//End.
				if (result == SWT.YES) {
					if (NormalView.RUNTIME_TITAN != view.runtimeType) {
						// Sprint Titan doesn't support restart yet.
						System.getProperties().put("eworkbench.returnCode", new Integer(PlatformUI.RETURN_OK)); //$NON-NLS-1$
						PlatformUI.getWorkbench().close();
						return;
					}
					else {
						// Sprint Titan doesn't support restart yet.
						view.deletedFeatures.add(uninstalledFeature.getVersionedIdentifier());
						setVisible(false);
						view.showScreen(view.ROOT_SCREEN, view.REFRESH_IT);
					}
				}
			}
			else if (status == FINISHED_AUTO_RESTART) {
				if (NormalView.RUNTIME_TITAN == view.runtimeType)
					buttonSet = SWT.OK;
				else
					buttonSet = SWT.YES | SWT.NO;
				MessageBox mb2 = new MessageBox(screen.getShell(), SWT.ICON_INFORMATION | buttonSet);
				mb2.setText(UIMessages.ConfirmRestart);
				mb2.setMessage(NLS.bind(UIMessages.RecommendToRestart, view.RuntimeName));
				result = mb2.open();
//Remove the following code when duplicated-timerExec() bug is fixed.
				isMessageBoxOpening = false;
//End.
				if (result == SWT.YES) {
					if (NormalView.RUNTIME_TITAN != view.runtimeType) {
						// Sprint Titan doesn't support restart yet.
						System.getProperties().put("eworkbench.returnCode", new Integer(PlatformUI.RETURN_RESTART)); //$NON-NLS-1$
						PlatformUI.getWorkbench().close();
						return;
					}
					else {
						// Sprint Titan doesn't support restart yet.
						view.deletedFeatures.add(uninstalledFeature.getVersionedIdentifier());
						setVisible(false);
						view.showScreen(view.ROOT_SCREEN, view.REFRESH_IT);
					}
				}
				else {
					view.deletedFeatures.add(uninstalledFeature.getVersionedIdentifier());
					setVisible(false);
					view.showScreen(view.ROOT_SCREEN, view.REFRESH_IT);
				}

			}
			else if (status == FAILED) {
				MessageBox mb3 = new MessageBox(screen.getShell(), SWT.ICON_ERROR | SWT.OK);
				mb3.setText(UIMessages.UninstallStatus);
				mb3.setMessage(UIMessages.UninstallNotCompleted);
				mb3.open();
//Remove the following code when duplicated-timerExec() bug is fixed.
				isMessageBoxOpening = false;
//End.
				setVisible(false);
				view.showScreen(view.ROOT_SCREEN, view.REFRESH_IT);
			}

		}
		
		public void setStatus(int s) {
			status = s;
		}
	}
}
