/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import org.eclipse.core.runtime.IProgressMonitor;

public class UpdateMonitor implements IProgressMonitor {

	private boolean isCanceldNow = false;
	private boolean allDone = false;
	private String name;
	private String taskName;
	private String subTaskName;
	private int totalWork;
	double doneWork = 0;

	private boolean enableDebug = false;

	public UpdateMonitor() {	
	}

	public void beginTask(String name, int totalWork) {
		this.name = name;
		this.totalWork = totalWork;
		this.doneWork = 0;

		if (enableDebug)
			System.out.println("[UpdateMonitor] Task begins.(name=\"" + name + "\", total work=" + totalWork + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	public void done() {
		allDone = true;

		if (enableDebug)
			System.out.println("[UpdateMonitor] Done!"); //$NON-NLS-1$
	}

	public void internalWorked(double work) {
		doneWork+=work;

		if (enableDebug)
			System.out.println("[UpdateMonitor] Progress now is " + doneWork + " / " + totalWork); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public boolean isCanceled() {
		if (enableDebug)
			System.out.println("[UpdateMonitor] Cancel status(" + isCanceldNow + ") is checked."); //$NON-NLS-1$ //$NON-NLS-2$
			
		return isCanceldNow;
	}

	public void setCanceled(boolean value) {
		this.isCanceldNow = value;

		if (enableDebug)
			System.out.println("[UpdateMonitor] Cancel value is set as " + isCanceldNow); //$NON-NLS-1$
	}

	public void setTaskName(String name) {
		this.taskName = name;

		if (enableDebug)
			System.out.println("[UpdateMonitor] Task Name: " + name); //$NON-NLS-1$
	}

	public void subTask(String name) {
		this.subTaskName = name;

		if (enableDebug)
			System.out.println("[UpdateMonitor] Sub Task : (" + name + ")"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void worked(int work) {
		doneWork+=work;

		if (enableDebug)
			System.out.println("[UpdateMonitor] Progress now is " + doneWork + " / " + totalWork); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/*
	 * 
	 */
	public boolean isDone() {
		return allDone;
	}

	/*
	 * 
	 */
	public String getName() {
		return name;
	}

	/*
	 * 
	 */
	public String getTaskName() {
		return taskName;
	}

	/*
	 * 
	 */
	public String getSubTaskName() {
		return subTaskName;
	}

	/*
	 * 
	 */
	public int getTotalWorksCount() {
		return totalWork;
	}

	/*
	 * 
	 */
	public double getDoneWorksCount() {
		return doneWork;
	}

	/*
	 * 
	 */
	public void setDebug(boolean enabled) {
		this.enableDebug = enabled;
	}
}
