/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.update.views;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class WrappedLabel extends Composite {
	public Label label;
	private int maxLabelHeight = Integer.MAX_VALUE;

	public WrappedLabel(Composite parent, int compositeAttribute, int labelAttribute) {
		super(parent, compositeAttribute);
		init(labelAttribute, -1);
	}

	public WrappedLabel(Composite parent, int compositeAttribute, int labelAttribute, int maxLineCount) {
		super(parent, compositeAttribute);
		init(labelAttribute, maxLineCount);
	}

	private void init(int labelAttribute, int maxLineCount) {
		this.setLayout(new FormLayout());
		this.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		label = new Label(this, labelAttribute | SWT.WRAP);
		FormData fdName = new FormData();
		fdName.top = new FormAttachment(0, 0);
		fdName.bottom = new FormAttachment(100, 0);
		fdName.left = new FormAttachment(0, 0);
		fdName.right = new FormAttachment(100, 0);
		label.setLayoutData(fdName);

		if (maxLineCount != -1) {
			label.setText(""); //$NON-NLS-1$
			maxLabelHeight = label.computeSize(SWT.DEFAULT, SWT.DEFAULT).y * maxLineCount;
		}
	}

	public Rectangle computeTrim(int x, int y, int width, int height) {
		Rectangle result = super.computeTrim(x, y, width, height);
		if (result.height > maxLabelHeight) {
			return new Rectangle(result.x, result.y, result.width, maxLabelHeight);
		}

		return result;
	}

	public void setText(String labelMessage) {
		label.setText(labelMessage);
	}

	public void setFont(Font labelFont) {
		label.setFont(labelFont);
	}
}
