/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.update.internal.scheduler;

import java.io.File;
import java.net.MalformedURLException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.SiteManager;

public class ScheduledSiteInitialize implements IStartup {

	private static boolean isThereEarlierFeature = false;

	public void earlyStartup() {
		createTargetSite();
	}

	public synchronized static IConfiguredSite createTargetSite() {
		try {
			File workspaceSiteFile = new File(Platform.getLocation() + "\\applications\\eclipse"); //$NON-NLS-1$
			IInstallConfiguration currentConfig = SiteManager.getLocalSite().getCurrentConfiguration();
			IConfiguredSite workspaceSite = null;
			boolean wasWorkspaceSiteLoaded = false;

			// check if the workspace site is added.
			IConfiguredSite[] allSites = currentConfig.getConfiguredSites();
			for (int i=0; i<allSites.length; i++) {
				if (allSites[i].getSite().getURL().sameFile(workspaceSiteFile.toURL())) {
					wasWorkspaceSiteLoaded = true;
					return allSites[i];
				}
			}

			// if not yet, create the workspace site now.
			if (!wasWorkspaceSiteLoaded) {
				if (!workspaceSiteFile.exists()) {
					workspaceSiteFile.mkdirs();
				}
					
				workspaceSite = currentConfig.createConfiguredSite(workspaceSiteFile);
				currentConfig.addConfiguredSite(workspaceSite);
				workspaceSite.verifyUpdatableStatus();
				SiteManager.getLocalSite().save();
				//ConfiguratorUtils.getCurrentPlatformConfiguration().refresh();
				//OperationsManager.applyChangesNow();
				if (workspaceSite.getConfiguredFeatures().length > 0) {
					// TODO - Julian
					// inform users one more restart is necessary to load earlier features.
					isThereEarlierFeature = true;
				}

				return workspaceSite;
			}
		}
		catch (IllegalStateException ise) {
			ise.printStackTrace();
		}
		catch (CoreException ce) {
			ce.printStackTrace();
		}
		catch (MalformedURLException mue) {
			mue.printStackTrace();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}

	public static boolean isRestartNeeded() {
		return isThereEarlierFeature;
	}
}
