/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.update.util;

import java.net.MalformedURLException;
import java.net.URL;


public class BookmarkSite {

	private String siteName = null;
	private URL siteURL = null;
	private boolean isWeb = false;
	private boolean isSelected = false;
	private boolean isLocal = false;
	private String siteDescription = "";

	public BookmarkSite() {
	}

	public BookmarkSite(String name,
						String url,
						boolean web,
						boolean selected,
						boolean local,
						String description) {

		this.siteName = name;
		setURL(url);
		this.isWeb = web;
		this.isSelected = selected;
		this.isLocal = local;
		if (description != null)
			this.siteDescription = description;
	}

	public void setName(String name)
	{
		this.siteName = name;
	}
	
	public String getName()
	{
		return siteName;
	}

	public void setURL(URL url)
	{
		this.siteURL = url;
	}
	
	public void setURL(String url)
	{
		try {
			this.siteURL = new URL(url);
		}
		catch (MalformedURLException e) {
			this.siteURL = null;
			e.printStackTrace();
			//AppPlugin.log(e);
		}
	}
	
	public URL getURL()
	{
		return siteURL;
	}

	public void setWeb(boolean web)
	{
		this.isWeb = web;
	}
	
	public boolean getWeb()
	{
		return isWeb;
	}

	public void setSelected(boolean selected)
	{
		this.isSelected = selected;
	}
	
	public boolean getSelected()
	{
		return isSelected;
	}

	public void setLocal(boolean local)
	{
		this.isLocal = local;
	}
	
	public boolean getLocal()
	{
		return isLocal;
	}

	public void setDescription(String description)
	{
		if (description != null)
			this.siteDescription = description;
	}
	
	public String getDescription()
	{
		return siteDescription;
	}
}
