/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.update.util;

import java.util.Vector;

public class CategoryWrap implements INode {

	private String label = null;
	private Vector belongedFeatures = new Vector();
	private String description = ""; //$NON-NLS-1$
	boolean selected = false;
	private boolean previousSelected = false;
	Object uiObject = null;

	public CategoryWrap() {
	}

	public CategoryWrap(String label) {
		this.label = label;
	}

	public void addChild(FeatureWrap feature) {
		if (feature != null) {
			belongedFeatures.add(feature);
		}
	}

	public FeatureWrap[] getChildren() {
		return (FeatureWrap[]) belongedFeatures.toArray(new FeatureWrap[belongedFeatures.size()]);
	}

	public Object getUiObject() {
		return uiObject;
	}

	public void setUiObject(Object uiObject) {
		this.uiObject = uiObject;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		if (description != null)
			this.description = description;
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public boolean isPreviousSelected() {
		return previousSelected;
	}

	public void setPreviousSelected(boolean previousSelected) {
		this.previousSelected = previousSelected;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public INode findByUiObject(Object uiObject) {

		if (uiObject.equals(this.uiObject))
			return this;
		else {
			for (int i=0; i< belongedFeatures.size(); i++) {
				INode result = ((INode) belongedFeatures.elementAt(i)).findByUiObject(uiObject);
				if (result != null)
					return result;
			}
		}
		return null;
	}
}
