/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.update.util;

import java.util.Vector;

public class SiteWrap implements INode {

	private String name = null;
	private Vector belongedCategories = new Vector();
	private String description = ""; //$NON-NLS-1$
	boolean selected = false;
	private boolean previousSelected = false;
	Object uiObject = null;

	public SiteWrap() {
	}

	public SiteWrap(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void addChild(CategoryWrap category) {
		if (category != null) {
			belongedCategories.add(category);
		}
	}

	public CategoryWrap[] getChildren() {
		return (CategoryWrap[]) belongedCategories.toArray(new CategoryWrap[belongedCategories.size()]);
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		if (description != null)
			this.description = description;
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public boolean isPreviousSelected() {
		return previousSelected;
	}

	public void setPreviousSelected(boolean previousSelected) {
		this.previousSelected = previousSelected;
	}

	public Object getUiObject() {
		return uiObject;
	}

	public void setUiObject(Object uiObject) {
		this.uiObject = uiObject;
	}

	public INode findByUiObject(Object uiObject) {

		if (uiObject.equals(this.uiObject))
			return this;
		else {
			for (int i=0; i< belongedCategories.size(); i++) {
				INode result = ((INode) belongedCategories.elementAt(i)).findByUiObject(uiObject);
				if (result != null)
					return result;
			}
		}
		return null;
	}
}
