/*******************************************************************************
 * Copyright (c) 2008 Nokia Corporation.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia Corporation - initial implementation
 *******************************************************************************/

#ifndef IMAGELOADER_H_
#define IMAGELOADER_H_

#include "graphics.h"

namespace Java { namespace GFX {

class ImageloaderImpl : public ImageLoader
{
public:
    /**
     * Ctor
     */
    ImageloaderImpl();

    /**
     * Dtor
     */
    virtual ~ImageloaderImpl();
	
    /**
     * from ImageLoader
     * @see ImageLoader
     */
    virtual void append(const char* aData, int aLength, int aOffset);
    virtual void beginStream(int aBufferSize);
    virtual Image* endStream();
    virtual void dispose();
	
private:
    /**
     * Helper method for increasing internal buffer size
     * @param newSize The total buffer size to which the buffer sould be grown to
     * @throws GfxException if memory allocation fails
     */
    void growBuffer(int aNewSize);

    /**
     *  Resets bufferData, i.e. frees resources
     */
    void resetData();
	
    /**
     * Struct for buffer related data
     */
    struct bufferData
    {
        /**
         * Pointer to data buffer
         */
        char* buffer;
    
        /**
         * The total capacity of data buffer
         */
        int capacity;

        /**
         * The total allocation of the data buffer
         */
        int allocation;
    };
    bufferData* mBufferData;
};

} // namespace GFX
} // namespace Java

#endif /*IMAGELOADER_H_*/
