/*******************************************************************************
 * Copyright (c) 2008 Nokia Corporation.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia Corporation - initial implementation
 *******************************************************************************/

//#include <QtOpenGL>
#include "windowsurfaceimpl.h"
#include "gfxlog.h"

namespace Java { namespace GFX {

WindowSurfaceImpl::WindowSurfaceImpl(QPaintDevice* aSurface, int aType)
: mSurface(NULL),
  mTempSurface(NULL),
  mSurfaceType(NoType),
  mTempSurfaceType(NoType),
  mIsBound(false),
  mDirectRendering(true)
{
    GFX_LOG_FUNC_CALL();	
    mSurface = aSurface;
    mSurfaceType = aType;   
}

WindowSurfaceImpl::~WindowSurfaceImpl()
{
    GFX_LOG_FUNC_CALL();
    mSurface = NULL;
    if (mTempSurface != NULL)
    {
        delete mTempSurface;
        mTempSurface = NULL;
    }
}

QPaintDevice* WindowSurfaceImpl::bind(int aCapabilies)
{
    GFX_LOG_FUNC_CALL();
    
    switch (mSurfaceType)
    {
        case SwImage:
        {
            mDirectRendering = true;
        }
        case PBuffer:
        {
            if (aCapabilies & PBuffer) {
                mDirectRendering = true;
            }
            else 
            {   
                /*
                mDirectRendering = false;
                QGLPixelBuffer* pbuffer = static_cast<QGLPixelBuffer*> (mSurface);
                mTempSurface = new(std::nothrow) QImage(pbuffer->toImage());
                aSurface = static_cast<void*>(mTempSurface);
                *aSurfaceType = SwImage;
                mDirectRendering = false; 
                */
            }
            break;
        }
        case FrameBufferObject:
        {
            if (aCapabilies & FrameBufferObject) 
            {
                mDirectRendering = true;       
            }
            else 
            {
                mDirectRendering = false;
                // TODO implementation
            }
            break;
        }
        case VgImage:    
        {
            if (aCapabilies & VgImage) 
            {
                mDirectRendering = true;
            }
            else 
            {
                mDirectRendering = false;
                // TODO implementation
            }
            break;
        }
        default:
        {
            // we should newer get here
            return NULL;
        }
    }
    
    if (mDirectRendering)
    {   
        mIsBound = true;
        return mSurface;
    }
    else 
    {
        mIsBound = true;
        return mTempSurface;
    }
    
}

int WindowSurfaceImpl::getType() 
{
    GFX_LOG_FUNC_CALL();
    if(mDirectRendering) 
    {
        return mSurfaceType;
    }
    else 
    {
        return mTempSurfaceType;    
    }
}

void WindowSurfaceImpl::release()
{
    GFX_LOG_FUNC_CALL();
    if (!mIsBound)
    {
        return;   
    }
    else 
    {
        if (!mDirectRendering)   
        {
            // TODO draw QImage with painter
            if(mTempSurface != NULL)
            {
                delete mTempSurface;
                mTempSurface = NULL;    
            }
        }
        else 
        {
            // pixels are already rendered to the target 
            // no post blitter hook needed
        }   
    }
    mIsBound = false;
}

void WindowSurfaceImpl::dispose() 
{
    GFX_LOG_FUNC_CALL();
    delete this;
}

} // namespace GFX
} // namespace Java
