/*******************************************************************************
 * Copyright (c) 2008 Nokia Corporation.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia Corporation - initial implementation
 *******************************************************************************/
#ifndef WINDOWSURFACEQT_H_
#define WINDOWSURFACEQT_H_

#include "graphics.h"

namespace Java { namespace GFX {

class WindowSurfaceImpl: public WindowSurface 
{
public:
   /**
    * Ctor
    */
    WindowSurfaceImpl(QPaintDevice* surface, int type);

   /**
    * Dtor
    */
    virtual ~WindowSurfaceImpl();
    
    /**
     * From WindowSurface
     * @see WindowSurface
     */
    virtual QPaintDevice* bind(int aCapabilies = SwImage) ;
    virtual int getType();
    virtual void release();
    virtual void dispose();

private:
    QPaintDevice* mSurface;
    QImage* mTempSurface;
    int mSurfaceType;
    int mTempSurfaceType;
    bool mIsBound;    
    bool mDirectRendering;
    
};

} // namespace GFX
} // namespace Java

#endif /*WINDOWSURFACEQT_H_*/
